/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import gnu.xml.xpath.Path;
import gnu.xml.xpath.Pattern;
import gnu.xml.xpath.Root;
import gnu.xml.xpath.Selector;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public final class Steps
extends Path {
    final LinkedList path;

    public final boolean matches(Node context) {
        return this.matches(context, this.path.size() - 1);
    }

    final boolean matches(Node context, int pos) {
        Pattern right = (Pattern)this.path.get(pos);
        if (!right.matches(context)) {
            return false;
        }
        if (pos > 0) {
            Pattern left = (Pattern)this.path.get(pos - 1);
            Iterator j = this.possibleContexts(right, context).iterator();
            while (j.hasNext()) {
                Node candidate = (Node)j.next();
                if (!left.matches(candidate) || !this.matches(candidate, pos - 1)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    final Collection possibleContexts(Pattern pattern2, Node context) {
        if (pattern2 instanceof Selector) {
            Selector s = (Selector)pattern2;
            LinkedHashSet candidates = new LinkedHashSet();
            switch (s.axis) {
                case 9: {
                    s.addChildNodes(context, candidates, false);
                    break;
                }
                case 0: {
                    s.addChildNodes(context, candidates, true);
                    break;
                }
                case 1: {
                    candidates.add(context);
                    s.addChildNodes(context, candidates, true);
                    break;
                }
                case 3: {
                    s.addParentNode(context, candidates, false);
                    break;
                }
                case 4: {
                    s.addParentNode(context, candidates, true);
                    break;
                }
                case 5: {
                    candidates.add(context);
                    s.addParentNode(context, candidates, true);
                    break;
                }
                case 11: {
                    s.addFollowingNodes(context, candidates, false);
                    break;
                }
                case 7: {
                    s.addPrecedingNodes(context, candidates, false);
                    break;
                }
                case 10: {
                    s.addFollowingNodes(context, candidates, true);
                    break;
                }
                case 6: {
                    s.addPrecedingNodes(context, candidates, true);
                    break;
                }
                case 2: 
                case 8: {
                    if (context.getNodeType() != 2) break;
                    candidates.add(((Attr)context).getOwnerElement());
                    break;
                }
                case 12: {
                    candidates.add(context);
                    break;
                }
            }
            return candidates;
        }
        return Collections.EMPTY_SET;
    }

    public final Object evaluate(Node context, int pos, int len) {
        Iterator i = this.path.iterator();
        Expr lhs = (Expr)i.next();
        Object val = lhs.evaluate(context, pos, len);
        while (val instanceof Collection && i.hasNext()) {
            Path rhs = (Path)i.next();
            val = rhs.evaluate(context, (Collection)val);
        }
        return val;
    }

    final Collection evaluate(Node context, Collection ns) {
        Iterator i = this.path.iterator();
        Expr lhs = (Expr)i.next();
        if (lhs instanceof Path) {
            ns = ((Path)lhs).evaluate(context, ns);
        } else {
            LinkedHashSet acc = new LinkedHashSet();
            int pos = 1;
            int len = ns.size();
            Iterator j = ns.iterator();
            while (j.hasNext()) {
                Node node2 = (Node)j.next();
                Object ret = lhs.evaluate(node2, pos++, len);
                if (!(ret instanceof Collection)) continue;
                acc.addAll((Collection)ret);
            }
            ns = acc;
        }
        while (i.hasNext()) {
            Path rhs = (Path)i.next();
            ns = rhs.evaluate(context, ns);
        }
        return ns;
    }

    public final Expr clone(Object context) {
        int len = this.path.size();
        LinkedList path2 = new LinkedList();
        int i = 0;
        while (i < len) {
            path2.add(((Expr)this.path.get(i)).clone(context));
            ++i;
        }
        return new Steps(path2);
    }

    public final boolean references(QName var) {
        Iterator i = this.path.iterator();
        while (i.hasNext()) {
            if (!((Expr)i.next()).references(var)) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator i = this.path.iterator();
        Expr expr = (Expr)i.next();
        if (!(expr instanceof Root)) {
            buf.append(expr);
        }
        while (i.hasNext()) {
            expr = (Expr)i.next();
            buf.append('/');
            buf.append(expr);
        }
        return buf.toString();
    }

    public Steps() {
        this(new LinkedList());
    }

    Steps(LinkedList path) {
        this.path = path;
    }
}

