require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ARM_PSL_H_)) {
    eval 'sub _ARM_PSL_H_ () {1;}' unless defined(&_ARM_PSL_H_);
    require 'machine/intr.ph';
    eval 'sub spl0 () {
        eval q( &splx( &IPL_NONE));
    }' unless defined(&spl0);
    eval 'sub splsoftclock () {
        eval q( &raisespl( &IPL_SOFTCLOCK));
    }' unless defined(&splsoftclock);
    eval 'sub splsoftbio () {
        eval q( &raisespl( &IPL_SOFTBIO));
    }' unless defined(&splsoftbio);
    eval 'sub splsoftnet () {
        eval q( &raisespl( &IPL_SOFTNET));
    }' unless defined(&splsoftnet);
    eval 'sub splsoftserial () {
        eval q( &raisespl( &IPL_SOFTSERIAL));
    }' unless defined(&splsoftserial);
    eval 'sub splvm () {
        eval q( &raisespl( &IPL_VM));
    }' unless defined(&splvm);
    eval 'sub splsched () {
        eval q( &raisespl( &IPL_SCHED));
    }' unless defined(&splsched);
    eval 'sub splhigh () {
        eval q( &raisespl( &IPL_HIGH));
    }' unless defined(&splhigh);
    eval 'sub IPL_SAFEPRI () { &IPL_NONE;}' unless defined(&IPL_SAFEPRI);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    require 'sys/types.ph';
	    eval 'sub makeiplcookie {
	        my($ipl) = @_;
    		eval q({ ( &ipl_cookie_t){. &_ipl = ( &uint8_t)$ipl}; });
	    }' unless defined(&makeiplcookie);
	    eval 'sub splraiseipl {
	        my($icookie) = @_;
    		eval q({  &raisespl( ($icookie->{_ipl})); });
	    }' unless defined(&splraiseipl);
	}
    }
}
1;
