/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.peer.gtk.GtkClipboard;
import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StringBufferInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class GtkSelection
implements Transferable {
    private static Object requestLock = new Object();
    private boolean requestInProgress;
    private boolean mimeTypesDelivered;
    private DataFlavor[] dataFlavors;
    private boolean textDelivered;
    private String text;
    private boolean imageDelivered;
    private Pointer imagePointer;
    private Image image;
    private boolean urisDelivered;
    private List uris;
    private boolean bytesDelivered;
    private byte[] bytes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataFlavor[] getTransferDataFlavors() {
        var2_1 = GtkSelection.requestLock;
        synchronized (var2_1) {
            block11: {
                if (this.mimeTypesDelivered) {
                    return (DataFlavor[])this.dataFlavors.clone();
                }
                while (true) {
                    block12: {
                        if (this.requestInProgress) break block12;
                        if (this.mimeTypesDelivered) break block11;
                        this.requestInProgress = true;
                        this.requestMimeTypes();
                        if (true) ** GOTO lbl28
                    }
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                do {
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
lbl28:
                    // 3 sources

                } while (!this.mimeTypesDelivered);
                this.requestInProgress = false;
            }
            result = this.dataFlavors;
            if (!GtkClipboard.canCache) {
                this.dataFlavors = null;
                this.mimeTypesDelivered = false;
            }
            GtkSelection.requestLock.notifyAll();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void mimeTypesAvailable(String[] mimeTypes) {
        var2_2 = GtkSelection.requestLock;
        synchronized (var2_2) {
            block13: {
                block12: {
                    if (mimeTypes != null) break block12;
                    this.dataFlavors = new DataFlavor[0];
                    break block13;
                }
                flavorsList = new ArrayList(mimeTypes.length + 1);
                i = 0;
                if (true) ** GOTO lbl46
            }
lbl14:
            // 2 sources

            while (true) {
                this.mimeTypesDelivered = true;
                GtkSelection.requestLock.notifyAll();
                return;
            }
            do {
                block14: {
                    try {
                        if (mimeTypes[i] == GtkClipboard.stringMimeType) {
                            flavorsList.add(DataFlavor.stringFlavor);
                            flavorsList.add(DataFlavor.plainTextFlavor);
                            break block14;
                        }
                        if (mimeTypes[i] == GtkClipboard.imageMimeType) {
                            flavorsList.add(DataFlavor.imageFlavor);
                            break block14;
                        }
                        if (mimeTypes[i] == GtkClipboard.filesMimeType) {
                            flavorsList.add(DataFlavor.javaFileListFlavor);
                            break block14;
                        }
                        target = new DataFlavor(mimeTypes[i]);
                        if (!flavorsList.contains(target)) {
                            flavorsList.add(target);
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        cnfe.printStackTrace();
                    }
                    catch (NullPointerException npe) {
                        npe.printStackTrace();
                    }
                }
                ++i;
lbl46:
                // 2 sources

            } while (i < mimeTypes.length);
            this.dataFlavors = new DataFlavor[flavorsList.size()];
            flavorsList.toArray(this.dataFlavors);
            ** continue;
        }
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] dfs = this.getTransferDataFlavors();
        int i = 0;
        while (i < dfs.length) {
            if (flavor.equals(dfs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String getText() {
        var2_1 = GtkSelection.requestLock;
        synchronized (var2_1) {
            block11: {
                if (this.textDelivered) {
                    return this.text;
                }
                while (true) {
                    block12: {
                        if (this.requestInProgress) break block12;
                        if (this.textDelivered) break block11;
                        this.requestInProgress = true;
                        this.requestText();
                        if (true) ** GOTO lbl28
                    }
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                do {
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
lbl28:
                    // 3 sources

                } while (!this.textDelivered);
                this.requestInProgress = false;
            }
            result = this.text;
            if (!GtkClipboard.canCache) {
                this.text = null;
                this.textDelivered = false;
            }
            GtkSelection.requestLock.notifyAll();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void textAvailable(String text) {
        Object object = requestLock;
        synchronized (object) {
            this.text = text;
            this.textDelivered = true;
            requestLock.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Image getImage() {
        var2_1 = GtkSelection.requestLock;
        synchronized (var2_1) {
            block12: {
                if (this.imageDelivered) {
                    return this.image;
                }
                while (true) {
                    block13: {
                        if (this.requestInProgress) break block13;
                        if (this.imageDelivered) break block12;
                        this.requestInProgress = true;
                        this.requestImage();
                        if (true) ** GOTO lbl28
                    }
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                do {
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
lbl28:
                    // 3 sources

                } while (!this.imageDelivered);
                this.requestInProgress = false;
            }
            if (this.imagePointer != null) {
                this.image = new GtkImage(this.imagePointer);
            }
            this.imagePointer = null;
            result = this.image;
            if (!GtkClipboard.canCache) {
                this.image = null;
                this.imageDelivered = false;
            }
            GtkSelection.requestLock.notifyAll();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void imageAvailable(Pointer pointer) {
        Object object = requestLock;
        synchronized (object) {
            this.imagePointer = pointer;
            this.imageDelivered = true;
            requestLock.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final List getURIs() {
        var2_1 = GtkSelection.requestLock;
        synchronized (var2_1) {
            block11: {
                if (this.urisDelivered) {
                    return this.uris;
                }
                while (true) {
                    block12: {
                        if (this.requestInProgress) break block12;
                        if (this.urisDelivered) break block11;
                        this.requestInProgress = true;
                        this.requestURIs();
                        if (true) ** GOTO lbl28
                    }
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                do {
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
lbl28:
                    // 3 sources

                } while (!this.urisDelivered);
                this.requestInProgress = false;
            }
            result = this.uris;
            if (!GtkClipboard.canCache) {
                this.uris = null;
                this.urisDelivered = false;
            }
            GtkSelection.requestLock.notifyAll();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void urisAvailable(String[] uris) {
        Object object = requestLock;
        synchronized (object) {
            block8: {
                if (uris == null || uris.length == 0) break block8;
                ArrayList list2 = new ArrayList(uris.length);
                int i = 0;
                while (true) {
                    if (i >= uris.length) {
                        this.uris = list2;
                        break;
                    }
                    try {
                        URI uri = new URI(uris[i]);
                        if (uri.getScheme().equals("file")) {
                            list2.add(new File(uri));
                        }
                    }
                    catch (URISyntaxException use) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            this.urisDelivered = true;
            requestLock.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] getBytes(String target) {
        var3_2 = GtkSelection.requestLock;
        synchronized (var3_2) {
            while (true) {
                block9: {
                    if (this.requestInProgress) break block9;
                    this.requestInProgress = true;
                    this.requestBytes(target);
                    if (true) ** GOTO lbl25
                }
                try {
                    GtkSelection.requestLock.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            do {
                try {
                    GtkSelection.requestLock.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
lbl25:
                // 3 sources

            } while (!this.bytesDelivered);
            result = this.bytes;
            this.bytes = null;
            this.bytesDelivered = false;
            this.requestInProgress = false;
            GtkSelection.requestLock.notifyAll();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void bytesAvailable(byte[] bytes) {
        Object object = requestLock;
        synchronized (object) {
            this.bytes = bytes;
            this.bytesDelivered = true;
            requestLock.notifyAll();
            return;
        }
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        byte[] bytes;
        List uris;
        Image image;
        String text;
        if (flavor.equals(DataFlavor.stringFlavor) && (text = this.getText()) != null) {
            return text;
        }
        if (flavor.equals(DataFlavor.plainTextFlavor) && (text = this.getText()) != null) {
            return new StringBufferInputStream(text);
        }
        if (flavor.equals(DataFlavor.imageFlavor) && (image = this.getImage()) != null) {
            return image;
        }
        if (flavor.equals(DataFlavor.javaFileListFlavor) && (uris = this.getURIs()) != null) {
            return bytes;
        }
        bytes = this.getBytes(flavor.getMimeType());
        if (bytes == null) {
            throw new UnsupportedFlavorException(flavor);
        }
        if (flavor.isMimeTypeSerializedObject()) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bais);
                return ois.readObject();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
        }
        if (flavor.isRepresentationClassInputStream()) {
            return new ByteArrayInputStream(bytes);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    private final native void requestText();

    private final native void requestImage();

    private final native void requestURIs();

    private final native void requestBytes(String var1);

    private final native void requestMimeTypes();

    GtkSelection() {
    }
}

