/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.DistributionBoundApache;
import org.apache.cassandra.stress.generate.DistributionFactory;
import org.apache.cassandra.stress.generate.DistributionFixed;
import org.apache.cassandra.stress.generate.DistributionInverted;
import org.apache.cassandra.stress.generate.DistributionOffsetApache;
import org.apache.cassandra.stress.generate.DistributionQuantized;
import org.apache.cassandra.stress.generate.DistributionSequence;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.distribution.WeibullDistribution;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;

public class OptionDistribution
extends Option {
    public static final Function<String, DistributionFactory> BUILDER = new Function<String, DistributionFactory>(){

        public DistributionFactory apply(String s) {
            return OptionDistribution.get(s);
        }
    };
    private static final Pattern FULL = Pattern.compile("(~?)([A-Z]+)\\((.+)\\)", 2);
    private static final Pattern ARGS = Pattern.compile("[^,]+");
    final String prefix;
    private String spec;
    private final String defaultSpec;
    private final String description;
    private final boolean required;
    private static final Map<String, Impl> LOOKUP;

    public OptionDistribution(String prefix, String defaultSpec, String description) {
        this(prefix, defaultSpec, description, defaultSpec == null);
    }

    public OptionDistribution(String prefix, String defaultSpec, String description, boolean required) {
        this.prefix = prefix;
        this.defaultSpec = defaultSpec;
        this.description = description;
        this.required = required;
    }

    @Override
    public boolean accept(String param) {
        if (!param.toLowerCase().startsWith(this.prefix)) {
            return false;
        }
        this.spec = param.substring(this.prefix.length());
        return true;
    }

    public static DistributionFactory get(String spec) {
        Matcher m = FULL.matcher(spec);
        if (!m.matches()) {
            throw new IllegalArgumentException("Illegal distribution specification: " + spec);
        }
        boolean inverse = m.group(1).equals("~");
        String name = m.group(2);
        Impl impl = LOOKUP.get(name.toLowerCase());
        if (impl == null) {
            throw new IllegalArgumentException("Illegal distribution type: " + name);
        }
        ArrayList<String> params = new ArrayList<String>();
        m = ARGS.matcher(m.group(3));
        while (m.find()) {
            params.add(m.group());
        }
        DistributionFactory factory = impl.getFactory(params);
        return inverse ? new InverseFactory(factory) : factory;
    }

    public DistributionFactory get() {
        return this.spec != null ? OptionDistribution.get(this.spec) : (this.defaultSpec != null ? OptionDistribution.get(this.defaultSpec) : null);
    }

    @Override
    public boolean happy() {
        return !this.required || this.spec != null;
    }

    @Override
    public String longDisplay() {
        return this.shortDisplay() + ": " + this.description;
    }

    @Override
    public List<String> multiLineDisplay() {
        return Arrays.asList(GroupedOptions.formatMultiLine("EXP(min..max)", "An exponential distribution over the range [min..max]"), GroupedOptions.formatMultiLine("EXTREME(min..max,shape)", "An extreme value (Weibull) distribution over the range [min..max]"), GroupedOptions.formatMultiLine("QEXTREME(min..max,shape,quantas)", "An extreme value, split into quantas, within which the chance of selection is uniform"), GroupedOptions.formatMultiLine("GAUSSIAN(min..max,stdvrng)", "A gaussian/normal distribution, where mean=(min+max)/2, and stdev is (mean-min)/stdvrng"), GroupedOptions.formatMultiLine("GAUSSIAN(min..max,mean,stdev)", "A gaussian/normal distribution, with explicitly defined mean and stdev"), GroupedOptions.formatMultiLine("UNIFORM(min..max)", "A uniform distribution over the range [min, max]"), GroupedOptions.formatMultiLine("FIXED(val)", "A fixed distribution, always returning the same value"), GroupedOptions.formatMultiLine("SEQ(min..max)", "A fixed sequence, returning values in the range min to max sequentially (starting based on seed), wrapping if necessary."), "Preceding the name with ~ will invert the distribution, e.g. ~exp(1..10) will yield 10 most, instead of least, often", "Aliases: extr, qextr, gauss, normal, norm, weibull");
    }

    @Override
    boolean setByUser() {
        return this.spec != null;
    }

    @Override
    boolean present() {
        return this.setByUser() || this.defaultSpec != null;
    }

    @Override
    public String shortDisplay() {
        return (this.defaultSpec != null ? "[" : "") + this.prefix + "DIST(?)" + (this.defaultSpec != null ? "]" : "");
    }

    @Override
    public String getOptionAsString() {
        return this.prefix + (this.spec == null ? this.defaultSpec : this.spec);
    }

    public static long parseLong(String value) {
        long multiplier = 1L;
        value = value.trim().toLowerCase();
        switch (value.charAt(value.length() - 1)) {
            case 'b': {
                multiplier *= 1000L;
            }
            case 'm': {
                multiplier *= 1000L;
            }
            case 'k': {
                multiplier *= 1000L;
                value = value.substring(0, value.length() - 1);
            }
        }
        return Long.parseLong(value) * multiplier;
    }

    @Override
    public int hashCode() {
        return this.prefix.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        return super.equals(that) && ((OptionDistribution)that).prefix.equals(this.prefix);
    }

    static {
        HashMap<String, Impl> lookup = new HashMap<String, Impl>();
        lookup.put("exp", new ExponentialImpl());
        lookup.put("extr", new ExtremeImpl());
        lookup.put("qextr", new QuantizedExtremeImpl());
        lookup.put("extreme", (Impl)lookup.get("extr"));
        lookup.put("qextreme", (Impl)lookup.get("qextr"));
        lookup.put("weibull", (Impl)lookup.get("weibull"));
        lookup.put("gaussian", new GaussianImpl());
        lookup.put("normal", (Impl)lookup.get("gaussian"));
        lookup.put("gauss", (Impl)lookup.get("gaussian"));
        lookup.put("norm", (Impl)lookup.get("gaussian"));
        lookup.put("uniform", new UniformImpl());
        lookup.put("fixed", new FixedImpl());
        lookup.put("seq", new SequenceImpl());
        LOOKUP = lookup;
    }

    private static final class SequenceFactory
    implements DistributionFactory {
        final long start;
        final long end;

        private SequenceFactory(long start, long end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public Distribution get() {
            return new DistributionSequence(this.start, this.end);
        }

        @Override
        public String getConfigAsString() {
            return String.format("Sequence:  start=%d,end=%d", this.start, this.end);
        }
    }

    private static final class FixedFactory
    implements DistributionFactory {
        final long key;

        private FixedFactory(long key) {
            this.key = key;
        }

        @Override
        public Distribution get() {
            return new DistributionFixed(this.key);
        }

        @Override
        public String getConfigAsString() {
            return String.format("Fixed:  key=%d", this.key);
        }
    }

    private static final class UniformFactory
    implements DistributionFactory {
        final long min;
        final long max;

        private UniformFactory(long min, long max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public Distribution get() {
            return new DistributionBoundApache((AbstractRealDistribution)new UniformRealDistribution((RandomGenerator)new JDKRandomGenerator(), (double)this.min, (double)(this.max + 1L)), this.min, this.max);
        }

        @Override
        public String getConfigAsString() {
            return String.format("Uniform:  min=%d,max=%d", this.min, this.max);
        }
    }

    private static final class GaussianFactory
    implements DistributionFactory {
        final long min;
        final long max;
        final double mean;
        final double stdev;

        private GaussianFactory(long min, long max, double mean, double stdev) {
            this.min = min;
            this.max = max;
            this.stdev = stdev;
            this.mean = mean;
        }

        @Override
        public Distribution get() {
            return new DistributionBoundApache((AbstractRealDistribution)new NormalDistribution((RandomGenerator)new JDKRandomGenerator(), this.mean, this.stdev, 1.0E-9), this.min, this.max);
        }

        @Override
        public String getConfigAsString() {
            return String.format("Gaussian:  min=%d,max=%d,mean=%f,stdev=%f", this.min, this.max, this.mean, this.stdev);
        }
    }

    private static final class QuantizedExtremeFactory
    extends ExtremeFactory {
        final int quantas;

        private QuantizedExtremeFactory(long min, long max, double shape, double scale, int quantas) {
            super(min, max, shape, scale);
            this.quantas = quantas;
        }

        @Override
        public Distribution get() {
            return new DistributionQuantized(new DistributionOffsetApache((AbstractRealDistribution)new WeibullDistribution((RandomGenerator)new JDKRandomGenerator(), this.shape, this.scale, 1.0E-9), this.min, this.max), this.quantas);
        }
    }

    private static class ExtremeFactory
    implements DistributionFactory {
        final long min;
        final long max;
        final double shape;
        final double scale;

        private ExtremeFactory(long min, long max, double shape, double scale) {
            this.min = min;
            this.max = max;
            this.shape = shape;
            this.scale = scale;
        }

        @Override
        public Distribution get() {
            return new DistributionOffsetApache((AbstractRealDistribution)new WeibullDistribution((RandomGenerator)new JDKRandomGenerator(), this.shape, this.scale, 1.0E-9), this.min, this.max);
        }

        @Override
        public String getConfigAsString() {
            return String.format("Extreme:  min=%d,max=%d,shape=%f, scale=%f", this.min, this.max, this.shape, this.scale);
        }
    }

    private static final class ExpFactory
    implements DistributionFactory {
        final long min;
        final long max;
        final double mean;

        private ExpFactory(long min, long max, double mean) {
            this.min = min;
            this.max = max;
            this.mean = mean;
        }

        @Override
        public Distribution get() {
            return new DistributionOffsetApache((AbstractRealDistribution)new ExponentialDistribution((RandomGenerator)new JDKRandomGenerator(), this.mean, 1.0E-9), this.min, this.max);
        }

        @Override
        public String getConfigAsString() {
            return String.format("Exponential:  min=%d,max=%d,mean=%f", this.min, this.max, this.mean);
        }
    }

    private static final class InverseFactory
    implements DistributionFactory {
        final DistributionFactory wrapped;

        private InverseFactory(DistributionFactory wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public Distribution get() {
            return new DistributionInverted(this.wrapped.get());
        }

        @Override
        public String getConfigAsString() {
            return "Inverse: " + this.wrapped.getConfigAsString();
        }
    }

    private static final class SequenceImpl
    implements Impl {
        private SequenceImpl() {
        }

        @Override
        public DistributionFactory getFactory(List<String> params) {
            long max;
            long min;
            if (params.size() != 1) {
                throw new IllegalArgumentException("Invalid parameter list for sequence distribution: " + params);
            }
            try {
                String[] bounds = params.get(0).split("\\.\\.+");
                min = OptionDistribution.parseLong(bounds[0]);
                max = OptionDistribution.parseLong(bounds[1]);
            }
            catch (Exception ignore) {
                throw new IllegalArgumentException("Invalid parameter list for sequence distribution: " + params);
            }
            if (min == max) {
                throw new IllegalArgumentException("Invalid parameter list for sequence distribution (min==max): " + params);
            }
            if (min > max) {
                throw new IllegalArgumentException("Invalid parameter list for sequence distribution (min>max): " + params);
            }
            return new SequenceFactory(min, max);
        }
    }

    private static final class FixedImpl
    implements Impl {
        private FixedImpl() {
        }

        @Override
        public DistributionFactory getFactory(List<String> params) {
            if (params.size() != 1) {
                throw new IllegalArgumentException("Invalid parameter list for fixed distribution: " + params);
            }
            try {
                long key = OptionDistribution.parseLong(params.get(0));
                return new FixedFactory(key);
            }
            catch (Exception ignore) {
                throw new IllegalArgumentException("Invalid parameter list for fixed distribution: " + params);
            }
        }
    }

    private static final class UniformImpl
    implements Impl {
        private UniformImpl() {
        }

        @Override
        public DistributionFactory getFactory(List<String> params) {
            if (params.size() != 1) {
                throw new IllegalArgumentException("Invalid parameter list for uniform distribution: " + params);
            }
            try {
                String[] bounds = params.get(0).split("\\.\\.+");
                long min = OptionDistribution.parseLong(bounds[0]);
                long max = OptionDistribution.parseLong(bounds[1]);
                if (min == max) {
                    return new FixedFactory(min);
                }
                return new UniformFactory(min, max);
            }
            catch (Exception ignore) {
                throw new IllegalArgumentException("Invalid parameter list for uniform distribution: " + params);
            }
        }
    }

    private static final class QuantizedExtremeImpl
    implements Impl {
        private QuantizedExtremeImpl() {
        }

        @Override
        public DistributionFactory getFactory(List<String> params) {
            if (params.size() != 3) {
                throw new IllegalArgumentException("Invalid parameter list for quantized extreme (Weibull) distribution: " + params);
            }
            try {
                String[] bounds = params.get(0).split("\\.\\.+");
                long min = OptionDistribution.parseLong(bounds[0]);
                long max = OptionDistribution.parseLong(bounds[1]);
                double shape = Double.parseDouble(params.get(1));
                int quantas = Integer.parseInt(params.get(2));
                WeibullDistribution findBounds = new WeibullDistribution(shape, 1.0);
                double scale = (double)(max - min) / findBounds.inverseCumulativeProbability(1.0 - Math.sqrt(1.0 / (double)(max - min)));
                if (min == max) {
                    return new FixedFactory(min);
                }
                return new QuantizedExtremeFactory(min, max, shape, scale, quantas);
            }
            catch (Exception ignore) {
                throw new IllegalArgumentException("Invalid parameter list for quantized extreme (Weibull) distribution: " + params);
            }
        }
    }

    private static final class ExtremeImpl
    implements Impl {
        private ExtremeImpl() {
        }

        @Override
        public DistributionFactory getFactory(List<String> params) {
            if (params.size() != 2) {
                throw new IllegalArgumentException("Invalid parameter list for extreme (Weibull) distribution: " + params);
            }
            try {
                String[] bounds = params.get(0).split("\\.\\.+");
                long min = OptionDistribution.parseLong(bounds[0]);
                long max = OptionDistribution.parseLong(bounds[1]);
                if (min == max) {
                    return new FixedFactory(min);
                }
                double shape = Double.parseDouble(params.get(1));
                WeibullDistribution findBounds = new WeibullDistribution(shape, 1.0);
                double scale = (double)(max - min) / findBounds.inverseCumulativeProbability(1.0 - Math.sqrt(1.0 / (double)(max - min)));
                return new ExtremeFactory(min, max, shape, scale);
            }
            catch (Exception ignore) {
                throw new IllegalArgumentException("Invalid parameter list for extreme (Weibull) distribution: " + params);
            }
        }
    }

    private static final class ExponentialImpl
    implements Impl {
        private ExponentialImpl() {
        }

        @Override
        public DistributionFactory getFactory(List<String> params) {
            if (params.size() != 1) {
                throw new IllegalArgumentException("Invalid parameter list for gaussian distribution: " + params);
            }
            try {
                String[] bounds = params.get(0).split("\\.\\.+");
                long min = OptionDistribution.parseLong(bounds[0]);
                long max = OptionDistribution.parseLong(bounds[1]);
                if (min == max) {
                    return new FixedFactory(min);
                }
                ExponentialDistribution findBounds = new ExponentialDistribution(1.0);
                double mean = (double)(max - min) / findBounds.inverseCumulativeProbability(1.0 - Math.sqrt(1.0 / (double)(max - min)));
                return new ExpFactory(min, max, mean);
            }
            catch (Exception ignore) {
                throw new IllegalArgumentException("Invalid parameter list for uniform distribution: " + params);
            }
        }
    }

    private static final class GaussianImpl
    implements Impl {
        private GaussianImpl() {
        }

        @Override
        public DistributionFactory getFactory(List<String> params) {
            if (params.size() > 3 || params.size() < 1) {
                throw new IllegalArgumentException("Invalid parameter list for gaussian distribution: " + params);
            }
            try {
                double stdev;
                double mean;
                String[] bounds = params.get(0).split("\\.\\.+");
                long min = OptionDistribution.parseLong(bounds[0]);
                long max = OptionDistribution.parseLong(bounds[1]);
                if (params.size() == 3) {
                    mean = Double.parseDouble(params.get(1));
                    stdev = Double.parseDouble(params.get(2));
                } else {
                    double stdevsToEdge = params.size() == 1 ? 3.0 : Double.parseDouble(params.get(1));
                    mean = (double)(min + max) / 2.0;
                    stdev = (double)(max - min) / 2.0 / stdevsToEdge;
                }
                if (min == max) {
                    return new FixedFactory(min);
                }
                return new GaussianFactory(min, max, mean, stdev);
            }
            catch (Exception ignore) {
                throw new IllegalArgumentException("Invalid parameter list for uniform distribution: " + params);
            }
        }
    }

    private static interface Impl {
        public DistributionFactory getFactory(List<String> var1);
    }
}

