/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.sql.action.SqlQueryRequest;
import org.elasticsearch.xpack.sql.action.SqlQueryResponse;
import org.elasticsearch.xpack.sql.execution.PlanExecutor;
import org.elasticsearch.xpack.sql.plugin.SqlLicenseChecker;
import org.elasticsearch.xpack.sql.plugin.Transports;
import org.elasticsearch.xpack.sql.proto.ColumnInfo;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.session.Configuration;
import org.elasticsearch.xpack.sql.session.Cursors;
import org.elasticsearch.xpack.sql.session.RowSet;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;
import org.elasticsearch.xpack.sql.type.Schema;

public class TransportSqlQueryAction
extends HandledTransportAction<SqlQueryRequest, SqlQueryResponse> {
    private final SecurityContext securityContext;
    private final ClusterService clusterService;
    private final PlanExecutor planExecutor;
    private final SqlLicenseChecker sqlLicenseChecker;

    @Inject
    public TransportSqlQueryAction(Settings settings, ClusterService clusterService, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, PlanExecutor planExecutor, IndexNameExpressionResolver indexNameExpressionResolver, SqlLicenseChecker sqlLicenseChecker) {
        super(settings, "indices:data/read/sql", threadPool, transportService, actionFilters, SqlQueryRequest::new, indexNameExpressionResolver);
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.clusterService = clusterService;
        this.planExecutor = planExecutor;
        this.sqlLicenseChecker = sqlLicenseChecker;
    }

    protected void doExecute(SqlQueryRequest request, ActionListener<SqlQueryResponse> listener) {
        this.sqlLicenseChecker.checkIfSqlAllowed(request.mode());
        TransportSqlQueryAction.operation(this.planExecutor, request, listener, Transports.username(this.securityContext), Transports.clusterName(this.clusterService));
    }

    public static void operation(PlanExecutor planExecutor, SqlQueryRequest request, ActionListener<SqlQueryResponse> listener, String username, String clusterName) {
        Configuration cfg = new Configuration(request.zoneId(), request.fetchSize(), request.requestTimeout(), request.pageTimeout(), request.filter(), request.mode(), request.clientId(), username, clusterName, request.fieldMultiValueLeniency());
        if (!Strings.hasText((String)request.cursor())) {
            planExecutor.sql(cfg, request.query(), request.params(), (ActionListener<SchemaRowSet>)ActionListener.wrap(rowSet -> listener.onResponse((Object)TransportSqlQueryAction.createResponse(request, rowSet)), arg_0 -> listener.onFailure(arg_0)));
        } else {
            planExecutor.nextPage(cfg, Cursors.decodeFromString(request.cursor()), (ActionListener<RowSet>)ActionListener.wrap(rowSet -> listener.onResponse((Object)TransportSqlQueryAction.createResponse(request.mode(), rowSet, null)), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    static SqlQueryResponse createResponse(SqlQueryRequest request, SchemaRowSet rowSet) {
        ArrayList<ColumnInfo> columns = new ArrayList(rowSet.columnCount());
        for (Schema.Entry entry : rowSet.schema()) {
            if (Mode.isDriver((Mode)request.mode())) {
                columns.add(new ColumnInfo("", entry.name(), entry.type().typeName, Integer.valueOf(entry.type().displaySize)));
                continue;
            }
            columns.add(new ColumnInfo("", entry.name(), entry.type().typeName));
        }
        columns = Collections.unmodifiableList(columns);
        return TransportSqlQueryAction.createResponse(request.mode(), rowSet, columns);
    }

    static SqlQueryResponse createResponse(Mode mode, RowSet rowSet, List<ColumnInfo> columns) {
        ArrayList rows = new ArrayList();
        rowSet.forEachRow(rowView -> {
            ArrayList row = new ArrayList(rowView.columnCount());
            rowView.forEachColumn(row::add);
            rows.add(Collections.unmodifiableList(row));
        });
        return new SqlQueryResponse(Cursors.encodeToString(Version.CURRENT, rowSet.nextPageCursor()), mode, columns, rows);
    }
}

