/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.CommonFlexibleTypeBoundsChecker;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tJ\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/types/FlexibleTypeBoundsChecker;", "", "()V", "areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability", "", "a", "Lorg/jetbrains/kotlin/types/KotlinType;", "b", "getBaseBoundFqNameByMutability", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "type", "descriptors"})
@SourceDebugExtension(value={"SMAP\nflexibleTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 flexibleTypes.kt\norg/jetbrains/kotlin/types/FlexibleTypeBoundsChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class FlexibleTypeBoundsChecker {
    @NotNull
    public static final FlexibleTypeBoundsChecker INSTANCE = new FlexibleTypeBoundsChecker();

    private FlexibleTypeBoundsChecker() {
    }

    public final boolean areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability(@NotNull KotlinType a, @NotNull KotlinType b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Object object = a.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) == null) {
            return false;
        }
        Object fqName2 = object;
        FqName fqName3 = CommonFlexibleTypeBoundsChecker.INSTANCE.getBaseTypesToMutableEquivalent().get(fqName2);
        if (fqName3 == null && (fqName3 = CommonFlexibleTypeBoundsChecker.INSTANCE.getMutableToBaseMap().get(fqName2)) == null) {
            return false;
        }
        FqName possiblePairBound = fqName3;
        ClassifierDescriptor classifierDescriptor = b.getConstructor().getDeclarationDescriptor();
        return Intrinsics.areEqual((Object)possiblePairBound, (Object)(classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor) : null));
    }

    @Nullable
    public final FqName getBaseBoundFqNameByMutability(@NotNull KotlinType type2) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Object object = type2.getConstructor().getDeclarationDescriptor();
        if (object != null && (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) != null) {
            Object p0 = object;
            boolean bl = false;
            fqName2 = this.getBaseBoundFqNameByMutability((FqName)p0);
        } else {
            fqName2 = null;
        }
        return fqName2;
    }

    @Nullable
    public final FqName getBaseBoundFqNameByMutability(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return CommonFlexibleTypeBoundsChecker.INSTANCE.getBaseBoundFqNameByMutability(fqName2);
    }
}

