/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.PayloadTypeEncoding;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.rtp.RedAudioRtpPacket;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.transform.node.TransformerNode;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.rtp.RtpHeader;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/nlj/transform/node/RtpParser;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "transform", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "trace", "", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nRtpParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtpParser.kt\norg/jitsi/nlj/transform/node/RtpParser\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 Packet.kt\norg/jitsi/rtp/Packet\n*L\n1#1,78:1\n63#2,4:79\n29#3:83\n29#3:84\n29#3:85\n*S KotlinDebug\n*F\n+ 1 RtpParser.kt\norg/jitsi/nlj/transform/node/RtpParser\n*L\n41#1:79,4\n49#1:83\n50#1:84\n57#1:85\n*E\n"})
public final class RtpParser
extends TransformerNode {
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformationStore;
    @NotNull
    private final Logger logger;

    public RtpParser(@NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super("RTP Parser");
        this.streamInformationStore = streamInformationStore;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected PacketInfo transform(@NotNull PacketInfo packetInfo) {
        RtpPacket rtpPacket;
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Packet packet = packetInfo.getPacket();
        Intrinsics.checkNotNullExpressionValue(packet.buffer, "buffer");
        byte payloadTypeNumber = (byte)RtpHeader.Companion.getPayloadType(packet.buffer, packet.offset);
        PayloadType payloadType = this.streamInformationStore.getRtpPayloadTypes().get(payloadTypeNumber);
        if (payloadType == null) {
            RtpParser $this$transform_u24lambda_u241 = this;
            boolean bl = false;
            Logger $this$cdebug$iv = $this$transform_u24lambda_u241.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl2 = false;
                logger.debug("Unknown payload type: " + payloadTypeNumber);
            }
            return null;
        }
        PayloadType payloadType2 = payloadType;
        packetInfo.setPayloadType(payloadType2);
        switch (WhenMappings.$EnumSwitchMapping$1[payloadType2.getMediaType().ordinal()]) {
            case 1: {
                AudioRtpPacket bl;
                int $i$f$toOtherType;
                try {
                    AudioRtpPacket audioRtpPacket;
                    int p2;
                    int p1;
                    byte[] p0;
                    Packet this_$iv;
                    if (WhenMappings.$EnumSwitchMapping$0[payloadType2.getEncoding().ordinal()] == 1) {
                        this_$iv = packet;
                        $i$f$toOtherType = 0;
                        Intrinsics.checkNotNullExpressionValue(this_$iv.buffer, "buffer");
                        int bl2 = this_$iv.length;
                        int n = this_$iv.offset;
                        p0 = this_$iv.buffer;
                        boolean bl3 = false;
                        audioRtpPacket = (AudioRtpPacket)((Packet)new RedAudioRtpPacket(p0, p1, p2));
                    } else {
                        this_$iv = packet;
                        $i$f$toOtherType = 0;
                        Intrinsics.checkNotNullExpressionValue(this_$iv.buffer, "buffer");
                        p2 = this_$iv.length;
                        p1 = this_$iv.offset;
                        p0 = this_$iv.buffer;
                        boolean bl4 = false;
                        audioRtpPacket = (AudioRtpPacket)((Packet)new AudioRtpPacket(p0, p1, p2));
                    }
                    bl = audioRtpPacket;
                }
                catch (Exception e) {
                    this.logger.info("Dropping audio packet due to parse failure: " + e.getMessage());
                    return null;
                }
                rtpPacket = bl;
                break;
            }
            case 2: {
                VideoRtpPacket videoRtpPacket;
                int $i$f$toOtherType;
                try {
                    void p2;
                    void p1;
                    Packet this_$iv = packet;
                    boolean $i$f$toOtherType2 = false;
                    Intrinsics.checkNotNullExpressionValue(this_$iv.buffer, "buffer");
                    int this_$iv2 = this_$iv.length;
                    $i$f$toOtherType = this_$iv.offset;
                    byte[] p0 = this_$iv.buffer;
                    boolean bl = false;
                    videoRtpPacket = (VideoRtpPacket)((Packet)new VideoRtpPacket(p0, (int)p1, (int)p2, 0, 8, null));
                }
                catch (Exception e) {
                    this.logger.info("Dropping video packet due to parse failure: " + e.getMessage());
                    return null;
                }
                rtpPacket = videoRtpPacket;
                break;
            }
            default: {
                this.logger.info("Dropping packet with unrecognized media type: '" + payloadType2.getMediaType() + "'");
                return null;
            }
        }
        RtpPacket rtpPacket2 = rtpPacket;
        packetInfo.setPacket(rtpPacket2);
        if (rtpPacket2.getExtensionsProfileType() == 49374 || rtpPacket2.getExtensionsProfileType() == 49886) {
            packetInfo.setOriginalHadCryptex(true);
        }
        packetInfo.resetPayloadVerification();
        return packetInfo;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PayloadTypeEncoding.values().length];
            try {
                nArray[PayloadTypeEncoding.RED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MediaType.values().length];
            try {
                nArray[MediaType.AUDIO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaType.VIDEO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

