/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.CreateDelegationTokenResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class CreateDelegationTokenRequest
extends AbstractRequest {
    private static final String RENEWERS_KEY_NAME = "renewers";
    private static final String MAX_LIFE_TIME_KEY_NAME = "max_life_time";
    private static final Schema TOKEN_CREATE_REQUEST_V0 = new Schema(new Field("renewers", new ArrayOf(new Schema(CommonFields.PRINCIPAL_TYPE, CommonFields.PRINCIPAL_NAME)), "An array of token renewers. Renewer is an Kafka PrincipalType and name string, who is allowed to renew this token before the max lifetime expires."), new Field("max_life_time", Type.INT64, "Max lifetime period for token in milli seconds. if value is -1, then max lifetime  will default to a server side config value."));
    private final List<KafkaPrincipal> renewers;
    private final long maxLifeTime;

    private CreateDelegationTokenRequest(short version, List<KafkaPrincipal> renewers, long maxLifeTime) {
        super(version);
        this.maxLifeTime = maxLifeTime;
        this.renewers = renewers;
    }

    public CreateDelegationTokenRequest(Struct struct, short version) {
        super(version);
        this.maxLifeTime = struct.getLong(MAX_LIFE_TIME_KEY_NAME);
        Object[] renewerArray = struct.getArray(RENEWERS_KEY_NAME);
        this.renewers = new ArrayList<KafkaPrincipal>();
        if (renewerArray != null) {
            for (Object renewerObj : renewerArray) {
                Struct renewerObjStruct = (Struct)renewerObj;
                String principalType = renewerObjStruct.get(CommonFields.PRINCIPAL_TYPE);
                String principalName = renewerObjStruct.get(CommonFields.PRINCIPAL_NAME);
                this.renewers.add(new KafkaPrincipal(principalType, principalName));
            }
        }
    }

    public static CreateDelegationTokenRequest parse(ByteBuffer buffer, short version) {
        return new CreateDelegationTokenRequest(ApiKeys.CREATE_DELEGATION_TOKEN.parseRequest(version, buffer), version);
    }

    public static Schema[] schemaVersions() {
        return new Schema[]{TOKEN_CREATE_REQUEST_V0};
    }

    @Override
    protected Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.CREATE_DELEGATION_TOKEN.requestSchema(version));
        Object[] renewersArray = new Object[this.renewers.size()];
        int i = 0;
        for (KafkaPrincipal principal : this.renewers) {
            Struct renewerStruct = struct.instance(RENEWERS_KEY_NAME);
            renewerStruct.set(CommonFields.PRINCIPAL_TYPE, principal.getPrincipalType());
            renewerStruct.set(CommonFields.PRINCIPAL_NAME, principal.getName());
            renewersArray[i++] = renewerStruct;
        }
        struct.set(RENEWERS_KEY_NAME, (Object)renewersArray);
        struct.set(MAX_LIFE_TIME_KEY_NAME, (Object)this.maxLifeTime);
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new CreateDelegationTokenResponse(throttleTimeMs, Errors.forException(e), KafkaPrincipal.ANONYMOUS);
    }

    public List<KafkaPrincipal> renewers() {
        return this.renewers;
    }

    public long maxLifeTime() {
        return this.maxLifeTime;
    }

    public static class Builder
    extends AbstractRequest.Builder<CreateDelegationTokenRequest> {
        private final List<KafkaPrincipal> renewers;
        private final long maxLifeTime;

        public Builder(List<KafkaPrincipal> renewers, long maxLifeTime) {
            super(ApiKeys.CREATE_DELEGATION_TOKEN);
            this.renewers = renewers;
            this.maxLifeTime = maxLifeTime;
        }

        @Override
        public CreateDelegationTokenRequest build(short version) {
            return new CreateDelegationTokenRequest(version, this.renewers, this.maxLifeTime);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type: CreateDelegationTokenRequest").append(", renewers=").append(this.renewers).append(", maxLifeTime=").append(this.maxLifeTime).append(")");
            return bld.toString();
        }
    }
}

