/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J(\u0010*\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-H\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/resolve/InlineClassDescriptorResolver;", "", "<init>", "()V", "BOX_METHOD_NAME", "Lorg/jetbrains/kotlin/name/Name;", "UNBOX_METHOD_NAME", "SPECIALIZED_EQUALS_NAME", "BOXING_VALUE_PARAMETER_NAME", "getBOXING_VALUE_PARAMETER_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME", "getSPECIALIZED_EQUALS_FIRST_PARAMETER_NAME", "SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME", "getSPECIALIZED_EQUALS_SECOND_PARAMETER_NAME", "createBoxFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "owner", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "createUnboxFunctionDescriptor", "isSynthesizedBoxMethod", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isSynthesizedUnboxMethod", "isSynthesizedBoxOrUnboxMethod", "isSpecializedEqualsMethod", "isSynthesizedInlineClassMemberWithName", "name", "isSynthesizedInlineClassMember", "createSpecializedEqualsDescriptor", "createConversionFunctionDescriptor", "isBoxMethod", "createValueParameterForBoxing", "Lorg/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "underlyingType", "Lorg/jetbrains/kotlin/types/KotlinType;", "createValueParametersForSpecializedEquals", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "createValueParameter", "type", "index", "", "frontend"})
public final class InlineClassDescriptorResolver {
    @NotNull
    public static final InlineClassDescriptorResolver INSTANCE = new InlineClassDescriptorResolver();
    @JvmField
    @NotNull
    public static final Name BOX_METHOD_NAME;
    @JvmField
    @NotNull
    public static final Name UNBOX_METHOD_NAME;
    @JvmField
    @NotNull
    public static final Name SPECIALIZED_EQUALS_NAME;
    @NotNull
    private static final Name BOXING_VALUE_PARAMETER_NAME;
    @NotNull
    private static final Name SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME;
    @NotNull
    private static final Name SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME;

    private InlineClassDescriptorResolver() {
    }

    @NotNull
    public final Name getBOXING_VALUE_PARAMETER_NAME() {
        return BOXING_VALUE_PARAMETER_NAME;
    }

    @NotNull
    public final Name getSPECIALIZED_EQUALS_FIRST_PARAMETER_NAME() {
        return SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME;
    }

    @NotNull
    public final Name getSPECIALIZED_EQUALS_SECOND_PARAMETER_NAME() {
        return SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME;
    }

    @JvmStatic
    @NotNull
    public static final SimpleFunctionDescriptor createBoxFunctionDescriptor(@NotNull ClassDescriptor owner) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        return INSTANCE.createConversionFunctionDescriptor(true, owner);
    }

    @JvmStatic
    @NotNull
    public static final SimpleFunctionDescriptor createUnboxFunctionDescriptor(@NotNull ClassDescriptor owner) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        return INSTANCE.createConversionFunctionDescriptor(false, owner);
    }

    @JvmStatic
    public static final boolean isSynthesizedBoxMethod(@NotNull CallableMemberDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return INSTANCE.isSynthesizedInlineClassMemberWithName(descriptor, BOX_METHOD_NAME);
    }

    @JvmStatic
    public static final boolean isSynthesizedUnboxMethod(@NotNull CallableMemberDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return INSTANCE.isSynthesizedInlineClassMemberWithName(descriptor, UNBOX_METHOD_NAME);
    }

    @JvmStatic
    public static final boolean isSynthesizedBoxOrUnboxMethod(@NotNull CallableMemberDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return INSTANCE.isSynthesizedInlineClassMember(descriptor) && (Intrinsics.areEqual(descriptor.getName(), BOX_METHOD_NAME) || Intrinsics.areEqual(descriptor.getName(), UNBOX_METHOD_NAME));
    }

    @JvmStatic
    public static final boolean isSpecializedEqualsMethod(@NotNull CallableMemberDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return INSTANCE.isSynthesizedInlineClassMemberWithName(descriptor, SPECIALIZED_EQUALS_NAME);
    }

    private final boolean isSynthesizedInlineClassMemberWithName(CallableMemberDescriptor descriptor, Name name2) {
        return this.isSynthesizedInlineClassMember(descriptor) && Intrinsics.areEqual(descriptor.getName(), name2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSynthesizedInlineClassMember(CallableMemberDescriptor descriptor) {
        if (descriptor.getKind() != CallableMemberDescriptor.Kind.SYNTHESIZED) return false;
        DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        if (!InlineClassesUtilsKt.isInlineClass(declarationDescriptor)) return false;
        return true;
    }

    @NotNull
    public final SimpleFunctionDescriptor createSpecializedEqualsDescriptor(@NotNull ClassDescriptor owner) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = SimpleFunctionDescriptorImpl.create(owner, Annotations.Companion.getEMPTY(), SPECIALIZED_EQUALS_NAME, CallableMemberDescriptor.Kind.SYNTHESIZED, SourceElement.NO_SOURCE);
        Intrinsics.checkNotNullExpressionValue(simpleFunctionDescriptorImpl, "create(...)");
        SimpleFunctionDescriptorImpl functionDescriptor = simpleFunctionDescriptorImpl;
        List list = CollectionsKt.emptyList();
        List list2 = CollectionsKt.emptyList();
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        InlineClassRepresentation<SimpleType> inlineClassRepresentation = DescriptorUtilsKt.getInlineClassRepresentation(owner);
        Intrinsics.checkNotNull(inlineClassRepresentation);
        functionDescriptor.initialize((ReceiverParameterDescriptor)null, (ReceiverParameterDescriptor)null, list, list2, (List)this.createValueParametersForSpecializedEquals(functionDescriptor2, inlineClassRepresentation.getUnderlyingType()), (KotlinType)DescriptorUtilsKt.getBuiltIns(owner).getBooleanType(), Modality.FINAL, DescriptorVisibilities.PUBLIC);
        return functionDescriptor;
    }

    private final SimpleFunctionDescriptor createConversionFunctionDescriptor(boolean isBoxMethod, ClassDescriptor owner) {
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = SimpleFunctionDescriptorImpl.create(owner, Annotations.Companion.getEMPTY(), isBoxMethod ? BOX_METHOD_NAME : UNBOX_METHOD_NAME, CallableMemberDescriptor.Kind.SYNTHESIZED, SourceElement.NO_SOURCE);
        Intrinsics.checkNotNullExpressionValue(simpleFunctionDescriptorImpl, "create(...)");
        SimpleFunctionDescriptorImpl functionDescriptor = simpleFunctionDescriptorImpl;
        InlineClassRepresentation<SimpleType> inlineClassRepresentation = DescriptorUtilsKt.getInlineClassRepresentation(owner);
        Intrinsics.checkNotNull(inlineClassRepresentation);
        SimpleType underlyingType = inlineClassRepresentation.getUnderlyingType();
        functionDescriptor.initialize((ReceiverParameterDescriptor)null, isBoxMethod ? null : owner.getThisAsReceiverParameter(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), isBoxMethod ? CollectionsKt.listOf(this.createValueParameterForBoxing(functionDescriptor, underlyingType)) : CollectionsKt.emptyList(), (KotlinType)(isBoxMethod ? owner.getDefaultType() : underlyingType), Modality.FINAL, DescriptorVisibilities.PUBLIC);
        return functionDescriptor;
    }

    private final ValueParameterDescriptorImpl createValueParameterForBoxing(FunctionDescriptor functionDescriptor, KotlinType underlyingType) {
        return this.createValueParameter(functionDescriptor, underlyingType, BOXING_VALUE_PARAMETER_NAME, 0);
    }

    private final List<ValueParameterDescriptor> createValueParametersForSpecializedEquals(FunctionDescriptor functionDescriptor, KotlinType underlyingType) {
        ValueParameterDescriptorImpl[] valueParameterDescriptorImplArray = new ValueParameterDescriptorImpl[]{this.createValueParameter(functionDescriptor, underlyingType, SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME, 0), this.createValueParameter(functionDescriptor, underlyingType, SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME, 1)};
        return CollectionsKt.listOf(valueParameterDescriptorImplArray);
    }

    private final ValueParameterDescriptorImpl createValueParameter(FunctionDescriptor functionDescriptor, KotlinType type2, Name name2, int index) {
        CallableDescriptor callableDescriptor = functionDescriptor;
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkNotNullExpressionValue(sourceElement, "NO_SOURCE");
        return new ValueParameterDescriptorImpl(callableDescriptor, null, index, annotations2, name2, type2, false, false, false, null, sourceElement);
    }

    static {
        Name name2 = Name.identifier("box");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        BOX_METHOD_NAME = name2;
        Name name3 = Name.identifier("unbox");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        UNBOX_METHOD_NAME = name3;
        Name name4 = Name.identifier("equals-impl0");
        Intrinsics.checkNotNullExpressionValue(name4, "identifier(...)");
        SPECIALIZED_EQUALS_NAME = name4;
        Name name5 = Name.identifier("v");
        Intrinsics.checkNotNullExpressionValue(name5, "identifier(...)");
        BOXING_VALUE_PARAMETER_NAME = name5;
        Name name6 = Name.identifier("p1");
        Intrinsics.checkNotNullExpressionValue(name6, "identifier(...)");
        SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME = name6;
        Name name7 = Name.identifier("p2");
        Intrinsics.checkNotNullExpressionValue(name7, "identifier(...)");
        SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME = name7;
    }
}

