/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.repository.internal;

import java.util.Map;
import java.util.Properties;
import org.jetbrains.kotlin.org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.jetbrains.kotlin.org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.jetbrains.kotlin.org.apache.maven.repository.internal.DefaultVersionResolver;
import org.jetbrains.kotlin.org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import org.jetbrains.kotlin.org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.jetbrains.kotlin.org.eclipse.aether.DefaultRepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.DefaultArtifactType;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyGraphTransformer;
import org.jetbrains.kotlin.org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.jetbrains.kotlin.org.eclipse.aether.impl.DefaultServiceLocator;
import org.jetbrains.kotlin.org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.jetbrains.kotlin.org.eclipse.aether.impl.VersionRangeResolver;
import org.jetbrains.kotlin.org.eclipse.aether.impl.VersionResolver;
import org.jetbrains.kotlin.org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.manager.ClassicDependencyManager;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer.JavaDependencyContextRefiner;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.traverser.FatArtifactTraverser;
import org.jetbrains.kotlin.org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;

public final class MavenRepositorySystemUtils {
    public static DefaultServiceLocator newServiceLocator() {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.addService(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
        locator.addService(VersionResolver.class, DefaultVersionResolver.class);
        locator.addService(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        locator.addService(MetadataGeneratorFactory.class, SnapshotMetadataGeneratorFactory.class);
        locator.addService(MetadataGeneratorFactory.class, VersionsMetadataGeneratorFactory.class);
        return locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultRepositorySystemSession newSession() {
        Properties sysProp;
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession();
        FatArtifactTraverser depTraverser = new FatArtifactTraverser();
        session.setDependencyTraverser(depTraverser);
        ClassicDependencyManager depManager = new ClassicDependencyManager();
        session.setDependencyManager(depManager);
        AndDependencySelector depFilter = new AndDependencySelector(new ScopeDependencySelector("test", "provided"), new OptionalDependencySelector(), new ExclusionDependencySelector());
        session.setDependencySelector(depFilter);
        DependencyGraphTransformer transformer = new ConflictResolver(new NearestVersionSelector(), new JavaScopeSelector(), new SimpleOptionalitySelector(), new JavaScopeDeriver());
        transformer = new ChainedDependencyGraphTransformer(transformer, new JavaDependencyContextRefiner());
        session.setDependencyGraphTransformer(transformer);
        DefaultArtifactTypeRegistry stereotypes = new DefaultArtifactTypeRegistry();
        stereotypes.add(new DefaultArtifactType("pom"));
        stereotypes.add(new DefaultArtifactType("maven-plugin", "jar", "", "java"));
        stereotypes.add(new DefaultArtifactType("jar", "jar", "", "java"));
        stereotypes.add(new DefaultArtifactType("ejb", "jar", "", "java"));
        stereotypes.add(new DefaultArtifactType("ejb-client", "jar", "client", "java"));
        stereotypes.add(new DefaultArtifactType("test-jar", "jar", "tests", "java"));
        stereotypes.add(new DefaultArtifactType("javadoc", "jar", "javadoc", "java"));
        stereotypes.add(new DefaultArtifactType("java-source", "jar", "sources", "java", false, false));
        stereotypes.add(new DefaultArtifactType("war", "war", "", "java", false, true));
        stereotypes.add(new DefaultArtifactType("ear", "ear", "", "java", false, true));
        stereotypes.add(new DefaultArtifactType("rar", "rar", "", "java", false, true));
        stereotypes.add(new DefaultArtifactType("par", "par", "", "java", false, true));
        session.setArtifactTypeRegistry(stereotypes);
        session.setArtifactDescriptorPolicy(new SimpleArtifactDescriptorPolicy(true, true));
        Properties systemProperties = new Properties();
        Properties properties = sysProp = System.getProperties();
        synchronized (properties) {
            systemProperties.putAll((Map<?, ?>)sysProp);
        }
        session.setSystemProperties(systemProperties);
        session.setConfigProperties(systemProperties);
        return session;
    }
}

