/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis.executables;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.opensolaris.opengrok.analysis.AnalyzerGuru;
import org.opensolaris.opengrok.analysis.FileAnalyzer;
import org.opensolaris.opengrok.analysis.FileAnalyzerFactory;
import org.opensolaris.opengrok.analysis.StreamSource;
import org.opensolaris.opengrok.analysis.executables.JavaClassAnalyzer;
import org.opensolaris.opengrok.analysis.executables.JavaClassAnalyzerFactory;
import org.opensolaris.opengrok.web.Util;

public class JarAnalyzer
extends FileAnalyzer {
    protected JarAnalyzer(FileAnalyzerFactory factory) {
        super(factory);
    }

    @Override
    public void analyze(Document doc, StreamSource src, Writer xrefOut) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(src.getStream());){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String ename = entry.getName();
                if (xrefOut != null) {
                    xrefOut.append("<br/><b>");
                    Util.htmlize(ename, (Appendable)xrefOut);
                    xrefOut.append("</b>");
                }
                doc.add((IndexableField)new TextField("full", ename, Field.Store.NO));
                FileAnalyzerFactory fac = AnalyzerGuru.find(ename);
                if (!(fac instanceof JavaClassAnalyzerFactory)) continue;
                if (xrefOut != null) {
                    xrefOut.append("<pre>");
                }
                JavaClassAnalyzer jca = (JavaClassAnalyzer)fac.getAnalyzer();
                jca.analyze(doc, new BufferedInputStream(zis), xrefOut);
                if (xrefOut == null) continue;
                xrefOut.append("</pre>");
            }
        }
    }
}

