/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.google.gson.stream.JsonToken;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsManagerMain;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginHostsConfigurable;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.DetailsPagePluginComponent;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.GridCellPluginComponent;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MultiSelectionEventHandler;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginSearchTextField;
import com.intellij.ide.plugins.newui.PluginSiteUtils;
import com.intellij.ide.plugins.newui.PluginsGridLayout;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.PluginsGroupComponentWithProgress;
import com.intellij.ide.plugins.newui.PluginsListLayout;
import com.intellij.ide.plugins.newui.SearchPopup;
import com.intellij.ide.plugins.newui.SearchPopupController;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.ide.plugins.newui.SearchResultPanel;
import com.intellij.ide.plugins.newui.TabHeaderComponent;
import com.intellij.ide.plugins.newui.TagBuilder;
import com.intellij.ide.plugins.newui.TagComponent;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;

public class PluginManagerConfigurableNew
implements SearchableConfigurable,
Configurable.NoScroll,
Configurable.NoMargin,
Configurable.TopComponentProvider {
    public static final String ID = "preferences.pluginManager";
    private static final String SELECTION_TAB_KEY = "PluginConfigurable.selectionTab";
    private static final int TRENDING_TAB = 0;
    private static final int INSTALLED_TAB = 1;
    private static final int UPDATES_TAB = 2;
    private static final int TRENDING_SEARCH_TAB = 3;
    private static final int INSTALLED_SEARCH_TAB = 4;
    private static final int UPDATES_SEARCH_TAB = 5;
    private static final int ITEMS_PER_GROUP = 9;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM dd, yyyy");
    private static final DecimalFormat K_FORMAT = new DecimalFormat("###.#K");
    private static final DecimalFormat M_FORMAT = new DecimalFormat("###.#M");
    public static final Color MAIN_BG_COLOR = new JBColor(() -> JBColor.isBright() ? UIUtil.getListBackground() : new Color(0x313335));
    private final TagBuilder myTagBuilder;
    private LinkListener<IdeaPluginDescriptor> myNameListener;
    private LinkListener<String> mySearchListener;
    private CardLayoutPanel<Object, Object, JComponent> myCardPanel;
    private TabHeaderComponent myTabHeaderComponent;
    private CountTabName myUpdatesTabName;
    private Configurable.TopComponentController myTopController;
    private final PluginSearchTextField mySearchTextField;
    private final Alarm mySearchUpdateAlarm = new Alarm();
    private PluginsGroupComponentWithProgress myTrendingPanel;
    private PluginsGroupComponent myInstalledPanel;
    private PluginsGroupComponentWithProgress myUpdatesPanel;
    private Runnable myTrendingRunnable;
    private Runnable myUpdatesRunnable;
    private SearchResultPanel myTrendingSearchPanel;
    private SearchResultPanel myInstalledSearchPanel;
    private SearchResultPanel myUpdatesSearchPanel;
    private SearchResultPanel myCurrentSearchPanel;
    private final MyPluginModel myPluginsModel = new MyPluginModel();
    private Runnable myShutdownCallback;
    private List<IdeaPluginDescriptor> myAllRepositoriesList;
    private Map<String, IdeaPluginDescriptor> myAllRepositoriesMap;
    private Map<String, List<IdeaPluginDescriptor>> myCustomRepositoriesMap;
    private final Object myRepositoriesLock = new Object();
    private List<String> myAllTagSorted;
    private boolean myIgnoreFocusFromBackButton;
    public static final Color DisabledColor = new JBColor(0xB1B1B1, 0x696969);

    public PluginManagerConfigurableNew() {
        this.myTagBuilder = new TagBuilder(){

            @Override
            @NotNull
            public TagComponent createTagComponent(@NotNull String tag) {
                JBColor color;
                if (tag == null) {
                    1.$$$reportNull$$$0(0);
                }
                String tooltip = null;
                if ("EAP".equals(tag)) {
                    color = new JBColor(15913679, 15913679);
                    tooltip = "The EAP version does not guarantee the stability\nand availability of the plugin.";
                } else {
                    color = new JBColor(0xEAEAEC, 0x4D4D4D);
                }
                TagComponent tagComponent = PluginManagerConfigurableNew.installTiny(new TagComponent(tag, tooltip, (Color)color));
                if (tagComponent == null) {
                    1.$$$reportNull$$$0(1);
                }
                return tagComponent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tag";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createTagComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createTagComponent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.mySearchTextField = new PluginSearchTextField(){

            protected boolean preprocessEventForTextField(KeyEvent event) {
                int keyCode = event.getKeyCode();
                int id = event.getID();
                if (keyCode == 10 || event.getKeyChar() == '\n') {
                    String text;
                    if (!(id != 401 || ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller != null && ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.handleEnter(event) || (text = PluginManagerConfigurableNew.this.mySearchTextField.getText()).isEmpty())) {
                        if (((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller != null) {
                            ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.hidePopup();
                        }
                        PluginManagerConfigurableNew.this.showSearchPanel(text);
                    }
                    return true;
                }
                if ((keyCode == 40 || keyCode == 38) && id == 401 && ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller != null && ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.handleUpDown(event)) {
                    return true;
                }
                return super.preprocessEventForTextField(event);
            }

            protected boolean toClearTextOnEscape() {
                new AnAction(){
                    {
                        this.setEnabledInModalContext(true);
                    }

                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        e.getPresentation().setEnabled(!this.getText().isEmpty());
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller != null && ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.isPopupShow()) {
                            ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.hidePopup();
                        } else {
                            this.setText("");
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$2$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "update";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "actionPerformed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)((Object)this));
                return false;
            }

            protected void onFieldCleared() {
                PluginManagerConfigurableNew.this.hideSearchPanel();
            }
        };
        this.mySearchTextField.setBorder(JBUI.Borders.customLine((Color)new JBColor(0xC5C5C5, 0x515151)));
        JBTextField editor = this.mySearchTextField.getTextEditor();
        editor.putClientProperty((Object)"JTextField.Search.Gap", (Object)JBUI.scale((int)-24));
        editor.putClientProperty((Object)"JTextField.Search.GapEmptyText", (Object)JBUI.scale((int)-1));
        editor.putClientProperty((Object)"StatusVisibleFunction", field -> field.getText().isEmpty());
        editor.setBorder((Border)JBUI.Borders.empty((int)0, (int)25));
        editor.setOpaque(true);
        editor.setBackground(MAIN_BG_COLOR);
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(0);
        }
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return IdeBundle.message((String)"title.plugins", (Object[])new Object[0]);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchTextField.getTextEditor();
    }

    @Nullable
    public JComponent createComponent() {
        final JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setMinimumSize((Dimension)new JBDimension(580, 380));
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new DumbAwareAction("Manage Plugin Repositories..."){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (ShowSettingsUtil.getInstance().editConfigurable((Component)panel2, (Configurable)new PluginHostsConfigurable())) {
                    PluginManagerConfigurableNew.this.resetTrendingAndUpdatesPanels();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurableNew$3", "actionPerformed"));
            }
        });
        actions.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"button.http.proxy.settings", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (HttpConfigurable.editConfigurable((JComponent)panel2)) {
                    PluginManagerConfigurableNew.this.resetTrendingAndUpdatesPanels();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurableNew$4", "actionPerformed"));
            }
        });
        actions.addSeparator();
        actions.add((AnAction)new DumbAwareAction("Install Plugin from Disk..."){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                InstalledPluginsManagerMain.chooseAndInstall(PluginManagerConfigurableNew.this.myPluginsModel, (Consumer<? super Pair<File, IdeaPluginDescriptor>>)((Consumer)pair -> PluginManagerConfigurableNew.this.myPluginsModel.appendOrUpdateDescriptor((IdeaPluginDescriptor)pair.second)), panel2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurableNew$5", "actionPerformed"));
            }
        });
        panel2.add((Component)((Object)this.mySearchTextField), "North");
        this.myNameListener = (label2, descriptor) -> {
            int detailBackTabIndex = -1;
            if (label2 == null) {
                if (this.myPluginsModel.detailPanel != null) {
                    detailBackTabIndex = this.myPluginsModel.detailPanel.backTabIndex;
                }
                this.removeDetailsPanel();
            }
            assert (this.myPluginsModel.detailPanel == null);
            final JButton backButton = new JButton("Plugins");
            PluginManagerConfigurableNew.configureBackButton(backButton);
            int currentTab = detailBackTabIndex == -1 ? this.myTabHeaderComponent.getSelectionTab() : detailBackTabIndex;
            backButton.addActionListener(event -> {
                this.removeDetailsPanel();
                this.myIgnoreFocusFromBackButton = true;
                this.myCardPanel.select(this.myCurrentSearchPanel.isEmpty() ? currentTab : this.myCurrentSearchPanel.tabIndex, true);
                PluginManagerConfigurableNew.storeSelectionTab(currentTab);
                this.myTabHeaderComponent.setSelection(currentTab);
            });
            this.myCardPanel.select(Pair.create((Object)descriptor, (Object)(label2 != null && currentTab == 2 ? 1 : 0)), true);
            this.myPluginsModel.detailPanel.backTabIndex = currentTab;
            NonOpaquePanel buttonPanel = new NonOpaquePanel(backButton){

                public int getBaseline(int width, int height) {
                    return backButton.getBaseline(width, height);
                }
            };
            buttonPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
            this.myTopController.setLeftComponent((Component)buttonPanel);
            this.myTabHeaderComponent.clearSelection();
        };
        this.mySearchListener = (_0, query) -> {
            this.removeDetailsPanel();
            this.mySearchTextField.setTextIgnoreEvents((String)query);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.mySearchTextField), true));
            this.myCurrentSearchPanel.setEmpty();
            this.showSearchPanel((String)query);
        };
        this.mySearchTextField.getTextEditor().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (PluginManagerConfigurableNew.this.myIgnoreFocusFromBackButton) {
                    PluginManagerConfigurableNew.this.myIgnoreFocusFromBackButton = false;
                    return;
                }
                if (((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller == null) {
                    return;
                }
                if (StringUtil.isEmptyOrSpaces((String)PluginManagerConfigurableNew.this.mySearchTextField.getText())) {
                    ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.showAttributesPopup(null, 0);
                } else {
                    ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.handleShowPopup();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller != null) {
                    ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.hidePopup();
                }
            }
        });
        this.mySearchTextField.getTextEditor().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (!PluginManagerConfigurableNew.this.mySearchTextField.isSkipDocumentEvents()) {
                    PluginManagerConfigurableNew.this.mySearchUpdateAlarm.cancelAllRequests();
                    PluginManagerConfigurableNew.this.mySearchUpdateAlarm.addRequest(this::searchOnTheFly, 100, ModalityState.stateForComponent((Component)((Object)PluginManagerConfigurableNew.this.mySearchTextField)));
                }
            }

            private void searchOnTheFly() {
                String text = PluginManagerConfigurableNew.this.mySearchTextField.getText();
                if (StringUtil.isEmptyOrSpaces((String)text)) {
                    PluginManagerConfigurableNew.this.hideSearchPanel();
                } else if (((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller == null) {
                    PluginManagerConfigurableNew.this.showSearchPanel(text);
                } else {
                    ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.handleShowPopup();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurableNew$8", "textChanged"));
            }
        });
        this.myCardPanel = new CardLayoutPanel<Object, Object, JComponent>(){

            @Override
            public ActionCallback select(Object key, boolean now) {
                ActionCallback callback2 = super.select(key, now);
                callback2.doWhenDone(() -> {
                    for (Component component : this.getComponents()) {
                        Component view;
                        if (!component.isVisible() || !(component instanceof JScrollPane) || !((view = ((JScrollPane)component).getViewport().getView()) instanceof PluginsGroupComponentWithProgress)) continue;
                        view.setVisible(true);
                    }
                    panel2.doLayout();
                    panel2.revalidate();
                    panel2.repaint();
                });
                return callback2;
            }

            @Override
            protected Object prepare(Object key) {
                return key;
            }

            @Override
            protected JComponent create(Object key) {
                if (key instanceof Integer) {
                    Integer index = (Integer)key;
                    if (index == 0) {
                        return PluginManagerConfigurableNew.this.createTrendingPanel();
                    }
                    if (index == 1) {
                        return PluginManagerConfigurableNew.this.createInstalledPanel();
                    }
                    if (index == 2) {
                        return PluginManagerConfigurableNew.this.createUpdatesPanel();
                    }
                    if (index == 3) {
                        return PluginManagerConfigurableNew.this.myTrendingSearchPanel.createScrollPane();
                    }
                    if (index == 4) {
                        return PluginManagerConfigurableNew.this.myInstalledSearchPanel.createScrollPane();
                    }
                    if (index == 5) {
                        return PluginManagerConfigurableNew.this.myUpdatesSearchPanel.createScrollPane();
                    }
                    throw new RuntimeException("Create card unknown KEY index: " + key);
                }
                return PluginManagerConfigurableNew.this.createDetailsPanel((Pair<IdeaPluginDescriptor, Boolean>)((Pair)key));
            }
        };
        panel2.add(this.myCardPanel);
        this.myTabHeaderComponent = new TabHeaderComponent(actions, index -> {
            this.removeDetailsPanel();
            this.myIgnoreFocusFromBackButton = false;
            this.myCardPanel.select(index, true);
            PluginManagerConfigurableNew.storeSelectionTab(index);
            this.updateSearchForSelectedTab(index);
            if (!this.myCurrentSearchPanel.isEmpty()) {
                this.myCardPanel.select(this.myCurrentSearchPanel.tabIndex, true);
            }
        });
        this.myTabHeaderComponent.addTab("Marketplace");
        this.myTabHeaderComponent.addTab("Installed");
        this.myUpdatesTabName = new CountTabName(this.myTabHeaderComponent, "Updates");
        this.myTabHeaderComponent.addTab(this.myUpdatesTabName);
        this.createSearchPanels();
        int selectionTab = PluginManagerConfigurableNew.getStoredSelectionTab();
        this.myTabHeaderComponent.setSelection(selectionTab);
        this.myCardPanel.select(selectionTab, true);
        this.updateSearchForSelectedTab(selectionTab);
        return panel2;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        if (StringUtil.isEmpty((String)option) && this.myCurrentSearchPanel.isEmpty()) {
            return null;
        }
        return () -> {
            this.hideSearchPanel();
            if (this.myTabHeaderComponent.getSelectionTab() != 1) {
                this.myTabHeaderComponent.setSelectionWithEvents(1);
            }
            this.mySearchTextField.setTextIgnoreEvents(option);
            if (!StringUtil.isEmpty((String)option)) {
                this.showSearchPanel(option);
            }
        };
    }

    public void select(IdeaPluginDescriptor ... descriptors) {
        if (descriptors == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(1);
        }
        this.myIgnoreFocusFromBackButton = true;
        if (this.myTabHeaderComponent.getSelectionTab() != 1) {
            this.myTabHeaderComponent.setSelectionWithEvents(1);
        }
        if (descriptors.length == 0) {
            return;
        }
        ArrayList<CellPluginComponent> components = new ArrayList<CellPluginComponent>();
        block0: for (IdeaPluginDescriptor descriptor : descriptors) {
            for (UIPluginGroup group : this.myInstalledPanel.getGroups()) {
                CellPluginComponent component = group.findComponent(descriptor);
                if (component == null) continue;
                components.add(component);
                continue block0;
            }
        }
        if (!components.isEmpty()) {
            this.myInstalledPanel.setSelection(components);
        }
    }

    @NotNull
    public MyPluginModel getPluginsModel() {
        MyPluginModel myPluginModel = this.myPluginsModel;
        if (myPluginModel == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(2);
        }
        return myPluginModel;
    }

    private void updateSearchForSelectedTab(int index) {
        String historyPropertyName;
        SearchResultPanel searchPanel;
        String text;
        if (index == 0) {
            text = "Search plugins in marketplace";
            if (!UpdateSettings.getInstance().getPluginHosts().isEmpty()) {
                text = text + " and custom repositories";
            }
            searchPanel = this.myTrendingSearchPanel;
            historyPropertyName = "TrendingPluginsSearchHistory";
        } else if (index == 1) {
            text = "Search installed plugins";
            searchPanel = this.myInstalledSearchPanel;
            historyPropertyName = "InstalledPluginsSearchHistory";
        } else {
            text = "Search available updates";
            searchPanel = this.myUpdatesSearchPanel;
            historyPropertyName = "UpdatePluginsSearchHistory";
        }
        StatusText emptyText = this.mySearchTextField.getTextEditor().getEmptyText();
        emptyText.clear();
        emptyText.appendText(text, new SimpleTextAttributes(0, CellPluginComponent.GRAY_COLOR));
        this.myCurrentSearchPanel = searchPanel;
        this.mySearchTextField.addCurrentTextToHistory();
        this.mySearchTextField.setHistoryPropertyName(historyPropertyName);
        this.mySearchTextField.setTextIgnoreEvents(searchPanel.getQuery());
    }

    private void showSearchPanel(@NotNull String query) {
        if (query == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(3);
        }
        if (this.myCurrentSearchPanel.isEmpty()) {
            this.myCardPanel.select(this.myCurrentSearchPanel.tabIndex, true);
        }
        this.myCurrentSearchPanel.setQuery(query);
    }

    private void hideSearchPanel() {
        if (!this.myCurrentSearchPanel.isEmpty()) {
            this.myCardPanel.select(this.myCurrentSearchPanel.backTabIndex, true);
            this.myCurrentSearchPanel.setQuery("");
        }
        if (this.myCurrentSearchPanel.controller != null) {
            this.myCurrentSearchPanel.controller.hidePopup();
        }
    }

    private void removeDetailsPanel() {
        if (this.myPluginsModel.detailPanel != null) {
            this.mySearchTextField.setVisible(true);
            this.myPluginsModel.detailPanel.close();
            this.myPluginsModel.detailPanel = null;
            this.myTopController.setLeftComponent(null);
            this.myCardPanel.remove(this.myCardPanel.getComponentCount() - 1);
        }
    }

    private static int getStoredSelectionTab() {
        int value = PropertiesComponent.getInstance().getInt(SELECTION_TAB_KEY, 0);
        return value >= 0 && value <= 2 ? value : 0;
    }

    private static void storeSelectionTab(int value) {
        if (value >= 0 && value <= 2) {
            PropertiesComponent.getInstance().setValue(SELECTION_TAB_KEY, value, 0);
        }
    }

    public void disposeUIResources() {
        this.myPluginsModel.toBackground();
        Disposer.dispose((Disposable)this.mySearchUpdateAlarm);
        this.myTrendingSearchPanel.dispose();
        if (this.myTrendingPanel != null) {
            this.myTrendingPanel.dispose();
        }
        if (this.myUpdatesPanel != null) {
            this.myUpdatesPanel.dispose();
        }
        if (this.myShutdownCallback != null) {
            this.myShutdownCallback.run();
            this.myShutdownCallback = null;
        }
    }

    public void apply() throws ConfigurationException {
        HashMap<PluginId, Set<PluginId>> dependencies = new HashMap<PluginId, Set<PluginId>>(this.myPluginsModel.getDependentToRequiredListMap());
        Iterator I = dependencies.entrySet().iterator();
        while (I.hasNext()) {
            Map.Entry entry = I.next();
            boolean hasNonModuleDeps = false;
            for (PluginId pluginId2 : (Set)entry.getValue()) {
                if (PluginManagerCore.isModuleDependency(pluginId2)) continue;
                hasNonModuleDeps = true;
                break;
            }
            if (hasNonModuleDeps) continue;
            I.remove();
        }
        if (!dependencies.isEmpty()) {
            throw new ConfigurationException("<html><body style=\"padding: 5px;\">Unable to apply changes: plugin" + (dependencies.size() == 1 ? " " : "s ") + StringUtil.join(dependencies.keySet(), pluginId -> {
                IdeaPluginDescriptor descriptor = PluginManager.getPlugin(pluginId);
                return "\"" + (descriptor == null ? pluginId.getIdString() : descriptor.getName()) + "\"";
            }, (String)", ") + " won't be able to load.</body></html>");
        }
        int rowCount = this.myPluginsModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IdeaPluginDescriptor descriptor = this.myPluginsModel.getObjectAt(i);
            descriptor.setEnabled(this.myPluginsModel.isEnabled(descriptor.getPluginId()));
        }
        ArrayList<String> disableIds = new ArrayList<String>();
        for (Map.Entry<PluginId, Boolean> entry : this.myPluginsModel.getEnabledMap().entrySet()) {
            Boolean enabled = entry.getValue();
            if (enabled == null || enabled.booleanValue()) continue;
            disableIds.add(entry.getKey().getIdString());
        }
        try {
            PluginManagerCore.saveDisabledPlugins(disableIds, false);
        }
        catch (IOException e) {
            PluginManagerMain.LOG.error((Throwable)e);
        }
        if (this.myShutdownCallback == null && this.myPluginsModel.createShutdownCallback) {
            this.myShutdownCallback = () -> ApplicationManager.getApplication().invokeLater(() -> PluginManagerConfigurable.shutdownOrRestartApp(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0])), ModalityState.any());
        }
    }

    public boolean isModified() {
        if (this.myPluginsModel.needRestart) {
            return true;
        }
        List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
        int rowCount = this.myPluginsModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IdeaPluginDescriptor descriptor = this.myPluginsModel.getObjectAt(i);
            PluginId pluginId = descriptor.getPluginId();
            boolean enabledInTable = this.myPluginsModel.isEnabled(pluginId);
            if (descriptor.isEnabled() == enabledInTable || enabledInTable && !disabledPlugins.contains(pluginId.getIdString())) continue;
            return true;
        }
        for (Map.Entry<PluginId, Boolean> entry : this.myPluginsModel.getEnabledMap().entrySet()) {
            Boolean enabled = entry.getValue();
            if (enabled == null || enabled.booleanValue() || disabledPlugins.contains(entry.getKey().getIdString())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Component getCenterComponent(@NotNull Configurable.TopComponentController controller) {
        if (controller == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(4);
        }
        this.myTopController = controller;
        this.myPluginsModel.setTopController(controller);
        TabHeaderComponent tabHeaderComponent = this.myTabHeaderComponent;
        if (tabHeaderComponent == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(5);
        }
        return tabHeaderComponent;
    }

    @NotNull
    private JComponent createTrendingPanel() {
        this.myTrendingPanel = new PluginsGroupComponentWithProgress((LayoutManager)((Object)new PluginsGridLayout()), EventHandler.EMPTY, this.myNameListener, this.mySearchListener, (Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent>)((Function)descriptor -> new GridCellPluginComponent(this.myPluginsModel, (IdeaPluginDescriptor)descriptor, this.myTagBuilder)));
        Runnable runnable2 = () -> {
            ArrayList<PluginsGroup> groups = new ArrayList<PluginsGroup>();
            try {
                Pair<Map<String, IdeaPluginDescriptor>, Map<String, List<IdeaPluginDescriptor>>> pair = this.loadPluginRepositories();
                Map allRepositoriesMap = (Map)pair.first;
                Map customRepositoriesMap = (Map)pair.second;
                HashSet<String> excludeDescriptors = new HashSet<String>();
                this.addGroup(groups, excludeDescriptors, allRepositoriesMap, "Featured", "is_featured_search=true", "sortBy:featured");
                this.addGroup(groups, excludeDescriptors, allRepositoriesMap, "New and Updated", "orderBy=update+date", "sortBy:updated");
                this.addGroup(groups, excludeDescriptors, allRepositoriesMap, "Top Downloads", "orderBy=downloads", "sortBy:downloads");
                this.addGroup(groups, excludeDescriptors, allRepositoriesMap, "Top Rated", "orderBy=rating", "sortBy:rating");
                for (String host : UpdateSettings.getInstance().getPluginHosts()) {
                    List allDescriptors = (List)customRepositoriesMap.get(host);
                    if (allDescriptors == null) continue;
                    this.addGroup(groups, "Repository: " + host, "repository:\"" + host + "\"", (ThrowableConsumer<List<IdeaPluginDescriptor>, IOException>)((ThrowableConsumer)descriptors -> {
                        descriptors.addAll(allDescriptors.subList(0, Math.min(9, allDescriptors.size())));
                        PluginsGroup.sortByName(descriptors);
                    }));
                }
            }
            catch (IOException e) {
                PluginManagerMain.LOG.info((Throwable)e);
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myTrendingPanel.stopLoading();
                    for (PluginsGroup group : groups) {
                        this.myTrendingPanel.addGroup(group);
                    }
                    this.myTrendingPanel.doLayout();
                    this.myTrendingPanel.initialSelection();
                }, ModalityState.any());
            }
        };
        this.myTrendingRunnable = () -> {
            this.myTrendingPanel.clear();
            this.myTrendingPanel.startLoading();
            ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        };
        this.myTrendingPanel.getEmptyText().setText("Marketplace plugins are not loaded.").appendSecondaryText("Check the internet connection and ", StatusText.DEFAULT_ATTRIBUTES, null).appendSecondaryText("refresh", SimpleTextAttributes.LINK_ATTRIBUTES, e -> this.myTrendingRunnable.run());
        ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        JComponent jComponent = PluginManagerConfigurableNew.createScrollPane(this.myTrendingPanel, false);
        if (jComponent == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    @NotNull
    private JComponent createInstalledPanel() {
        PluginsGroupComponent panel2 = new PluginsGroupComponent((LayoutManager)((Object)new PluginsListLayout()), new MultiSelectionEventHandler(), this.myNameListener, this.mySearchListener, (Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent>)((Function)descriptor -> new ListPluginComponent(this.myPluginsModel, (IdeaPluginDescriptor)descriptor, false)));
        PluginManagerConfigurableNew.registerCopyProvider(panel2);
        PluginsGroup installing = new PluginsGroup("Installing");
        installing.descriptors.addAll(MyPluginModel.getInstallingPlugins());
        if (!installing.descriptors.isEmpty()) {
            installing.sortByName();
            installing.titleWithCount();
            panel2.addGroup(installing);
        }
        PluginsGroup downloaded = new PluginsGroup("Downloaded");
        PluginsGroup bundled = new PluginsGroup("Bundled");
        downloaded.descriptors.addAll(InstalledPluginsState.getInstance().getInstalledPlugins());
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        int bundledEnabled = 0;
        int downloadedEnabled = 0;
        for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
            if (appInfo.isEssentialPlugin(descriptor2.getPluginId().getIdString())) continue;
            if (descriptor2.isBundled()) {
                bundled.descriptors.add(descriptor2);
                if (!descriptor2.isEnabled()) continue;
                ++bundledEnabled;
                continue;
            }
            downloaded.descriptors.add(descriptor2);
            if (!descriptor2.isEnabled()) continue;
            ++downloadedEnabled;
        }
        if (!downloaded.descriptors.isEmpty()) {
            downloaded.sortByName();
            downloaded.titleWithCount(downloadedEnabled);
            panel2.addGroup(downloaded);
            this.myPluginsModel.addEnabledGroup(downloaded);
        }
        this.myPluginsModel.setDownloadedGroup(panel2, downloaded, installing);
        bundled.sortByName();
        bundled.titleWithCount(bundledEnabled);
        panel2.addGroup(bundled);
        this.myPluginsModel.addEnabledGroup(bundled);
        this.myInstalledPanel = panel2;
        JComponent jComponent = PluginManagerConfigurableNew.createScrollPane(panel2, true);
        if (jComponent == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    @NotNull
    private JComponent createUpdatesPanel() {
        this.myUpdatesPanel = new PluginsGroupComponentWithProgress((LayoutManager)((Object)new PluginsListLayout()), new MultiSelectionEventHandler(), this.myNameListener, this.mySearchListener, (Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent>)((Function)descriptor -> new ListPluginComponent(this.myPluginsModel, (IdeaPluginDescriptor)descriptor, true)));
        PluginManagerConfigurableNew.registerCopyProvider(this.myUpdatesPanel);
        Runnable runnable2 = () -> {
            Collection<PluginDownloader> updates = UpdateChecker.getPluginUpdates();
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myUpdatesPanel.stopLoading();
                if (ContainerUtil.isEmpty((Collection)updates)) {
                    this.myUpdatesTabName.setCount(0);
                } else {
                    final PluginsGroup group = new PluginsGroup("Available Updates"){

                        @Override
                        public void titleWithCount() {
                            int count = 0;
                            for (CellPluginComponent component : this.ui.plugins) {
                                if (((ListPluginComponent)component).myUpdateButton == null) continue;
                                ++count;
                            }
                            this.title = this.myTitlePrefix + " (" + count + ")";
                            this.updateTitle();
                            this.rightAction.setVisible(count > 0);
                            PluginManagerConfigurableNew.this.myUpdatesTabName.setCount(count);
                        }
                    };
                    group.rightAction = new LinkLabel("Update All", null);
                    group.rightAction.setListener((LinkListener)new LinkListener<Object>(){

                        public void linkSelected(LinkLabel aSource, Object aLinkData) {
                            for (CellPluginComponent component : group.ui.plugins) {
                                ((ListPluginComponent)component).updatePlugin();
                            }
                        }
                    }, null);
                    for (PluginDownloader toUpdateDownloader : updates) {
                        group.descriptors.add(toUpdateDownloader.getDescriptor());
                    }
                    group.sortByName();
                    this.myUpdatesPanel.addGroup(group);
                    group.titleWithCount();
                    this.myPluginsModel.setUpdateGroup(group);
                }
                this.myUpdatesPanel.doLayout();
                this.myUpdatesPanel.initialSelection();
            }, ModalityState.any());
        };
        this.myUpdatesRunnable = () -> {
            this.myUpdatesPanel.clear();
            this.myUpdatesPanel.startLoading();
            ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        };
        this.myUpdatesPanel.getEmptyText().setText("No updates available.").appendSecondaryText("Check new updates", SimpleTextAttributes.LINK_ATTRIBUTES, e -> this.myUpdatesRunnable.run());
        ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        JComponent jComponent = PluginManagerConfigurableNew.createScrollPane(this.myUpdatesPanel, false);
        if (jComponent == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(8);
        }
        return jComponent;
    }

    private void createSearchPanels() {
        SearchPopupController trendingController = new SearchPopupController(this.mySearchTextField){

            @Override
            @NotNull
            protected List<String> getAttributes() {
                ArrayList<String> attributes = new ArrayList<String>();
                attributes.add("tag:");
                if (!UpdateSettings.getInstance().getPluginHosts().isEmpty()) {
                    attributes.add("repository:");
                }
                attributes.add("sortBy:");
                ArrayList<String> arrayList = attributes;
                if (arrayList == null) {
                    12.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            @Override
            @Nullable
            protected List<String> getValues(@NotNull String attribute) {
                if (attribute == null) {
                    12.$$$reportNull$$$0(1);
                }
                switch (attribute) {
                    case "tag:": {
                        if (ContainerUtil.isEmpty((Collection)PluginManagerConfigurableNew.this.myAllTagSorted)) {
                            HashSet<String> allTags = new HashSet<String>();
                            for (IdeaPluginDescriptor descriptor : PluginManagerConfigurableNew.this.getPluginRepositories()) {
                                List<String> tags;
                                if (!(descriptor instanceof PluginNode) || ContainerUtil.isEmpty(tags = ((PluginNode)descriptor).getTags())) continue;
                                allTags.addAll(tags);
                            }
                            PluginManagerConfigurableNew.this.myAllTagSorted = ContainerUtil.sorted(allTags, String::compareToIgnoreCase);
                        }
                        return PluginManagerConfigurableNew.this.myAllTagSorted;
                    }
                    case "repository:": {
                        return UpdateSettings.getInstance().getPluginHosts();
                    }
                    case "sortBy:": {
                        return ContainerUtil.list((Object[])new String[]{"downloads", "name", "rating", "featured", "updated"});
                    }
                }
                return null;
            }

            @Override
            protected void showPopupForQuery() {
                boolean update;
                String query = PluginManagerConfigurableNew.this.mySearchTextField.getText().trim();
                if (PluginManagerConfigurableNew.this.mySearchTextField.getTextEditor().getCaretPosition() < query.length()) {
                    this.hidePopup();
                    return;
                }
                List<IdeaPluginDescriptor> result2 = this.loadSuggestPlugins(query);
                if (result2.isEmpty()) {
                    this.hidePopup();
                    return;
                }
                boolean async = this.myPopup != null;
                boolean bl = update = this.myPopup != null && this.myPopup.type == SearchPopup.Type.SearchQuery && this.myPopup.isValid();
                if (update) {
                    this.myPopup.model.replaceAll(result2);
                } else {
                    this.createPopup(SearchPopup.Type.SearchQuery, (CollectionListModel<Object>)new CollectionListModel(result2), 0);
                }
                this.myPopup.data = query;
                if (update) {
                    this.myPopup.update();
                    return;
                }
                Consumer callback2 = descriptor -> {
                    this.hidePopup();
                    PluginManagerConfigurableNew.this.myNameListener.linkSelected(null, descriptor);
                };
                ColoredListCellRenderer renderer = new ColoredListCellRenderer(){

                    protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
                        if (list2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)value;
                        String splitter = myPopup == null ? null : (String)(this).myPopup.data;
                        for (String partName : SearchQueryParser.split(descriptor.getName(), splitter)) {
                            this.append(partName, partName.equalsIgnoreCase(splitter) ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        }
                        if (PluginManagerConfigurableNew.isJBPlugin(descriptor)) {
                            this.append(" by JetBrains", SimpleTextAttributes.GRAY_ATTRIBUTES);
                        } else {
                            String vendor = descriptor.getVendor();
                            if (!StringUtil.isEmptyOrSpaces((String)vendor)) {
                                this.append(" by " + StringUtil.shortenPathWithEllipsis((String)vendor, (int)50), SimpleTextAttributes.GRAY_ATTRIBUTES);
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/plugins/PluginManagerConfigurableNew$12$1", "customizeCellRenderer"));
                    }
                };
                this.myPopup.createAndShow(callback2, renderer, async);
            }

            @NotNull
            private List<IdeaPluginDescriptor> loadSuggestPlugins(@NotNull String query) {
                if (query == null) {
                    12.$$$reportNull$$$0(2);
                }
                LinkedHashSet result2 = new LinkedHashSet();
                try {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        if (query == null) {
                            12.$$$reportNull$$$0(4);
                        }
                        try {
                            Pair p = PluginManagerConfigurableNew.this.loadPluginRepositories();
                            Map allRepositoriesMap = (Map)p.first;
                            Map customRepositoriesMap = (Map)p.second;
                            if (query.length() > 1) {
                                try {
                                    for (String pluginId : PluginManagerConfigurableNew.requestToPluginRepository(PluginManagerConfigurableNew.createSearchSuggestUrl(query), PluginManagerConfigurableNew.forceHttps())) {
                                        IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)allRepositoriesMap.get(pluginId);
                                        if (descriptor == null) continue;
                                        result2.add(descriptor);
                                    }
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            for (List descriptors : customRepositoriesMap.values()) {
                                for (IdeaPluginDescriptor descriptor : descriptors) {
                                    if (!StringUtil.containsIgnoreCase((String)descriptor.getName(), (String)query)) continue;
                                    result2.add(descriptor);
                                }
                            }
                        }
                        catch (IOException e) {
                            PluginManagerMain.LOG.info((Throwable)e);
                        }
                    }).get(300L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ArrayList arrayList = ContainerUtil.newArrayList(result2);
                if (arrayList == null) {
                    12.$$$reportNull$$$0(3);
                }
                return arrayList;
            }

            @Override
            protected void handleEnter() {
                if (!PluginManagerConfigurableNew.this.mySearchTextField.getText().isEmpty()) {
                    this.handleTrigger("marketplace.suggest.popup.enter");
                }
            }

            @Override
            protected void handlePopupListFirstSelection() {
                this.handleTrigger("marketplace.suggest.popup.select");
            }

            private void handleTrigger(@NonNls String key) {
                if (this.myPopup != null && this.myPopup.type == SearchPopup.Type.SearchQuery) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed(key);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$12";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attribute";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "query";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAttributes";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$12";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "loadSuggestPlugins";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getValues";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "loadSuggestPlugins";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$loadSuggestPlugins$1";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myTrendingSearchPanel = new SearchResultPanel(trendingController, this.createSearchPanelComponentWithProgress(), 3, 0){

            @Override
            protected void handleQuery(@NotNull String query, @NotNull PluginsGroup result2) {
                if (query == null) {
                    13.$$$reportNull$$$0(0);
                }
                if (result2 == null) {
                    13.$$$reportNull$$$0(1);
                }
                try {
                    Pair p = PluginManagerConfigurableNew.this.loadPluginRepositories();
                    Map allRepositoriesMap = (Map)p.first;
                    Map customRepositoriesMap = (Map)p.second;
                    SearchQueryParser.Trending parser = new SearchQueryParser.Trending(query);
                    if (!parser.repositories.isEmpty()) {
                        for (String repository : parser.repositories) {
                            List descriptors = (List)customRepositoriesMap.get(repository);
                            if (descriptors == null) continue;
                            if (parser.searchQuery == null) {
                                result2.descriptors.addAll(descriptors);
                                continue;
                            }
                            for (IdeaPluginDescriptor descriptor : descriptors) {
                                if (!StringUtil.containsIgnoreCase((String)descriptor.getName(), (String)parser.searchQuery)) continue;
                                result2.descriptors.add(descriptor);
                            }
                        }
                        result2.sortByName();
                        return;
                    }
                    for (String pluginId : PluginManagerConfigurableNew.requestToPluginRepository(PluginManagerConfigurableNew.createSearchUrl(parser.getUrlQuery(), 10000), PluginManagerConfigurableNew.forceHttps())) {
                        IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)allRepositoriesMap.get(pluginId);
                        if (descriptor == null) continue;
                        result2.descriptors.add(descriptor);
                    }
                    if (parser.searchQuery != null) {
                        for (List descriptors : customRepositoriesMap.values()) {
                            for (IdeaPluginDescriptor descriptor : descriptors) {
                                if (!StringUtil.containsIgnoreCase((String)descriptor.getName(), (String)parser.searchQuery)) continue;
                                result2.descriptors.add(descriptor);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    PluginManagerMain.LOG.info((Throwable)e);
                    ApplicationManager.getApplication().invokeLater(() -> this.myPanel.getEmptyText().setText("Search result are not loaded.").appendSecondaryText("Check the internet connection.", StatusText.DEFAULT_ATTRIBUTES, null), ModalityState.any());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "query";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$13";
                objectArray[2] = "handleQuery";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        SearchPopupController installedController = new SearchPopupController(this.mySearchTextField){

            @Override
            @NotNull
            protected List<String> getAttributes() {
                List list2 = ContainerUtil.list((Object[])new String[]{"#disabled", "#enabled", "#bundled", "#custom", "#inactive", "#invalid", "#outdated", "#uninstalled"});
                if (list2 == null) {
                    14.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Override
            @Nullable
            protected List<String> getValues(@NotNull String attribute) {
                if (attribute == null) {
                    14.$$$reportNull$$$0(1);
                }
                return null;
            }

            @Override
            protected void handleAppendToQuery() {
                this.showPopupForQuery();
            }

            @Override
            protected void handleAppendAttributeValue() {
                this.showPopupForQuery();
            }

            @Override
            protected void showPopupForQuery() {
                PluginManagerConfigurableNew.this.showSearchPanel(PluginManagerConfigurableNew.this.mySearchTextField.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$14";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attribute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAttributes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$14";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getValues";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myInstalledSearchPanel = new SearchResultPanel(installedController, this.createLocalSearchPanelComponent(false), 4, 1){

            @Override
            protected void handleQuery(@NotNull String query, @NotNull PluginsGroup result2) {
                if (query == null) {
                    15.$$$reportNull$$$0(0);
                }
                if (result2 == null) {
                    15.$$$reportNull$$$0(1);
                }
                InstalledPluginsState state = InstalledPluginsState.getInstance();
                SearchQueryParser.Installed parser = new SearchQueryParser.Installed(query);
                for (UIPluginGroup uiGroup : PluginManagerConfigurableNew.this.myInstalledPanel.getGroups()) {
                    for (CellPluginComponent plugin : uiGroup.plugins) {
                        if (parser.attributes) {
                            if (parser.enabled != null && parser.enabled.booleanValue() != PluginManagerConfigurableNew.this.myPluginsModel.isEnabled(plugin.myPlugin) || parser.bundled != null && parser.bundled.booleanValue() != plugin.myPlugin.isBundled() || parser.invalid != null && parser.invalid.booleanValue() != PluginManagerConfigurableNew.this.myPluginsModel.hasErrors(plugin.myPlugin) || parser.deleted != null && (plugin.myPlugin instanceof IdeaPluginDescriptorImpl ? parser.deleted.booleanValue() != ((IdeaPluginDescriptorImpl)plugin.myPlugin).isDeleted() : parser.deleted != false)) continue;
                            PluginId pluginId = plugin.myPlugin.getPluginId();
                            if (parser.needUpdate != null && parser.needUpdate.booleanValue() != state.hasNewerVersion(pluginId) || parser.needRestart != null && parser.needRestart != (state.wasInstalled(pluginId) || state.wasUpdated(pluginId))) continue;
                        }
                        if (parser.searchQuery != null && !StringUtil.containsIgnoreCase((String)plugin.myPlugin.getName(), (String)parser.searchQuery)) continue;
                        result2.descriptors.add(plugin.myPlugin);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "query";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$15";
                objectArray[2] = "handleQuery";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myUpdatesSearchPanel = new SearchResultPanel(null, this.createLocalSearchPanelComponent(true), 5, 2){

            @Override
            protected void handleQuery(@NotNull String query, @NotNull PluginsGroup result2) {
                if (query == null) {
                    16.$$$reportNull$$$0(0);
                }
                if (result2 == null) {
                    16.$$$reportNull$$$0(1);
                }
                for (UIPluginGroup uiGroup : PluginManagerConfigurableNew.this.myUpdatesPanel.getGroups()) {
                    for (CellPluginComponent plugin : uiGroup.plugins) {
                        if (!StringUtil.containsIgnoreCase((String)plugin.myPlugin.getName(), (String)query)) continue;
                        result2.descriptors.add(plugin.myPlugin);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "query";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$16";
                objectArray[2] = "handleQuery";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private JComponent createDetailsPanel(@NotNull Pair<IdeaPluginDescriptor, Boolean> data) {
        if (data == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(9);
        }
        this.myPluginsModel.detailPanel = new DetailsPagePluginComponent(this.myPluginsModel, this.myTagBuilder, this.mySearchListener, (IdeaPluginDescriptor)data.first, (Boolean)data.second);
        this.mySearchTextField.setVisible(false);
        DetailsPagePluginComponent detailsPagePluginComponent = this.myPluginsModel.detailPanel;
        if (detailsPagePluginComponent == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(10);
        }
        return detailsPagePluginComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTrendingAndUpdatesPanels() {
        Object object = this.myRepositoriesLock;
        synchronized (object) {
            this.myAllRepositoriesList = null;
            this.myAllRepositoriesMap = null;
            this.myCustomRepositoriesMap = null;
        }
        if (this.myTrendingPanel == null && this.myUpdatesPanel == null) {
            return;
        }
        int selectionTab = this.myTabHeaderComponent.getSelectionTab();
        if (selectionTab == 0) {
            if (this.myUpdatesPanel != null) {
                this.myUpdatesPanel.setVisibleRunnable(this.myUpdatesRunnable);
            }
            this.myTrendingRunnable.run();
        } else if (selectionTab == 2) {
            if (this.myTrendingPanel != null) {
                this.myTrendingPanel.setVisibleRunnable(this.myTrendingRunnable);
            }
            this.myUpdatesRunnable.run();
        } else {
            if (this.myTrendingPanel != null) {
                this.myTrendingPanel.setVisibleRunnable(this.myTrendingRunnable);
            }
            if (this.myUpdatesPanel != null) {
                this.myUpdatesPanel.setVisibleRunnable(this.myUpdatesRunnable);
            }
        }
    }

    @NotNull
    private static JComponent createScrollPane(@NotNull PluginsGroupComponent panel2, boolean initSelection) {
        if (panel2 == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(11);
        }
        JBScrollPane pane = new JBScrollPane((Component)((Object)panel2));
        pane.setBorder((Border)JBUI.Borders.empty());
        if (initSelection) {
            panel2.initialSelection();
        }
        JBScrollPane jBScrollPane = pane;
        if (jBScrollPane == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(12);
        }
        return jBScrollPane;
    }

    private void addGroup(@NotNull List<PluginsGroup> groups, @NotNull String name, @NotNull String showAllQuery, @NotNull ThrowableConsumer<List<IdeaPluginDescriptor>, IOException> consumer) throws IOException {
        if (groups == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(13);
        }
        if (name == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(14);
        }
        if (showAllQuery == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(15);
        }
        if (consumer == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(16);
        }
        PluginsGroup group = new PluginsGroup(name);
        consumer.consume(group.descriptors);
        if (!group.descriptors.isEmpty()) {
            group.rightAction = new LinkLabel("Show All", null, this.mySearchListener, (Object)showAllQuery);
            groups.add(group);
        }
    }

    private void addGroup(@NotNull List<PluginsGroup> groups, @NotNull Set<String> excludeDescriptors, @NotNull Map<String, IdeaPluginDescriptor> allRepositoriesMap, @NotNull String name, @NotNull String query, @NotNull String showAllQuery) throws IOException {
        if (groups == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(17);
        }
        if (excludeDescriptors == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(18);
        }
        if (allRepositoriesMap == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(19);
        }
        if (name == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(20);
        }
        if (query == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(21);
        }
        if (showAllQuery == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(22);
        }
        this.addGroup(groups, name, showAllQuery, (ThrowableConsumer<List<IdeaPluginDescriptor>, IOException>)((ThrowableConsumer)descriptors -> {
            if (allRepositoriesMap == null) {
                PluginManagerConfigurableNew.$$$reportNull$$$0(57);
            }
            if (excludeDescriptors == null) {
                PluginManagerConfigurableNew.$$$reportNull$$$0(58);
            }
            if (query == null) {
                PluginManagerConfigurableNew.$$$reportNull$$$0(59);
            }
            PluginManagerConfigurableNew.loadPlugins(descriptors, allRepositoriesMap, excludeDescriptors, query);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Pair<Map<String, IdeaPluginDescriptor>, Map<String, List<IdeaPluginDescriptor>>> loadPluginRepositories() throws IOException {
        Object object = this.myRepositoriesLock;
        // MONITORENTER : object
        if (this.myAllRepositoriesMap != null) {
            Pair pair = Pair.create(this.myAllRepositoriesMap, this.myCustomRepositoriesMap);
            // MONITOREXIT : object
            if (pair != null) return pair;
            PluginManagerConfigurableNew.$$$reportNull$$$0(23);
            return pair;
        }
        // MONITOREXIT : object
        ArrayList<IdeaPluginDescriptor> list2 = new ArrayList<IdeaPluginDescriptor>();
        HashMap<String, IdeaPluginDescriptor> map = new HashMap<String, IdeaPluginDescriptor>();
        HashMap<String, List<IdeaPluginDescriptor>> custom = new HashMap<String, List<IdeaPluginDescriptor>>();
        IOException exception = null;
        for (String host : RepositoryHelper.getPluginHosts()) {
            try {
                List<IdeaPluginDescriptor> descriptors = RepositoryHelper.loadPlugins(host, null);
                if (host != null) {
                    custom.put(host, descriptors);
                }
                for (IdeaPluginDescriptor plugin : descriptors) {
                    String id = plugin.getPluginId().getIdString();
                    if (map.containsKey(id)) continue;
                    list2.add(plugin);
                    map.put(id, plugin);
                }
            }
            catch (IOException e) {
                if (host == null) {
                    exception = e;
                    continue;
                }
                PluginManagerMain.LOG.info(host, (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            InstalledPluginsState state = InstalledPluginsState.getInstance();
            for (IdeaPluginDescriptor descriptor : list2) {
                state.onDescriptorDownload(descriptor);
            }
        });
        Object object2 = this.myRepositoriesLock;
        // MONITORENTER : object2
        if (this.myAllRepositoriesList == null) {
            this.myAllRepositoriesList = list2;
            this.myAllRepositoriesMap = map;
            this.myCustomRepositoriesMap = custom;
        }
        Pair pair = Pair.create(this.myAllRepositoriesMap, this.myCustomRepositoriesMap);
        // MONITOREXIT : object2
        if (pair != null) return pair;
        PluginManagerConfigurableNew.$$$reportNull$$$0(24);
        return pair;
    }

    private static void loadPlugins(@NotNull List<? super IdeaPluginDescriptor> descriptors, @NotNull Map<String, IdeaPluginDescriptor> allDescriptors, @NotNull Set<? super String> excludeDescriptors, @NotNull String query) throws IOException {
        Url baseUrl;
        if (descriptors == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(25);
        }
        if (allDescriptors == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(26);
        }
        if (excludeDescriptors == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(27);
        }
        if (query == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(28);
        }
        boolean forceHttps = PluginManagerConfigurableNew.forceHttps();
        Url offsetUrl = baseUrl = PluginManagerConfigurableNew.createSearchUrl(query, 9);
        HashMap<String, String> offsetParameters = new HashMap<String, String>();
        int offset = 0;
        List<String> pluginIds;
        while (!(pluginIds = PluginManagerConfigurableNew.requestToPluginRepository(offsetUrl, forceHttps)).isEmpty()) {
            for (String pluginId : pluginIds) {
                IdeaPluginDescriptor descriptor = allDescriptors.get(pluginId);
                if (descriptor == null || !excludeDescriptors.add(pluginId) || PluginManager.getPlugin(descriptor.getPluginId()) != null) continue;
                descriptors.add((IdeaPluginDescriptor)descriptor);
                if (descriptors.size() != 9) continue;
                return;
            }
            offsetParameters.put("offset", Integer.toString(offset += pluginIds.size()));
            offsetUrl = baseUrl.addParameters(offsetParameters);
        }
        return;
    }

    @NotNull
    private static List<String> requestToPluginRepository(@NotNull Url url, boolean forceHttps) throws IOException {
        if (url == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(29);
        }
        ArrayList<String> ids = new ArrayList<String>();
        HttpRequests.request((Url)url).forceHttps(forceHttps).throwStatusCodeException(false).productNameAsUserAgent().connect(request -> {
            URLConnection connection = request.getConnection();
            if (connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() != 200) {
                return null;
            }
            try (JsonReaderEx json = new JsonReaderEx(FileUtil.loadTextAndClose((Reader)request.getReader()));){
                if (json.peek() == JsonToken.BEGIN_OBJECT) {
                    json.beginObject();
                    json.nextName();
                    json.nextString();
                    json.nextName();
                }
                json.beginArray();
                while (json.hasNext()) {
                    ids.add(json.nextString());
                }
            }
            return null;
        });
        ArrayList<String> arrayList = ids;
        if (arrayList == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @NotNull
    private static Url createSearchUrl(@NotNull String query, int count) {
        if (query == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(31);
        }
        Url url = Urls.newFromEncoded("http://plugins.jetbrains.com/api/search?" + query + "&build=" + URLUtil.encodeURIComponent((String)ApplicationInfoImpl.getShadowInstance().getApiVersion()) + "&max=" + count);
        if (url == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(32);
        }
        return url;
    }

    @NotNull
    private static Url createSearchSuggestUrl(@NotNull String query) {
        if (query == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(33);
        }
        Url url = Urls.newFromEncoded("http://plugins.jetbrains.com/api/searchSuggest?term=" + URLUtil.encodeURIComponent((String)query) + "&productCode=" + URLUtil.encodeURIComponent((String)ApplicationInfoImpl.getShadowInstance().getBuild().getProductCode()));
        if (url == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(34);
        }
        return url;
    }

    private static boolean forceHttps() {
        return IdeaApplication.isLoaded() && UpdateSettings.getInstance().canUseSecureConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private List<IdeaPluginDescriptor> getPluginRepositories() {
        block9: {
            List<IdeaPluginDescriptor> list2;
            Object object = this.myRepositoriesLock;
            synchronized (object) {
                if (this.myAllRepositoriesList != null) {
                    List<IdeaPluginDescriptor> list3 = this.myAllRepositoriesList;
                    // MONITOREXIT @DISABLED, blocks:[3, 8] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (list3 == null) {
                        PluginManagerConfigurableNew.$$$reportNull$$$0(35);
                    }
                    return list3;
                }
            }
            try {
                List<IdeaPluginDescriptor> list4 = RepositoryHelper.loadCachedPlugins();
                if (list4 == null) break block9;
                list2 = list4;
            }
            catch (IOException e) {
                PluginManagerMain.LOG.info((Throwable)e);
                break block9;
            }
            if (list2 == null) {
                PluginManagerConfigurableNew.$$$reportNull$$$0(36);
            }
            return list2;
        }
        List<IdeaPluginDescriptor> list5 = Collections.emptyList();
        if (list5 == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(37);
        }
        return list5;
    }

    @NotNull
    public static String getErrorMessage(@NotNull InstalledPluginsTableModel pluginsModel, @NotNull PluginDescriptor pluginDescriptor, @NotNull Ref<? super Boolean> enableAction) {
        String message;
        Set<PluginId> requiredPlugins;
        if (pluginsModel == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(38);
        }
        if (pluginDescriptor == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(39);
        }
        if (enableAction == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(40);
        }
        if (ContainerUtil.isEmpty(requiredPlugins = pluginsModel.getRequiredPlugins(pluginDescriptor.getPluginId()))) {
            message = "Incompatible with the current " + ApplicationNamesInfo.getInstance().getFullProductName() + " version.";
        } else if (requiredPlugins.contains(PluginId.getId((String)"com.intellij.modules.ultimate"))) {
            message = "The plugin requires IntelliJ IDEA Ultimate.";
        } else {
            String deps = StringUtil.join(requiredPlugins, id -> {
                IdeaPluginDescriptor plugin = PluginManager.getPlugin(id);
                if (plugin == null && PluginManagerCore.isModuleDependency(id)) {
                    for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                        List<String> modules;
                        if (!(descriptor instanceof IdeaPluginDescriptorImpl) || (modules = ((IdeaPluginDescriptorImpl)descriptor).getModules()) == null || !modules.contains(id.getIdString())) continue;
                        plugin = descriptor;
                        break;
                    }
                }
                return plugin != null ? plugin.getName() : id.getIdString();
            }, (String)", ");
            message = IdeBundle.message((String)"new.plugin.manager.incompatible.deps.tooltip", (Object[])new Object[]{requiredPlugins.size(), deps});
            enableAction.set((Object)Boolean.TRUE);
        }
        String string = message;
        if (string == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    public static List<String> getTags(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(42);
        }
        List<String> tags = null;
        if (plugin instanceof PluginNode) {
            tags = ((PluginNode)plugin).getTags();
        }
        if (ContainerUtil.isEmpty(tags)) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                PluginManagerConfigurableNew.$$$reportNull$$$0(43);
            }
            return list2;
        }
        int eap = tags.indexOf("EAP");
        if (eap > 0) {
            tags = new ArrayList<String>(tags);
            tags.remove(eap);
            tags.add(0, "EAP");
        }
        List<String> list3 = tags;
        if (list3 == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(44);
        }
        return list3;
    }

    @Nullable
    public static synchronized String getDownloads(@NotNull IdeaPluginDescriptor plugin) {
        String downloads;
        if (plugin == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(45);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(downloads = ((PluginNode)plugin).getDownloads()))) {
            try {
                Long value = Long.valueOf(downloads);
                if (value > 1000L) {
                    return value < 1000000L ? K_FORMAT.format((double)value.longValue() / 1000.0) : M_FORMAT.format((double)value.longValue() / 1000000.0);
                }
                return value.toString();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static synchronized String getLastUpdatedDate(@NotNull IdeaPluginDescriptor plugin) {
        long date;
        if (plugin == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(46);
        }
        return (date = ((PluginNode)plugin).getDate()) > 0L && date != Long.MAX_VALUE ? DATE_FORMAT.format(new Date(date)) : null;
    }

    @Nullable
    public static String getRating(@NotNull IdeaPluginDescriptor plugin) {
        String rating;
        if (plugin == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(47);
        }
        if ((rating = ((PluginNode)plugin).getRating()) != null) {
            try {
                if (Double.valueOf(rating) > 0.0) {
                    return StringUtil.trimEnd((String)rating, (String)".0");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void registerCopyProvider(final @NotNull PluginsGroupComponent component) {
        if (component == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(48);
        }
        CopyProvider copyProvider = new CopyProvider(){

            public void performCopy(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    17.$$$reportNull$$$0(0);
                }
                StringBuilder result2 = new StringBuilder();
                for (CellPluginComponent pluginComponent : component.getSelection()) {
                    result2.append(pluginComponent.myPlugin.getName()).append(" (").append(pluginComponent.myPlugin.getVersion()).append(")\n");
                }
                CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(result2.substring(0, result2.length() - 1)));
            }

            public boolean isCopyEnabled(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    17.$$$reportNull$$$0(1);
                }
                return !component.getSelection().isEmpty();
            }

            public boolean isCopyVisible(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    17.$$$reportNull$$$0(2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataContext";
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$17";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performCopy";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCopyEnabled";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCopyVisible";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DataManager.registerDataProvider((JComponent)((Object)component), dataId -> PlatformDataKeys.COPY_PROVIDER.is(dataId) ? copyProvider : null);
    }

    public static int getParentWidth(@NotNull Container parent) {
        int width;
        if (parent == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(49);
        }
        if ((width = parent.getWidth()) > 0) {
            Container container = parent.getParent();
            int parentWidth = container.getWidth();
            if (container instanceof JViewport && parentWidth < width) {
                width = parentWidth;
            }
        }
        return width;
    }

    @NotNull
    public static <T extends Component> T installTiny(@NotNull T component) {
        if (component == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(50);
        }
        Object object = SystemInfo.isMac ? RelativeFont.TINY.install(component) : component;
        if (object == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(51);
        }
        return object;
    }

    public static int offset5() {
        return JBUI.scale((int)5);
    }

    private static void configureBackButton(@NotNull JButton button) {
        if (button == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(52);
        }
        button.setIcon(new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                AllIcons.Actions.Back.paintIcon(c, g, x + JBUI.scale((int)7), y);
            }

            @Override
            public int getIconWidth() {
                return AllIcons.Actions.Back.getIconWidth() + JBUI.scale((int)7);
            }

            @Override
            public int getIconHeight() {
                return AllIcons.Actions.Back.getIconHeight();
            }
        });
        button.setHorizontalAlignment(2);
        Dimension size = button.getPreferredSize();
        size.width -= JBUI.scale((int)15);
        button.setPreferredSize(size);
    }

    public static boolean isJBPlugin(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(53);
        }
        return plugin.isBundled() || PluginManagerMain.isDevelopedByJetBrains(plugin);
    }

    @Nullable
    public static String getShortDescription(@NotNull IdeaPluginDescriptor plugin, boolean shortSize) {
        if (plugin == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(54);
        }
        return PluginSiteUtils.preparePluginDescription(plugin.getDescription(), shortSize);
    }

    @NotNull
    private PluginsGroupComponent createLocalSearchPanelComponent(boolean pluginForUpdate) {
        PluginsGroupComponent component = new PluginsGroupComponent((LayoutManager)((Object)new PluginsListLayout()), new MultiSelectionEventHandler(), this.myNameListener, this.mySearchListener, (Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent>)((Function)descriptor -> new ListPluginComponent(this.myPluginsModel, (IdeaPluginDescriptor)descriptor, pluginForUpdate)));
        PluginManagerConfigurableNew.registerCopyProvider(component);
        PluginsGroupComponent pluginsGroupComponent = component;
        if (pluginsGroupComponent == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(55);
        }
        return pluginsGroupComponent;
    }

    @NotNull
    private PluginsGroupComponent createSearchPanelComponentWithProgress() {
        PluginsGroupComponentWithProgress pluginsGroupComponentWithProgress = new PluginsGroupComponentWithProgress((LayoutManager)((Object)new PluginsGridLayout()), EventHandler.EMPTY, this.myNameListener, this.mySearchListener, (Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent>)((Function)descriptor -> new GridCellPluginComponent(this.myPluginsModel, (IdeaPluginDescriptor)descriptor, this.myTagBuilder)));
        if (pluginsGroupComponentWithProgress == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(56);
        }
        return pluginsGroupComponentWithProgress;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew";
                break;
            }
            case 1: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 3: 
            case 21: 
            case 28: 
            case 31: 
            case 33: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showAllQuery";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 18: 
            case 27: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeDescriptors";
                break;
            }
            case 19: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRepositoriesMap";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDescriptors";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsModel";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableAction";
                break;
            }
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrendingPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstalledPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdatesPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDetailsPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPluginRepositories";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "requestToPluginRepository";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchUrl";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchSuggestUrl";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginRepositories";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "installTiny";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalSearchPanelComponent";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchPanelComponentWithProgress";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showSearchPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCenterComponent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDetailsPanel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createScrollPane";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "loadPlugins";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "requestToPluginRepository";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createSearchUrl";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createSearchSuggestUrl";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getTags";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getDownloads";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getLastUpdatedDate";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getRating";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "registerCopyProvider";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getParentWidth";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "installTiny";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "configureBackButton";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isJBPlugin";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getShortDescription";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addGroup$23";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CountTabName
    implements Computable<String> {
        private final TabHeaderComponent myTabComponent;
        private final String myBaseName;
        private int myCount;

        CountTabName(@NotNull TabHeaderComponent component, @NotNull String baseName) {
            if (component == null) {
                CountTabName.$$$reportNull$$$0(0);
            }
            if (baseName == null) {
                CountTabName.$$$reportNull$$$0(1);
            }
            this.myCount = -1;
            this.myTabComponent = component;
            this.myBaseName = baseName;
        }

        public void setCount(int count) {
            if (this.myCount != count) {
                this.myCount = count;
                this.myTabComponent.update();
            }
        }

        public String compute() {
            return this.myCount == -1 ? this.myBaseName : this.myBaseName + " (" + this.myCount + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "baseName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$CountTabName";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

