/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.impl.VcsSelectionHistoryDialog;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionUtil;
import com.intellij.vcsUtil.VcsUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SelectedBlockHistoryAction
extends AbstractVcsAction {
    protected boolean isEnabled(VcsContext context) {
        Project project = context.getProject();
        if (project == null) {
            return false;
        }
        VcsSelection selection = VcsSelectionUtil.getSelection((VcsContext)context);
        if (selection == null) {
            return false;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(selection.getDocument());
        if (file2 == null) {
            return false;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file2);
        AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file2);
        if (activeVcs == null) {
            return false;
        }
        VcsHistoryProvider provider = activeVcs.getVcsBlockHistoryProvider();
        if (provider == null) {
            return false;
        }
        BackgroundableActionLock lock = VcsCachingHistory.getHistoryLock(activeVcs, VcsBackgroundableActions.HISTORY_FOR_SELECTION, filePath, null);
        if (lock.isLocked()) {
            return false;
        }
        return AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)filePath);
    }

    @Override
    public void actionPerformed(@NotNull VcsContext context) {
        if (context == null) {
            SelectedBlockHistoryAction.$$$reportNull$$$0(0);
        }
        try {
            Project project = context.getProject();
            assert (project != null);
            VcsSelection selection = VcsSelectionUtil.getSelection((VcsContext)context);
            assert (selection != null);
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(selection.getDocument());
            assert (file2 != null);
            AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file2);
            assert (activeVcs != null);
            VcsHistoryProvider provider = activeVcs.getVcsBlockHistoryProvider();
            assert (provider != null);
            int selectionStart = selection.getSelectionStartLineNumber();
            int selectionEnd = selection.getSelectionEndLineNumber();
            VcsCachingHistory.collectInBackground(activeVcs, VcsUtil.getFilePath((VirtualFile)file2), VcsBackgroundableActions.HISTORY_FOR_SELECTION, (Consumer<VcsHistorySession>)((Consumer)session2 -> {
                if (session2 == null) {
                    return;
                }
                VcsSelectionHistoryDialog vcsHistoryDialog = new VcsSelectionHistoryDialog(project, file2, selection.getDocument(), provider, (VcsHistorySession)session2, activeVcs, Math.min(selectionStart, selectionEnd), Math.max(selectionStart, selectionEnd), selection.getDialogTitle());
                vcsHistoryDialog.show();
            }));
        }
        catch (Exception exception) {
            SelectedBlockHistoryAction.reportError(exception);
        }
    }

    @Override
    protected void update(@NotNull VcsContext context, @NotNull Presentation presentation) {
        Editor editor;
        if (context == null) {
            SelectedBlockHistoryAction.$$$reportNull$$$0(1);
        }
        if (presentation == null) {
            SelectedBlockHistoryAction.$$$reportNull$$$0(2);
        }
        if ((editor = context.getEditor()) == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setEnabled(this.isEnabled(context));
        VcsSelection selection = VcsSelectionUtil.getSelection((VcsContext)context);
        if (selection != null) {
            presentation.setText(selection.getActionName());
        }
    }

    protected static void reportError(Exception exception) {
        Messages.showMessageDialog((String)exception.getLocalizedMessage(), (String)VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/SelectedBlockHistoryAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

