/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.highlighting;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;

public final class TextMateDefaultColorsProvider {
    private final Map<String, TextAttributesKey> DEFAULT_HIGHLIGHTING_RULES = ContainerUtil.newHashMap((Pair)Pair.create((Object)"markup.bold", (Object)HighlighterColors.TEXT), (Pair[])new Pair[]{Pair.create((Object)"markup.italic", (Object)HighlighterColors.TEXT), Pair.create((Object)"markup.underline", (Object)HighlighterColors.TEXT), Pair.create((Object)"markup.heading", (Object)HighlighterColors.TEXT), Pair.create((Object)"invalid.deprecated", (Object)HighlighterColors.TEXT), Pair.create((Object)"comment", (Object)DefaultLanguageHighlighterColors.LINE_COMMENT), Pair.create((Object)"comment.line", (Object)DefaultLanguageHighlighterColors.LINE_COMMENT), Pair.create((Object)"comment.block", (Object)DefaultLanguageHighlighterColors.BLOCK_COMMENT), Pair.create((Object)"constant", (Object)DefaultLanguageHighlighterColors.KEYWORD), Pair.create((Object)"constant.number", (Object)DefaultLanguageHighlighterColors.NUMBER), Pair.create((Object)"constant.character.escape", (Object)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE), Pair.create((Object)"invalid", (Object)HighlighterColors.BAD_CHARACTER), Pair.create((Object)"keyword", (Object)DefaultLanguageHighlighterColors.KEYWORD), Pair.create((Object)"storage", (Object)DefaultLanguageHighlighterColors.KEYWORD), Pair.create((Object)"string", (Object)DefaultLanguageHighlighterColors.STRING), Pair.create((Object)"variable", (Object)DefaultLanguageHighlighterColors.KEYWORD)});

    public Set<String> getAllDefaultKeys() {
        return this.DEFAULT_HIGHLIGHTING_RULES.keySet();
    }

    public TextAttributes getTextAttributes(String selector) {
        TextAttributesKey textAttributesKey = this.DEFAULT_HIGHLIGHTING_RULES.get(selector);
        if (textAttributesKey == null) {
            return HighlighterColors.TEXT.getDefaultAttributes();
        }
        TextAttributes textAttributes = textAttributesKey.getDefaultAttributes().clone();
        if ("markup.bold".equalsIgnoreCase(selector)) {
            textAttributes.setFontType(1);
        } else if ("markup.italic".equalsIgnoreCase(selector)) {
            textAttributes.setFontType(2);
        } else if ("markup.underline".equalsIgnoreCase(selector)) {
            textAttributes.setEffectType(EffectType.LINE_UNDERSCORE);
        } else if ("markup.heading".equalsIgnoreCase(selector)) {
            textAttributes.setEffectType(EffectType.BOLD_LINE_UNDERSCORE);
        } else if ("invalid.deprecated".equalsIgnoreCase(selector)) {
            textAttributes.setEffectType(EffectType.STRIKEOUT);
        }
        return textAttributes;
    }
}

