/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptParameterImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterInfo
implements ParameterInfo {
    public static final JSParameterInfo[] EMPTY_ARRAY = new JSParameterInfo[0];
    public static final ArrayFactory<JSParameterInfo> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new JSParameterInfo[count];
    private int myOldIndex;
    private String myTypeText = "";
    private String myCallValue = "";
    private String myInitializer = "";
    private String myModifiers = "";
    private String myDeclarationText = "";
    private boolean myIsDestructuring;
    private boolean myIsOptional;
    @Nullable
    private DialectOptionHolder myDialect;

    public static JSParameterInfo build(@NotNull JSParameterListElement parameterListElement, int index) {
        JSExpression initializerExpr;
        if (parameterListElement == null) {
            JSParameterInfo.$$$reportNull$$$0(0);
        }
        String initializer = (initializerExpr = parameterListElement.getInitializer()) == null ? null : initializerExpr.getText();
        String typeText = JSParameterInfo.buildTypeText(parameterListElement);
        JSParameter jsParameter = (JSParameter)ObjectUtils.tryCast((Object)parameterListElement, JSParameter.class);
        String modifiers = jsParameter != null && jsParameter.getAttributeList() != null ? jsParameter.getAttributeList().getText() : "";
        JSParameterInfo result2 = new JSParameterInfo(JSParameterInfo.buildDeclarationText(parameterListElement), typeText, initializer, null, index, parameterListElement.isOptional());
        result2.myModifiers = modifiers;
        result2.myIsDestructuring = parameterListElement instanceof JSDestructuringParameter;
        result2.myDialect = DialectDetector.dialectOfElement((PsiElement)parameterListElement);
        return result2;
    }

    @NotNull
    private static String buildTypeText(@NotNull JSParameterListElement parameter) {
        JSType type;
        DialectOptionHolder dialect;
        if (parameter == null) {
            JSParameterInfo.$$$reportNull$$$0(1);
        }
        if ((dialect = DialectDetector.dialectOfElement((PsiElement)parameter)) == null || !dialect.hasFeature(JSLanguageFeature.TYPES)) {
            if ("" == null) {
                JSParameterInfo.$$$reportNull$$$0(2);
            }
            return "";
        }
        JSType jSType = type = parameter instanceof TypeScriptParameterImpl ? ((TypeScriptParameterImpl)parameter).getDeclaredType() : parameter.getType();
        if (dialect.isECMA4 && parameter.isRest()) {
            if ("..." == null) {
                JSParameterInfo.$$$reportNull$$$0(3);
            }
            return "...";
        }
        if (type != null) {
            if (dialect.isTypeScript || dialect.isFlow) {
                String string = type.getTypeText(JSType.TypeTextFormat.CODE);
                if (string == null) {
                    JSParameterInfo.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = type.getResolvedTypeText();
            if (string == null) {
                JSParameterInfo.$$$reportNull$$$0(5);
            }
            return string;
        }
        if ("" == null) {
            JSParameterInfo.$$$reportNull$$$0(6);
        }
        return "";
    }

    private static String buildDeclarationText(@NotNull JSParameterListElement parameterListElement) {
        if (parameterListElement == null) {
            JSParameterInfo.$$$reportNull$$$0(7);
        }
        if (!DialectDetector.isActionScript((PsiElement)parameterListElement) && parameterListElement.isRest()) {
            return "..." + parameterListElement.getName();
        }
        if (parameterListElement instanceof TypeScriptParameterImpl && ((TypeScriptParameterImpl)parameterListElement).isDeclaredOptional()) {
            return parameterListElement.getName() + "?";
        }
        return parameterListElement.getName();
    }

    public JSParameterInfo(String declarationText, String type, String initializer, String callValue, int oldIndex, boolean optional, @Nullable DialectOptionHolder dialect) {
        this(declarationText, type, initializer, callValue, oldIndex);
        this.myIsOptional = optional;
        this.myDialect = dialect;
    }

    public JSParameterInfo(String declarationText, String type, String initializer, String callValue, int oldIndex, boolean optional) {
        this(declarationText, type, initializer, callValue, oldIndex);
        this.myIsOptional = optional;
    }

    public JSParameterInfo(String declarationText, String type, String initializer, String callValue, int oldIndex) {
        this.myDeclarationText = declarationText;
        this.myInitializer = initializer;
        this.myOldIndex = oldIndex;
        this.myTypeText = type;
        this.myCallValue = callValue;
    }

    public String getDeclarationText() {
        return this.myDeclarationText;
    }

    public void setDeclarationText(String value) {
        this.myDeclarationText = value;
    }

    public String getName() {
        return this.getDeclarationText();
    }

    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    public int getOldIndex() {
        return this.myOldIndex;
    }

    public String getDefaultValue() {
        return this.myCallValue;
    }

    public void setCallValue(String defaultValue) {
        this.myCallValue = defaultValue;
    }

    public String getTypeText() {
        return "null".equals(this.myTypeText) ? "*" : this.myTypeText;
    }

    public String getModifiersText() {
        return this.myModifiers;
    }

    public void setTypeText(String type) {
        this.myTypeText = type;
    }

    public boolean isUseAnySingleVariable() {
        return false;
    }

    public void setUseAnySingleVariable(boolean b) {
        throw new UnsupportedOperationException();
    }

    public String getInitializer() {
        return this.myInitializer;
    }

    public void setInitializer(String initializer) {
        this.myInitializer = initializer;
    }

    public boolean isOptional() {
        return this.myIsOptional;
    }

    public void setOptional(boolean optional) {
        this.myIsOptional = optional;
    }

    public void setOldIndex(int oldIndex) {
        this.myOldIndex = oldIndex;
    }

    public boolean isDestructuringParameter() {
        return this.myIsDestructuring;
    }

    public boolean isRest() {
        return StringUtil.equals((CharSequence)this.myTypeText, (CharSequence)"...") || StringUtil.startsWith((CharSequence)this.myDeclarationText, (CharSequence)"...");
    }

    @Nullable
    public DialectOptionHolder getDialect() {
        return this.myDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterListElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/changeSignature/JSParameterInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSParameterInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildDeclarationText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

