/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpHostInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessConstantInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessFieldByVariableInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessFieldInObjectContextInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpArrayAccessInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpBaseCaseConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpBreakContinueInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpCallInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpCaseConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpCatchConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpClassDeclarationInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpConstantDeclarationInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpConstructorCallInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpEntryPointInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpExitPointInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpFinallyEndInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpFunctionDeclarationInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpGotoLabelDefinitionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpHostInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpIncludeInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInterruptScriptInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpLinearInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpReturnInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpStatementInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpThrowInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpTryInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpVariableDocDeclarationInstructionImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Include;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExit;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpGoto;
import com.jetbrains.php.lang.psi.elements.PhpGotoLabel;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPrintExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpThrow;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpControlFlowBuilder
extends PhpRecursiveElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.PhpControlFlowBuilder");
    private static final String COMPACT_FUNCTION = "compact";
    private static final String ASSERT_FUNCTION = "assert";
    private final PhpScopeHolder myScopeHolder;
    private final List<PhpInstruction> instructions;
    private final List<PhpMarkerInstruction> myMarkerInstructions;
    private final List<BreakContinueTarget> myBreakContinueTargetList;
    private final List<PhpHostInstruction> myCatchMatchingList;
    private final SmartList<PhpFinallyInstructionsBlock> myFinallyBlocks;
    private final Stack<PhpConditionInstructionImpl> myTrueTargets;
    private final Stack<PhpConditionInstructionImpl> myFalseTargets;
    private Map<String, PhpGotoLabelDefinitionInstructionImpl> myLabelToDefinitionInstruction;
    private MultiMap<String, PhpMarkerInstruction> myLabelToGotoInstruction;
    private PhpPsiElement myCurrentValue;
    private PhpAccessInstruction.Access myParentAccess;
    private boolean myCurrentValueIsExpressionResult;
    private PhpAccessInstruction.Access myCurrentValuePostAccess;
    private PhpInstructionImpl lastInstruction;
    private final PhpEntryPointInstructionImpl myEntryInstruction;
    private final PhpExitPointInstructionImpl myExitInstruction;

    public PhpControlFlowBuilder(@NotNull PhpScopeHolder scopeHolder) {
        if (scopeHolder == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(0);
        }
        this.instructions = new ArrayList<PhpInstruction>();
        this.myMarkerInstructions = new SmartList();
        this.myBreakContinueTargetList = new SmartList();
        this.myCatchMatchingList = new SmartList();
        this.myFinallyBlocks = new SmartList();
        this.myTrueTargets = new Stack();
        this.myFalseTargets = new Stack();
        this.myLabelToDefinitionInstruction = null;
        this.myLabelToGotoInstruction = null;
        this.myCurrentValue = null;
        this.myParentAccess = null;
        this.myCurrentValueIsExpressionResult = false;
        this.myCurrentValuePostAccess = null;
        this.lastInstruction = null;
        this.myEntryInstruction = new PhpEntryPointInstructionImpl();
        this.myExitInstruction = new PhpExitPointInstructionImpl();
        this.myScopeHolder = scopeHolder;
    }

    public PhpControlFlow build() {
        this.addInstruction(this.myEntryInstruction);
        try {
            this.myScopeHolder.acceptChildren((PsiElementVisitor)this);
        }
        catch (StackOverflowError e) {
            LOG.warn("SOE when trying to build control flow on " + this.myScopeHolder.getName() + " in " + this.myScopeHolder.getContainingFile().getVirtualFile().getPath(), (Throwable)e);
            return new PhpControlFlowImpl(PhpControlFlowImpl.EMPTY);
        }
        this.addInstruction(this.myExitInstruction);
        for (PhpMarkerInstruction curInstruction : this.myMarkerInstructions) {
            Collection<PhpInstruction> predInstructions = curInstruction.getPredecessors();
            predInstructions.remove(curInstruction);
            PhpInstructionImpl successor = curInstruction.getSuccessor();
            for (PhpInstruction predInstruction : predInstructions) {
                ((PhpInstructionImpl)predInstruction).replaceSuccessor(curInstruction, successor);
            }
            if (successor != null) {
                successor.getPredecessors().remove(curInstruction);
                successor.getPredecessors().addAll(predInstructions);
            }
            curInstruction.dispose();
        }
        this.myMarkerInstructions.clear();
        for (int i = 0; i < this.instructions.size(); ++i) {
            ((PhpInstructionImpl)this.instructions.get((int)i)).myNumber = i;
        }
        return new PhpControlFlowImpl(this.instructions.toArray(new PhpInstruction[0]));
    }

    private void interruptFlow() {
        this.lastInstruction = null;
    }

    private void addInstruction(@NotNull PhpInstructionImpl instruction) {
        if (instruction == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(1);
        }
        if (this.lastInstruction != null) {
            this.lastInstruction.join(instruction);
        }
        this.lastInstruction = instruction;
        if (instruction instanceof PhpMarkerInstruction) {
            this.myMarkerInstructions.add((PhpMarkerInstruction)instruction);
        } else {
            this.instructions.add(instruction);
        }
    }

    private PhpStatementInstruction addStatementInstruction(@NotNull Statement statement) {
        if (statement == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(2);
        }
        PhpStatementInstructionImpl statementInstruction = new PhpStatementInstructionImpl(statement);
        this.addInstruction(statementInstruction);
        return statementInstruction;
    }

    private void jump(@NotNull PhpInstructionImpl endInstruction) {
        if (endInstruction == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(3);
        }
        if (this.lastInstruction != null) {
            this.lastInstruction.join(endInstruction);
            this.interruptFlow();
        }
    }

    private void popBreakContinueTargets() {
        this.myBreakContinueTargetList.remove(this.myBreakContinueTargetList.size() - 1);
    }

    private void pushBreakContinueTargets(@NotNull Statement statement, @NotNull PhpMarkerInstruction breakTarget, @NotNull PhpMarkerInstruction continueTarget) {
        if (statement == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(4);
        }
        if (breakTarget == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(5);
        }
        if (continueTarget == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(6);
        }
        this.myBreakContinueTargetList.add(new BreakContinueTarget(statement, breakTarget, continueTarget));
    }

    private void pushConditionTargets(@NotNull PhpConditionInstructionImpl trueTarget, @NotNull PhpConditionInstructionImpl falseTarget) {
        if (trueTarget == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(7);
        }
        if (falseTarget == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(8);
        }
        assert (trueTarget.getResult());
        assert (!falseTarget.getResult());
        this.myTrueTargets.push((Object)trueTarget);
        this.myFalseTargets.push((Object)falseTarget);
    }

    private void popConditionTargets() {
        this.myTrueTargets.pop();
        this.myFalseTargets.pop();
    }

    private void resetCurrentValue(@NotNull PhpAccessInstruction.Access access, boolean resetExpressionsResults) {
        String key;
        ArrayIndex arrayIndex;
        CharSequence variableName;
        ArrayAccessExpression accessExpression;
        PhpPsiElement value;
        if (access == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(9);
        }
        if (this.myCurrentValue instanceof Variable) {
            Variable variable = (Variable)this.myCurrentValue;
            if (variable.canReadName()) {
                CharSequence variableName2 = variable.getNameCS();
                if (!this.myCurrentValueIsExpressionResult || resetExpressionsResults) {
                    this.addInstruction(new PhpAccessVariableInstructionImpl((PhpPsiElement)variable, variableName2, access));
                }
                if (this.myCurrentValuePostAccess != null) {
                    this.addInstruction(new PhpAccessVariableInstructionImpl((PhpPsiElement)variable, variableName2, this.myCurrentValuePostAccess));
                }
            }
        } else if (this.myCurrentValue instanceof ConstantReference) {
            ConstantReference constantReference = (ConstantReference)this.myCurrentValue;
            CharSequence constantName = constantReference.getNameCS();
            if (!StringUtil.isEmpty((CharSequence)constantName) && !PhpLangUtil.isBuiltInConstant(constantName)) {
                this.addInstruction(new PhpAccessConstantInstructionImpl(constantReference, access, constantName));
            }
        } else if (this.myCurrentValue instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)this.myCurrentValue;
            CharSequence fieldName = fieldReference.getNameCS();
            if (!StringUtil.isEmpty((CharSequence)fieldName)) {
                PhpExpression reference = fieldReference.getClassReference();
                if (reference instanceof Variable) {
                    CharSequence variableName3 = ((Variable)reference).getNameCS();
                    if (!StringUtil.isEmpty((CharSequence)variableName3)) {
                        this.addInstruction(new PhpAccessFieldByVariableInstructionImpl(fieldName, variableName3, fieldReference, access));
                    }
                } else if (reference instanceof ClassReference && PhpLangUtil.isSelfReference((ClassReference)reference)) {
                    this.addInstruction(new PhpAccessFieldInObjectContextInstructionImpl(fieldName, fieldReference, access));
                }
            }
        } else if (this.myCurrentValue instanceof ArrayAccessExpression && (value = (accessExpression = (ArrayAccessExpression)this.myCurrentValue).getValue()) instanceof Variable && !StringUtil.isEmpty((CharSequence)(variableName = ((Variable)value).getNameCS())) && (arrayIndex = accessExpression.getIndex()) != null && !StringUtil.isEmpty((CharSequence)(key = PhpCodeInsightUtil.getKey(arrayIndex)))) {
            this.addInstruction(new PhpArrayAccessInstructionImpl(variableName, key, (PhpPsiElement)accessExpression, access));
        }
        this.myCurrentValue = null;
        this.myCurrentValueIsExpressionResult = true;
        this.myCurrentValuePostAccess = null;
    }

    private void resetCurrentValueWeak(@NotNull PhpAccessInstruction.Access access) {
        if (access == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(10);
        }
        this.resetCurrentValue(this.myParentAccess == null ? access : this.myParentAccess, true);
    }

    private void resetCurrentValue(@NotNull PhpAccessInstruction.Access access) {
        if (access == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(11);
        }
        this.resetCurrentValue(access, true);
    }

    private void resetCurrentValueAfterStatement() {
        this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS, false);
    }

    private void setCurrentValue(@Nullable PhpPsiElement currentValue, boolean isExpressionResult) {
        this.myCurrentValue = currentValue;
        this.myCurrentValueIsExpressionResult = isExpressionResult;
    }

    private void processFollowingDocComment(@Nullable PsiElement value) {
        PhpDocComment docComment;
        if (value != null && (docComment = (PhpDocComment)PhpPsiUtil.findNextSiblingOfAnyType(value, new IElementType[]{PhpDocElementTypes.DOC_COMMENT})) != null) {
            docComment.accept((PsiElementVisitor)this);
        }
    }

    @Nullable
    private BreakContinueTarget getBreakContinueTarget(@Nullable PsiElement argument) {
        while (argument instanceof ParenthesizedExpression) {
            argument = ((ParenthesizedExpression)argument).getArgument();
        }
        if (argument != null) {
            Integer arg = PhpCodeInsightUtil.toInt(argument);
            if (arg == null) {
                return this.getBreakContinueTarget(1);
            }
            return this.getBreakContinueTarget(arg);
        }
        return this.getBreakContinueTarget(1);
    }

    @Nullable
    private BreakContinueTarget getBreakContinueTarget(int number) {
        if (number < 1) {
            number = 1;
        }
        if (number > this.myBreakContinueTargetList.size()) {
            return null;
        }
        return this.myBreakContinueTargetList.get(this.myBreakContinueTargetList.size() - number);
    }

    @NotNull
    private Map<String, PhpGotoLabelDefinitionInstructionImpl> getLabelToDefinitionInstructionMap() {
        if (this.myLabelToDefinitionInstruction == null) {
            this.myLabelToDefinitionInstruction = new THashMap();
        }
        Map<String, PhpGotoLabelDefinitionInstructionImpl> map = this.myLabelToDefinitionInstruction;
        if (map == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(12);
        }
        return map;
    }

    @NotNull
    private MultiMap<String, PhpMarkerInstruction> getLabelToGotoInstructionMap() {
        if (this.myLabelToGotoInstruction == null) {
            this.myLabelToGotoInstruction = new MultiMap();
        }
        MultiMap<String, PhpMarkerInstruction> multiMap = this.myLabelToGotoInstruction;
        if (multiMap == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(13);
        }
        return multiMap;
    }

    public void visitPhpClass(PhpClass clazz) {
        this.addInstruction(PhpControlFlowBuilder.createClassDeclarationInstruction(clazz));
    }

    public void visitPhpNamespace(PhpNamespace namespace) {
    }

    public void visitPhpFunction(Function function) {
        if (function.isClosure()) {
            Collection<Variable> variables = PhpPsiUtil.getUsedVariables(function);
            for (Variable variable : variables) {
                if (variable == null) continue;
                variable.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpWorkaroundUtil.isReadReference((PsiElement)variable) ? PhpAccessInstruction.Access.READ_REF_ACCESS : PhpAccessInstruction.Access.READ_ACCESS);
            }
        } else {
            this.addInstruction(PhpControlFlowBuilder.createFunctionDeclarationInstruction(function));
        }
    }

    public void visitPhpUseList(PhpUseList useList) {
    }

    public void visitPhpConstant(Constant constant) {
        if (constant instanceof PhpDefine) {
            constant.acceptChildren((PsiElementVisitor)this);
        } else {
            PsiElement value = constant.getValue();
            if (value != null) {
                value.accept((PsiElementVisitor)this);
            }
        }
        this.addInstruction(new PhpConstantDeclarationInstructionImpl(constant));
    }

    public void visitPhpExit(PhpExit exitExpression) {
        PhpPsiElement argument = exitExpression.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.interrupt();
    }

    public void visitPhpInclude(Include include) {
        PhpPsiElement argument = include.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.addInstruction(new PhpIncludeInstructionImpl());
    }

    public void visitPhpIsset(PhpIsset issetExpression) {
        for (PhpExpression variable : issetExpression.getVariables()) {
            if (variable == null) continue;
            this.myParentAccess = PhpAccessInstruction.Access.ISSET_ACCESS;
            variable.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.ISSET_ACCESS);
            this.myParentAccess = null;
        }
    }

    public void visitPhpEmpty(PhpEmpty emptyExpression) {
        for (PhpExpression variable : emptyExpression.getVariables()) {
            if (variable == null) continue;
            variable.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.LIGHT_READ_ACCESS);
        }
    }

    public void visitPhpPrint(PhpPrintExpression printExpression) {
        PhpPsiElement argument = printExpression.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
    }

    public void visitPhpParenthesizedExpression(ParenthesizedExpression expression) {
        PhpPsiElement argument = expression.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.setCurrentValue(argument, true);
    }

    public void visitPhpUnaryExpression(UnaryExpression expr) {
        PhpPsiElement value = expr.getValue();
        if (value != null) {
            value.accept((PsiElementVisitor)this);
            IElementType expressionType = expr.getNode().getElementType();
            if (expressionType == PhpElementTypes.POSTFIX_EXPRESSION) {
                value.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpAccessInstruction.Access.WRITE_ACCESS);
                return;
            }
            if (expressionType == PhpElementTypes.INFIX_WRITE_EXPRESSION) {
                this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
                value.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpAccessInstruction.Access.WRITE_ACCESS);
            } else {
                this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
            }
        }
        this.setCurrentValue(value, true);
    }

    public void visitPhpBinaryExpression(BinaryExpression expression) {
        IElementType type = expression.getOperationType();
        if (PhpLangUtil.isShortCircuitAndOperator(type)) {
            this.processShortCircuitExpression(expression, false);
        } else if (PhpLangUtil.isShortCircuitOrOperator(type)) {
            this.processShortCircuitExpression(expression, true);
        } else if (type == PhpTokenTypes.opCOALESCE) {
            PsiElement trueVariant = expression.getLeftOperand();
            PsiElement falseVariant = expression.getRightOperand();
            this.processTrueFalseExpression(trueVariant, PhpAccessInstruction.Access.ISSET_ACCESS, trueVariant, falseVariant);
        } else if (type != null) {
            PsiElement rightOperand;
            PsiElement leftOperand = expression.getLeftOperand();
            if (leftOperand != null) {
                leftOperand.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
            }
            if ((rightOperand = expression.getRightOperand()) != null) {
                rightOperand.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
            }
        }
    }

    public void processShortCircuitExpression(@NotNull BinaryExpression expression, boolean trueBranchFirst) {
        Stack<PhpConditionInstructionImpl> firstBranch;
        if (expression == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(14);
        }
        PhpMarkerInstruction binaryOut = new PhpMarkerInstruction();
        PsiElement leftOperand = expression.getLeftOperand();
        PhpHostInstructionImpl conditionHost = PhpControlFlowBuilder.createHostInstruction();
        PhpConditionInstructionImpl trueConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction(leftOperand);
        PhpConditionInstructionImpl falseConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction(leftOperand);
        this.pushConditionTargets(trueConditionInstruction, falseConditionInstruction);
        if (leftOperand != null) {
            leftOperand.accept((PsiElementVisitor)this);
        }
        this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        this.popConditionTargets();
        this.addInstruction(conditionHost);
        this.addInstruction(trueBranchFirst ? trueConditionInstruction : falseConditionInstruction);
        Stack<PhpConditionInstructionImpl> stack = firstBranch = trueBranchFirst ? this.myTrueTargets : this.myFalseTargets;
        if (firstBranch.empty()) {
            this.jump(binaryOut);
        } else {
            this.jump((PhpInstructionImpl)firstBranch.peek());
        }
        this.lastInstruction = conditionHost;
        this.addInstruction(trueBranchFirst ? falseConditionInstruction : trueConditionInstruction);
        PsiElement rightOperand = expression.getRightOperand();
        if (rightOperand != null) {
            rightOperand.accept((PsiElementVisitor)this);
        }
        this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        this.addInstruction(binaryOut);
    }

    public void visitPhpTernaryExpression(TernaryExpression expression) {
        PhpPsiElement condition = expression.getCondition();
        PhpPsiElement trueVariant = expression.getTrueVariant();
        PhpPsiElement falseVariant = expression.getFalseVariant();
        this.processTrueFalseExpression((PsiElement)condition, PhpAccessInstruction.Access.READ_ACCESS, (PsiElement)trueVariant, (PsiElement)falseVariant);
    }

    public void processTrueFalseExpression(@Nullable PsiElement condition, @NotNull PhpAccessInstruction.Access conditionAccess, @Nullable PsiElement trueVariant, @Nullable PsiElement falseVariant) {
        if (conditionAccess == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(15);
        }
        PhpMarkerInstruction ternaryOut = new PhpMarkerInstruction();
        PhpHostInstructionImpl conditionHost = PhpControlFlowBuilder.createHostInstruction();
        PhpConditionInstructionImpl trueConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction(condition);
        PhpConditionInstructionImpl falseConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction(condition);
        this.pushConditionTargets(trueConditionInstruction, falseConditionInstruction);
        if (condition != null) {
            this.myParentAccess = conditionAccess;
            condition.accept((PsiElementVisitor)this);
            this.resetCurrentValue(conditionAccess);
            this.myParentAccess = null;
        }
        this.popConditionTargets();
        this.addInstruction(conditionHost);
        this.addInstruction(trueConditionInstruction);
        if (trueVariant != null) {
            trueVariant.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.jump(ternaryOut);
        this.lastInstruction = conditionHost;
        this.addInstruction(falseConditionInstruction);
        if (falseVariant != null) {
            falseVariant.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.addInstruction(ternaryOut);
    }

    public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
        PsiElement[] children;
        for (PsiElement child : children = expression.getChildren()) {
            IElementType childType = child.getNode().getElementType();
            if (PhpElementTypes.HASH_ARRAY_ELEMENT == childType) {
                PsiElement value;
                PsiElement key = PhpPsiUtil.getChildOfType(child, PhpElementTypes.ARRAY_KEY);
                if (key != null) {
                    key.accept((PsiElementVisitor)this);
                    this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
                }
                if ((value = PhpPsiUtil.getChildOfType(child, PhpElementTypes.ARRAY_VALUE)) == null) continue;
                value.accept((PsiElementVisitor)this);
                this.resetCurrentValueWeak(PhpAccessInstruction.Access.READ_ACCESS);
                continue;
            }
            if (PhpElementTypes.ARRAY_VALUE != childType) continue;
            child.accept((PsiElementVisitor)this);
            this.resetCurrentValueWeak(PhpAccessInstruction.Access.READ_ACCESS);
        }
    }

    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
        ArrayIndex arrayIndex;
        PhpPsiElement value = expression.getValue();
        if (value != null) {
            value.accept((PsiElementVisitor)this);
            this.resetCurrentValueWeak(PhpAccessInstruction.Access.READ_ACCESS);
        }
        if ((arrayIndex = expression.getIndex()) != null) {
            arrayIndex.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.setCurrentValue((PhpPsiElement)expression, false);
    }

    public void visitPhpFieldReference(FieldReference fieldReference) {
        PhpExpression classReference = fieldReference.getClassReference();
        if (classReference != null) {
            for (PhpPsiElement nextPsiSibling = classReference.getNextPsiSibling(); nextPsiSibling != null; nextPsiSibling = nextPsiSibling.getNextPsiSibling()) {
                nextPsiSibling.accept((PsiElementVisitor)this);
            }
            classReference.accept((PsiElementVisitor)this);
            PhpAccessInstruction.Access access = this.myParentAccess == null || this.myParentAccess.isWrite() || this.myParentAccess.isWriteRef() ? PhpAccessInstruction.Access.READ_ACCESS : this.myParentAccess;
            this.resetCurrentValue(access);
        }
        this.setCurrentValue((PhpPsiElement)fieldReference, false);
    }

    public void visitPhpMethodReference(MethodReference reference) {
        ParameterList parameterList = reference.getParameterList();
        PhpExpression classReference = reference.getClassReference();
        if (classReference != null) {
            PhpPsiElement nextPsiSibling = classReference.getNextPsiSibling();
            if (nextPsiSibling != null && nextPsiSibling != parameterList) {
                nextPsiSibling.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
            }
            classReference.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        if (parameterList != null) {
            parameterList.accept((PsiElementVisitor)this);
        }
        this.processCall((FunctionReference)reference);
    }

    public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
        PhpExpression classReference = constantReference.getClassReference();
        if (classReference != null) {
            classReference.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
    }

    public void visitPhpStatement(Statement statement) {
        this.addStatementInstruction(statement);
        super.visitPhpStatement(statement);
        this.resetCurrentValueAfterStatement();
    }

    public void visitPhpIf(If ifStatement) {
        PhpPsiElement elseStatement;
        ElseIf[] elseIfBranches;
        this.addStatementInstruction((Statement)ifStatement);
        PhpMarkerInstruction ifOutInstruction = new PhpMarkerInstruction();
        PhpPsiElement condition = ifStatement.getCondition();
        ElseIf[] ifConditionHost = PhpControlFlowBuilder.createHostInstruction();
        PhpConditionInstructionImpl trueIfConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction((PsiElement)condition);
        PhpConditionInstructionImpl falseIfConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction((PsiElement)condition);
        this.pushConditionTargets(trueIfConditionInstruction, falseIfConditionInstruction);
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.popConditionTargets();
        this.addInstruction((PhpInstructionImpl)ifConditionHost);
        this.addInstruction(trueIfConditionInstruction);
        Statement thenStatement = ifStatement.getStatement();
        if (thenStatement != null) {
            thenStatement.accept((PsiElementVisitor)this);
        }
        this.jump(ifOutInstruction);
        this.lastInstruction = ifConditionHost;
        this.addInstruction(falseIfConditionInstruction);
        for (ElseIf elseIfBranch : elseIfBranches = ifStatement.getElseIfBranches()) {
            PhpPsiElement elseIfCondition = elseIfBranch.getCondition();
            PhpHostInstructionImpl elseIfConditionHost = PhpControlFlowBuilder.createHostInstruction();
            PhpConditionInstructionImpl trueElseIfConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction((PsiElement)elseIfCondition);
            PhpConditionInstructionImpl falseElseIfConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction((PsiElement)elseIfCondition);
            this.pushConditionTargets(trueElseIfConditionInstruction, falseElseIfConditionInstruction);
            if (elseIfCondition != null) {
                elseIfCondition.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
            }
            this.popConditionTargets();
            this.addInstruction(elseIfConditionHost);
            this.addInstruction(trueElseIfConditionInstruction);
            Statement elseIfThenStatement = elseIfBranch.getStatement();
            if (elseIfThenStatement != null) {
                elseIfThenStatement.accept((PsiElementVisitor)this);
            }
            this.jump(ifOutInstruction);
            this.lastInstruction = elseIfConditionHost;
            this.addInstruction(falseElseIfConditionInstruction);
        }
        Else elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null && (elseStatement = elseBranch.getStatement()) != null) {
            elseStatement.accept((PsiElementVisitor)this);
        }
        this.addInstruction(ifOutInstruction);
    }

    public void visitPhpFor(For forStatement) {
        PhpPsiElement[] repeatedExpressions;
        PhpConditionInstructionImpl falseConditionInstruction;
        PhpConditionInstructionImpl trueConditionInstruction;
        PhpPsiElement[] initialExpressions;
        this.addStatementInstruction((Statement)forStatement);
        PhpMarkerInstruction loopBeginInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction loopEndInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction continueTargetInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction forOutInstruction = new PhpMarkerInstruction();
        this.pushBreakContinueTargets((Statement)forStatement, forOutInstruction, continueTargetInstruction);
        for (PhpPsiElement initialExpression : initialExpressions = forStatement.getInitialExpressions()) {
            initialExpression.accept((PsiElementVisitor)this);
            this.resetCurrentValueAfterStatement();
        }
        this.addInstruction(loopBeginInstruction);
        PhpPsiElement[] conditionalExpressions = forStatement.getConditionalExpressions();
        PhpHostInstructionImpl conditionHost = PhpControlFlowBuilder.createHostInstruction();
        if (conditionalExpressions.length > 0) {
            PhpPsiElement[] condition = conditionalExpressions[conditionalExpressions.length - 1];
            trueConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction((PsiElement)condition);
            falseConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction((PsiElement)condition);
        } else {
            trueConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction(null);
            falseConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction(null);
        }
        this.pushConditionTargets(trueConditionInstruction, falseConditionInstruction);
        for (PhpPsiElement conditionalExpression : conditionalExpressions) {
            conditionalExpression.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.popConditionTargets();
        this.addInstruction(conditionHost);
        this.addInstruction(trueConditionInstruction);
        Statement loopBody = forStatement.getStatement();
        if (loopBody != null) {
            loopBody.accept((PsiElementVisitor)this);
        }
        this.addInstruction(continueTargetInstruction);
        for (PhpPsiElement repeatedExpression : repeatedExpressions = forStatement.getRepeatedExpressions()) {
            repeatedExpression.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.addInstruction(loopEndInstruction);
        this.jump(loopBeginInstruction);
        this.lastInstruction = conditionHost;
        this.addInstruction(falseConditionInstruction);
        this.addInstruction(forOutInstruction);
        this.popBreakContinueTargets();
    }

    public void visitPhpWhile(While whileStatement) {
        this.addStatementInstruction((Statement)whileStatement);
        PhpMarkerInstruction loopBeginInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction loopEndInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction whileOutInstruction = new PhpMarkerInstruction();
        this.pushBreakContinueTargets((Statement)whileStatement, whileOutInstruction, loopBeginInstruction);
        this.addInstruction(loopBeginInstruction);
        PhpPsiElement condition = whileStatement.getCondition();
        PhpHostInstructionImpl conditionHost = PhpControlFlowBuilder.createHostInstruction();
        PhpConditionInstructionImpl trueConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction((PsiElement)condition);
        PhpConditionInstructionImpl falseConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction((PsiElement)condition);
        this.pushConditionTargets(trueConditionInstruction, falseConditionInstruction);
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.popConditionTargets();
        this.addInstruction(conditionHost);
        this.addInstruction(trueConditionInstruction);
        Statement whileBody = whileStatement.getStatement();
        if (whileBody != null) {
            whileBody.accept((PsiElementVisitor)this);
        }
        this.addInstruction(loopEndInstruction);
        this.jump(loopBeginInstruction);
        this.lastInstruction = conditionHost;
        this.addInstruction(falseConditionInstruction);
        this.addInstruction(whileOutInstruction);
        this.popBreakContinueTargets();
    }

    public void visitPhpDoWhile(DoWhile doWhileStatement) {
        this.addStatementInstruction((Statement)doWhileStatement);
        PhpMarkerInstruction loopBeginInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction doWhileOutInstruction = new PhpMarkerInstruction();
        this.pushBreakContinueTargets((Statement)doWhileStatement, doWhileOutInstruction, loopBeginInstruction);
        this.addInstruction(loopBeginInstruction);
        Statement doWhileBody = doWhileStatement.getStatement();
        if (doWhileBody != null) {
            doWhileBody.accept((PsiElementVisitor)this);
        }
        PhpPsiElement condition = doWhileStatement.getCondition();
        PhpHostInstructionImpl conditionHost = PhpControlFlowBuilder.createHostInstruction();
        PhpConditionInstructionImpl trueConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction((PsiElement)condition);
        PhpConditionInstructionImpl falseConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction((PsiElement)condition);
        this.pushConditionTargets(trueConditionInstruction, falseConditionInstruction);
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.popConditionTargets();
        this.addInstruction(conditionHost);
        this.addInstruction(trueConditionInstruction);
        this.jump(loopBeginInstruction);
        this.lastInstruction = conditionHost;
        this.addInstruction(falseConditionInstruction);
        this.addInstruction(doWhileOutInstruction);
        this.popBreakContinueTargets();
    }

    public void visitPhpForeach(ForeachStatement foreachStatement) {
        Statement loopBodyStatement;
        this.addStatementInstruction((Statement)foreachStatement);
        PhpMarkerInstruction loopBeginInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction loopEndInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction foreachOutInstruction = new PhpMarkerInstruction();
        this.pushBreakContinueTargets((Statement)foreachStatement, foreachOutInstruction, loopBeginInstruction);
        PhpPsiElement array = PhpWorkaroundUtil.getForeachArray(foreachStatement);
        if (array != null) {
            array.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.addInstruction(loopBeginInstruction);
        PhpHostInstructionImpl foreachHost = PhpControlFlowBuilder.createHostInstruction();
        this.addInstruction(foreachHost);
        this.jump(foreachOutInstruction);
        this.lastInstruction = foreachHost;
        List<PhpReference> keys = PhpPsiUtil.getChildren((PsiElement)foreachStatement, (Condition<? super PsiElement>)PhpReference.INSTANCEOF);
        for (PhpReference key : keys) {
            if (key == array) continue;
            key.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpControlFlowBuilder.getForeachKeyValueAccessTypeByPrevSibling(key));
        }
        if (!keys.isEmpty()) {
            this.processFollowingDocComment((PsiElement)keys.get(keys.size() - 1));
        }
        if ((loopBodyStatement = foreachStatement.getStatement()) != null) {
            loopBodyStatement.accept((PsiElementVisitor)this);
        }
        this.addInstruction(loopEndInstruction);
        PhpHostInstructionImpl foreachHostEnd = PhpControlFlowBuilder.createHostInstruction();
        this.addInstruction(foreachHostEnd);
        this.jump(loopBeginInstruction);
        this.lastInstruction = foreachHostEnd;
        this.addInstruction(foreachOutInstruction);
        this.popBreakContinueTargets();
    }

    private static PhpAccessInstruction.Access getForeachKeyValueAccessTypeByPrevSibling(@NotNull PhpReference key) {
        if (key == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(16);
        }
        if (PhpCodeInsightUtil.isForeachKeyOrValueAssignedByReference(key)) {
            return PhpAccessInstruction.Access.WRITE_REF_ACCESS;
        }
        return PhpAccessInstruction.Access.WRITE_ACCESS;
    }

    public void visitPhpSwitch(PhpSwitch switchStatement) {
        int i;
        this.addStatementInstruction((Statement)switchStatement);
        PhpMarkerInstruction switchOutInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction defaultStatementBegin = null;
        this.pushBreakContinueTargets((Statement)switchStatement, switchOutInstruction, switchOutInstruction);
        PsiElement switchArgument = switchStatement.getArgument();
        if (switchArgument != null) {
            switchArgument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        PhpCase[] allCases = switchStatement.getAllCases();
        PhpCase defaultCase = switchStatement.getDefaultCase();
        PhpMarkerInstruction[] caseStatementBegins = new PhpMarkerInstruction[allCases.length];
        for (i = 0; i < allCases.length; ++i) {
            if (allCases[i] == defaultCase) {
                caseStatementBegins[i] = defaultStatementBegin = new PhpMarkerInstruction();
                continue;
            }
            PsiElement caseArgument = allCases[i].getArgument();
            if (caseArgument != null) {
                caseArgument.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
            }
            caseStatementBegins[i] = new PhpMarkerInstruction();
            PhpHostInstructionImpl caseHost = PhpControlFlowBuilder.createHostInstruction();
            this.addInstruction(caseHost);
            PhpCaseConditionInstructionImpl lastCaseConditionInstruction = new PhpCaseConditionInstructionImpl(caseArgument, switchArgument, caseStatementBegins[i]);
            this.addInstruction(lastCaseConditionInstruction);
            this.lastInstruction = caseHost;
            PhpBaseCaseConditionInstructionImpl falseInstruction = new PhpBaseCaseConditionInstructionImpl(caseArgument, switchArgument, false);
            this.addInstruction(falseInstruction);
        }
        this.jump(defaultStatementBegin != null ? defaultStatementBegin : switchOutInstruction);
        for (i = 0; i < allCases.length; ++i) {
            this.addInstruction(caseStatementBegins[i]);
            this.processFollowingDocComment(allCases[i].getArgument());
            Statement caseStatement = allCases[i].getStatement();
            if (caseStatement == null) continue;
            caseStatement.accept((PsiElementVisitor)this);
        }
        this.addInstruction(switchOutInstruction);
        this.popBreakContinueTargets();
    }

    public void visitPhpReturn(PhpReturn returnStatement) {
        this.addStatementInstruction((Statement)returnStatement);
        PsiElement argument = returnStatement.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.addInstruction(new PhpExitMarkerInstruction());
        PhpReturnInstructionImpl returnInstruction = new PhpReturnInstructionImpl(argument);
        if (!this.myFinallyBlocks.isEmpty()) {
            PhpFinallyInstructionsBlock lastFinally = (PhpFinallyInstructionsBlock)this.myFinallyBlocks.get(0);
            lastFinally.addSuccessor(returnInstruction);
            PhpFinallyInstructionsBlock topFinally = (PhpFinallyInstructionsBlock)this.myFinallyBlocks.get(this.myFinallyBlocks.size() - 1);
            this.jump(topFinally.getFirstInstruction());
        }
        this.addInstruction(returnInstruction);
        this.jump(this.myExitInstruction);
    }

    public void visitPhpBreak(PhpBreak breakStatement) {
        this.addStatementInstruction((Statement)breakStatement);
        PsiElement argument = breakStatement.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        BreakContinueTarget breakContinueTarget = this.getBreakContinueTarget(argument);
        PhpBreakContinueInstructionImpl breakContinueInstruction = PhpControlFlowBuilder.createBreakContinueInstruction(breakContinueTarget);
        this.addInstruction(breakContinueInstruction);
        if (breakContinueTarget != null) {
            this.processBreakContinueWithFinally(breakContinueTarget, breakContinueTarget.getBreakTarget());
        }
    }

    public void visitPhpContinue(PhpContinue continueStatement) {
        this.addStatementInstruction((Statement)continueStatement);
        PsiElement argument = continueStatement.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        BreakContinueTarget breakContinueTarget = this.getBreakContinueTarget(argument);
        PhpBreakContinueInstructionImpl breakContinueInstruction = PhpControlFlowBuilder.createBreakContinueInstruction(breakContinueTarget);
        this.addInstruction(breakContinueInstruction);
        if (breakContinueTarget != null) {
            this.processBreakContinueWithFinally(breakContinueTarget, breakContinueTarget.getContinueTarget());
        }
    }

    private void processBreakContinueWithFinally(@NotNull BreakContinueTarget breakContinueTarget, @NotNull PhpInstructionImpl nextInstruction) {
        int loopStartOffset;
        int tryStartOffset;
        PhpFinallyInstructionsBlock topFinallyBlock;
        if (breakContinueTarget == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(17);
        }
        if (nextInstruction == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(18);
        }
        if ((topFinallyBlock = this.getTopFinallyBlock()) != null && (tryStartOffset = topFinallyBlock.getTryStartOffset()) > (loopStartOffset = breakContinueTarget.getStatement().getTextRange().getStartOffset())) {
            topFinallyBlock.addSuccessor(nextInstruction);
            this.jump(topFinallyBlock.getFirstInstruction());
            return;
        }
        this.jump(nextInstruction);
    }

    public void visitPhpGoto(PhpGoto gotoStatement) {
        String label = gotoStatement.getName();
        this.addStatementInstruction((Statement)gotoStatement);
        Map<String, PhpGotoLabelDefinitionInstructionImpl> labelToDefinitionInstruction = this.getLabelToDefinitionInstructionMap();
        PhpGotoLabelDefinitionInstructionImpl labelInstruction = labelToDefinitionInstruction.get(label);
        if (labelInstruction == null) {
            PhpMarkerInstruction marker = new PhpMarkerInstruction();
            MultiMap<String, PhpMarkerInstruction> labelToGotoInstruction = this.getLabelToGotoInstructionMap();
            labelToGotoInstruction.putValue((Object)label, (Object)marker);
            this.addInstruction(marker);
            this.interruptFlow();
        } else {
            this.jump(labelInstruction);
        }
    }

    public void visitPhpGotoLabel(PhpGotoLabel gotoLabel) {
        String label = gotoLabel.getName();
        PhpGotoLabelDefinitionInstructionImpl labelInstruction = new PhpGotoLabelDefinitionInstructionImpl(gotoLabel);
        Map<String, PhpGotoLabelDefinitionInstructionImpl> labelToDefinitionInstruction = this.getLabelToDefinitionInstructionMap();
        labelToDefinitionInstruction.put(label, labelInstruction);
        this.addInstruction(labelInstruction);
        MultiMap<String, PhpMarkerInstruction> labelToGotoInstruction = this.getLabelToGotoInstructionMap();
        Collection gotoInstructions = labelToGotoInstruction.get((Object)label);
        for (PhpMarkerInstruction instruction : gotoInstructions) {
            instruction.join(labelInstruction);
        }
    }

    public void visitPhpUnset(PhpUnset unsetStatement) {
        PhpPsiElement[] arguments;
        this.addStatementInstruction((Statement)unsetStatement);
        for (PhpPsiElement argument : arguments = unsetStatement.getArguments()) {
            if (argument == null) continue;
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.UNSET_ACCESS);
        }
    }

    public void visitPhpGlobal(Global globalStatement) {
        this.addStatementInstruction((Statement)globalStatement);
        for (Variable variable : globalStatement.getVariables()) {
            if (variable == null) continue;
            variable.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.WRITE_REF_ACCESS);
        }
    }

    public void visitPhpStaticStatement(PhpStaticStatement staticStatement) {
        this.addStatementInstruction((Statement)staticStatement);
        for (AssignmentExpression declaration : staticStatement.getDeclarations()) {
            PhpPsiElement variable = declaration.getVariable();
            if (variable == null) continue;
            variable.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.WRITE_ACCESS);
        }
    }

    public void visitPhpEchoStatement(PhpEchoStatement echoStatement) {
        this.addStatementInstruction((Statement)echoStatement);
        for (PhpPsiElement argument : echoStatement.getArguments()) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
    }

    public void visitPhpThrow(PhpThrow throwStatement) {
        this.addStatementInstruction((Statement)throwStatement);
        PsiElement argument = throwStatement.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.addInstruction(new PhpExitMarkerInstruction());
        PhpThrowInstructionImpl throwInstruction = new PhpThrowInstructionImpl(throwStatement, argument, new ArrayList<PhpHostInstruction>(this.myCatchMatchingList));
        if (!this.myFinallyBlocks.isEmpty()) {
            PhpFinallyInstructionsBlock topFinally = (PhpFinallyInstructionsBlock)this.myFinallyBlocks.get(this.myFinallyBlocks.size() - 1);
            if (PhpPsiUtil.getParentByCondition((PsiElement)throwStatement, (Condition<? super PsiElement>)Catch.INSTANCEOF) != null || !topFinally.haveCatchClauses()) {
                this.jump(topFinally.getFirstInstruction());
                PhpFinallyInstructionsBlock lastFinally = (PhpFinallyInstructionsBlock)this.myFinallyBlocks.get(0);
                lastFinally.addSuccessor(throwInstruction);
            }
        }
        this.addInstruction(throwInstruction);
        this.jump(this.myExitInstruction);
    }

    public void visitPhpTry(Try tryStatement2) {
        int i;
        Catch[] catches = tryStatement2.getCatchClauses();
        Finally finallyBlock = tryStatement2.getFinallyBlock();
        int startOffset = tryStatement2.getTextRange().getStartOffset();
        PhpFinallyInstructionsBlock finallyInstructions = PhpFinallyInstructionsBlock.createFinallyInstructionsBlock(finallyBlock, catches.length > 0, startOffset);
        this.addNextFinallyBlock(finallyInstructions);
        PhpMarkerInstruction tryInstructionOut = finallyInstructions == null ? new PhpMarkerInstruction() : finallyInstructions.getFirstInstruction();
        PhpHostInstructionImpl[] catchConditionHosts = new PhpHostInstructionImpl[catches.length];
        for (int i2 = 0; i2 < catches.length; ++i2) {
            catchConditionHosts[i2] = PhpControlFlowBuilder.createHostInstruction();
            this.myCatchMatchingList.add(catchConditionHosts[i2]);
        }
        PhpTryInstructionImpl tryInstruction = new PhpTryInstructionImpl((Statement)tryStatement2);
        this.addInstruction(tryInstruction);
        Statement tryBody = tryStatement2.getStatement();
        if (tryBody != null) {
            tryBody.accept((PsiElementVisitor)this);
        }
        if (!this.myCatchMatchingList.isEmpty() && this.myCatchMatchingList.get(0).getPredecessors().isEmpty()) {
            tryInstruction.addCatchTargets(this.myCatchMatchingList);
        }
        this.jump(tryInstructionOut);
        for (i = 0; i < catches.length; ++i) {
            this.myCatchMatchingList.remove(this.myCatchMatchingList.size() - 1);
        }
        for (i = 0; i < catches.length; ++i) {
            PhpHostInstructionImpl conditionHost = catchConditionHosts[i];
            Catch aCatch = catches[i];
            Variable exceptionVariable = aCatch.getException();
            Collection exceptionTypes = aCatch.getExceptionTypes();
            PhpCatchConditionInstructionImpl trueCatchConditionInstruction = PhpControlFlowBuilder.createTrueCatchConditionInstruction(exceptionTypes, exceptionVariable);
            PhpCatchConditionInstructionImpl falseCatchConditionInstruction = PhpControlFlowBuilder.createFalseCatchConditionInstruction(exceptionTypes, exceptionVariable);
            this.addInstruction(conditionHost);
            this.addInstruction(trueCatchConditionInstruction);
            catches[i].accept((PsiElementVisitor)this);
            this.jump(tryInstructionOut);
            this.lastInstruction = conditionHost;
            this.addInstruction(falseCatchConditionInstruction);
        }
        if (finallyInstructions == null) {
            if (catches.length > 0) {
                this.jump(this.myExitInstruction);
            }
            this.addInstruction(tryInstructionOut);
        } else {
            this.removeTopFinallyBlock();
            this.addInstruction(tryInstructionOut);
            assert (finallyBlock != null);
            finallyBlock.accept((PsiElementVisitor)this);
            this.addInstruction(finallyInstructions.getLastInstruction());
            Collection<PhpInstruction> finallyBlockPredecessors = tryInstructionOut.getPredecessors();
            if (!finallyBlockPredecessors.isEmpty() && PhpControlFlowBuilder.exitPointWasReached(finallyBlockPredecessors)) {
                this.interruptFlow();
            }
        }
    }

    private static boolean exitPointWasReached(@NotNull Collection<PhpInstruction> instructions) {
        if (instructions == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(19);
        }
        for (PhpInstruction instruction : instructions) {
            if (instruction instanceof PhpCatchConditionInstruction) {
                return !((PhpCatchConditionInstruction)instruction).getResult();
            }
            if (instruction instanceof PhpExitMarkerInstruction) continue;
            return false;
        }
        return true;
    }

    private void addNextFinallyBlock(@Nullable PhpFinallyInstructionsBlock finallyBlock) {
        if (finallyBlock != null) {
            if (!this.myFinallyBlocks.isEmpty()) {
                PhpFinallyInstructionsBlock previousFinally = (PhpFinallyInstructionsBlock)this.myFinallyBlocks.get(this.myFinallyBlocks.size() - 1);
                finallyBlock.addSuccessor(previousFinally.getFirstInstruction());
                if (previousFinally.haveCatchClauses()) {
                    finallyBlock.setHaveCatchClauses(true);
                }
            }
            this.myFinallyBlocks.add((Object)finallyBlock);
        }
    }

    @Nullable
    private PhpFinallyInstructionsBlock getTopFinallyBlock() {
        if (!this.myFinallyBlocks.isEmpty()) {
            return (PhpFinallyInstructionsBlock)this.myFinallyBlocks.get(this.myFinallyBlocks.size() - 1);
        }
        return null;
    }

    private void removeTopFinallyBlock() {
        if (!this.myFinallyBlocks.isEmpty()) {
            this.myFinallyBlocks.remove(this.myFinallyBlocks.size() - 1);
        }
    }

    public void visitPhpCatch(Catch phpCatch) {
        Statement statement;
        Variable exceptionVariable = phpCatch.getException();
        if (exceptionVariable != null) {
            exceptionVariable.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.WRITE_ACCESS);
        }
        if ((statement = phpCatch.getStatement()) != null) {
            statement.accept((PsiElementVisitor)this);
        }
    }

    public void visitPhpVariable(Variable variable) {
        super.visitPhpVariable(variable);
        this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        this.setCurrentValue((PhpPsiElement)variable, false);
    }

    public void visitPhpDocVariable(PhpDocVariable phpDocVariable) {
        CharSequence variableName;
        super.visitPhpDocVariable(phpDocVariable);
        PhpDocTag tag = (PhpDocTag)PhpPsiUtil.getParentByCondition((PsiElement)phpDocVariable, (Condition<? super PsiElement>)PhpDocTag.INSTANCEOF);
        if (tag != null && PhpDocUtil.isDocVarType(tag.getName()) && !StringUtil.isEmpty((CharSequence)(variableName = phpDocVariable.getNameCS()))) {
            this.addInstruction(new PhpVariableDocDeclarationInstructionImpl(variableName, phpDocVariable));
        }
    }

    public void visitPhpConstantReference(ConstantReference reference) {
        super.visitPhpConstantReference(reference);
        this.setCurrentValue((PhpPsiElement)reference, false);
    }

    public void visitPhpFunctionCall(FunctionReference reference) {
        String functionName;
        ParameterList parameterList;
        PhpPsiElement firstPsiChild = reference.getFirstPsiChild();
        if (firstPsiChild instanceof Variable || firstPsiChild instanceof ArrayAccessExpression) {
            firstPsiChild.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        if (firstPsiChild instanceof ParenthesizedExpression || firstPsiChild instanceof FunctionReference) {
            firstPsiChild.accept((PsiElementVisitor)this);
        }
        if ((parameterList = reference.getParameterList()) != null) {
            parameterList.accept((PsiElementVisitor)this);
        }
        if ((functionName = reference.getName()) != null) {
            PsiElement[] params;
            if (PhpLangUtil.equalsFunctionNames(COMPACT_FUNCTION, functionName)) {
                if (parameterList != null) {
                    for (PsiElement parameter : parameterList.getParameters()) {
                        String varName;
                        if (!(parameter instanceof PhpPsiElement) || StringUtil.isEmpty((CharSequence)(varName = PhpCodeInsightUtil.toString(parameter)))) continue;
                        PhpAccessInstruction.Access access = PhpAccessInstruction.Access.LIGHT_READ_ACCESS;
                        this.addInstruction(new PhpAccessVariableInstructionImpl((PhpPsiElement)parameter, varName, access));
                    }
                }
            } else if (PhpLangUtil.equalsFunctionNames(ASSERT_FUNCTION, functionName) && parameterList != null && (params = parameterList.getParameters()).length > 0) {
                PhpHostInstructionImpl ifConditionHost = PhpControlFlowBuilder.createHostInstruction();
                this.addInstruction(ifConditionHost);
                this.addInstruction(PhpControlFlowBuilder.createFalseConditionInstruction(params[0]));
                this.interrupt();
                this.lastInstruction = ifConditionHost;
                this.addInstruction(PhpControlFlowBuilder.createTrueConditionInstruction(params[0]));
            }
        }
        this.processCall(reference);
    }

    private void processCall(@NotNull FunctionReference reference) {
        if (reference == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(20);
        }
        this.addInstruction(new PhpCallInstructionImpl(reference, this.getCatchMatchingListCopy()));
    }

    public void visitPhpNewExpression(NewExpression expression) {
        ParameterList parameterList;
        ClassReference classReference = expression.getClassReference();
        if (classReference != null) {
            classReference.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        if ((parameterList = expression.getParameterList()) != null) {
            parameterList.accept((PsiElementVisitor)this);
        }
        this.addInstruction(new PhpConstructorCallInstructionImpl(expression, this.getCatchMatchingListCopy()));
    }

    @NotNull
    private List<PhpHostInstruction> getCatchMatchingListCopy() {
        List list = this.myCatchMatchingList.size() > 1 ? ContainerUtil.newArrayList(this.myCatchMatchingList) : ContainerUtil.createMaybeSingletonList((Object)ContainerUtil.getFirstItem(this.myCatchMatchingList));
        if (list == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(21);
        }
        return list;
    }

    public void visitPhpAssignmentExpression(AssignmentExpression expr) {
        PhpPsiElement variable;
        boolean assignByReference = PhpWorkaroundUtil.isAssignByReference(expr);
        PhpPsiElement value = expr.getValue();
        if (value != null) {
            value.accept((PsiElementVisitor)this);
            this.resetCurrentValue(assignByReference ? PhpAccessInstruction.Access.READ_REF_ACCESS : PhpAccessInstruction.Access.READ_ACCESS);
        }
        if ((variable = expr.getVariable()) != null) {
            variable.accept((PsiElementVisitor)this);
            this.resetCurrentValue(assignByReference ? PhpAccessInstruction.Access.WRITE_REF_ACCESS : PhpAccessInstruction.Access.WRITE_ACCESS);
        }
        this.setCurrentValue(variable, true);
    }

    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
        PhpPsiElement variable;
        PhpPsiElement value = expression.getValue();
        if (value != null) {
            value.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        if ((variable = expression.getVariable()) != null) {
            variable.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
            variable.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.WRITE_ACCESS);
        }
    }

    public void visitPhpMultiassignmentExpression(MultiassignmentExpression multiassignmentExpression) {
        PhpPsiElement value = multiassignmentExpression.getValue();
        if (value != null) {
            value.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        List variables = multiassignmentExpression.getVariables();
        for (PhpPsiElement variable : variables) {
            this.myParentAccess = PhpAccessInstruction.Access.WRITE_ACCESS;
            variable.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.WRITE_ACCESS);
            this.myParentAccess = null;
        }
    }

    public void visitPhpParameterList(ParameterList list) {
        PsiElement[] parameters;
        for (PsiElement parameter : parameters = list.getParameters()) {
            parameter.accept((PsiElementVisitor)this);
            if (parameter instanceof Variable) {
                this.resetCurrentValue((PhpAccessInstruction.Access)new PhpAccessInstruction.ReadOrReadRefAccess((Variable)parameter));
                continue;
            }
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
    }

    private void interrupt() {
        this.addInstruction(PhpControlFlowBuilder.createInterruptScriptInstruction());
        this.jump(this.myExitInstruction);
    }

    private static PhpHostInstructionImpl createHostInstruction() {
        return new PhpHostInstructionImpl();
    }

    private static PhpConditionInstructionImpl createTrueConditionInstruction(@Nullable PsiElement condition) {
        return new PhpConditionInstructionImpl(condition, true);
    }

    private static PhpConditionInstructionImpl createFalseConditionInstruction(@Nullable PsiElement condition) {
        return new PhpConditionInstructionImpl(condition, false);
    }

    private static PhpCatchConditionInstructionImpl createTrueCatchConditionInstruction(@NotNull Collection<ClassReference> exceptionTypes, @Nullable Variable exception) {
        if (exceptionTypes == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(22);
        }
        return new PhpCatchConditionInstructionImpl(exceptionTypes, exception, true);
    }

    private static PhpCatchConditionInstructionImpl createFalseCatchConditionInstruction(@NotNull Collection<ClassReference> exceptionTypes, @Nullable Variable exception) {
        if (exceptionTypes == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(23);
        }
        return new PhpCatchConditionInstructionImpl(exceptionTypes, exception, false);
    }

    private static PhpBreakContinueInstructionImpl createBreakContinueInstruction(@Nullable BreakContinueTarget breakContinueTarget) {
        return new PhpBreakContinueInstructionImpl(breakContinueTarget != null ? breakContinueTarget.getStatement() : null);
    }

    private static PhpInterruptScriptInstructionImpl createInterruptScriptInstruction() {
        return new PhpInterruptScriptInstructionImpl();
    }

    private static PhpClassDeclarationInstructionImpl createClassDeclarationInstruction(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(24);
        }
        return new PhpClassDeclarationInstructionImpl(phpClass);
    }

    private static PhpFunctionDeclarationInstructionImpl createFunctionDeclarationInstruction(Function function) {
        return new PhpFunctionDeclarationInstructionImpl(function);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endInstruction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakTarget";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "continueTarget";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trueTarget";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "falseTarget";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 12: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowBuilder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionAccess";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakContinueTarget";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextInstruction";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionTypes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowBuilder";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelToDefinitionInstructionMap";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelToGotoInstructionMap";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCatchMatchingListCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addInstruction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addStatementInstruction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "jump";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pushBreakContinueTargets";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pushConditionTargets";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resetCurrentValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resetCurrentValueWeak";
                break;
            }
            case 12: 
            case 13: 
            case 21: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processShortCircuitExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processTrueFalseExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getForeachKeyValueAccessTypeByPrevSibling";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processBreakContinueWithFinally";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "exitPointWasReached";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processCall";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createTrueCatchConditionInstruction";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createFalseCatchConditionInstruction";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createClassDeclarationInstruction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpFinallyInstructionsBlock {
        private boolean myHaveCatchClauses;
        private final int myTryStartOffset;
        private final PhpMarkerInstruction myFirstInstruction;
        private final PhpFinallyEndInstructionImpl myLastInstruction;

        @Nullable
        public static PhpFinallyInstructionsBlock createFinallyInstructionsBlock(@Nullable Finally finallyBlock, boolean haveCatchClauses, int startOffset) {
            return finallyBlock == null ? null : new PhpFinallyInstructionsBlock(new PhpMarkerInstruction(), new PhpFinallyEndInstructionImpl(), haveCatchClauses, startOffset);
        }

        private PhpFinallyInstructionsBlock(@NotNull PhpMarkerInstruction firstInstruction, @NotNull PhpFinallyEndInstructionImpl lastInstruction, boolean haveCatchClauses, int startOffset) {
            if (firstInstruction == null) {
                PhpFinallyInstructionsBlock.$$$reportNull$$$0(0);
            }
            if (lastInstruction == null) {
                PhpFinallyInstructionsBlock.$$$reportNull$$$0(1);
            }
            this.myFirstInstruction = firstInstruction;
            this.myLastInstruction = lastInstruction;
            this.myHaveCatchClauses = haveCatchClauses;
            this.myTryStartOffset = startOffset;
        }

        private PhpMarkerInstruction getFirstInstruction() {
            return this.myFirstInstruction;
        }

        private PhpFinallyEndInstructionImpl getLastInstruction() {
            return this.myLastInstruction;
        }

        private boolean haveCatchClauses() {
            return this.myHaveCatchClauses;
        }

        private void setHaveCatchClauses(boolean haveCatchClauses) {
            this.myHaveCatchClauses = haveCatchClauses;
        }

        private int getTryStartOffset() {
            return this.myTryStartOffset;
        }

        private void addSuccessor(@NotNull PhpInstructionImpl instruction) {
            if (instruction == null) {
                PhpFinallyInstructionsBlock.$$$reportNull$$$0(2);
            }
            this.myLastInstruction.join(instruction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstInstruction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lastInstruction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowBuilder$PhpFinallyInstructionsBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSuccessor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpMarkerInstruction
    extends PhpLinearInstructionImpl {
        private PhpMarkerInstruction() {
        }

        @Nullable
        public final PhpInstructionImpl getSuccessor() {
            return this.mySuccessor;
        }

        public void dispose() {
            this.mySuccessor = null;
            this.getPredecessors().clear();
        }
    }

    private static class PhpExitMarkerInstruction
    extends PhpMarkerInstruction {
        private PhpExitMarkerInstruction() {
        }
    }

    private static class BreakContinueTarget {
        private final PhpInstructionImpl myBreakTarget;
        private final PhpInstructionImpl myContinueTarget;
        private final Statement myStatement;

        private BreakContinueTarget(@NotNull Statement statement, @NotNull PhpInstructionImpl breakTarget, @NotNull PhpInstructionImpl continueTarget) {
            if (statement == null) {
                BreakContinueTarget.$$$reportNull$$$0(0);
            }
            if (breakTarget == null) {
                BreakContinueTarget.$$$reportNull$$$0(1);
            }
            if (continueTarget == null) {
                BreakContinueTarget.$$$reportNull$$$0(2);
            }
            this.myStatement = statement;
            this.myBreakTarget = breakTarget;
            this.myContinueTarget = continueTarget;
        }

        public PhpInstructionImpl getBreakTarget() {
            return this.myBreakTarget;
        }

        public PhpInstructionImpl getContinueTarget() {
            return this.myContinueTarget;
        }

        public Statement getStatement() {
            return this.myStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "breakTarget";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "continueTarget";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowBuilder$BreakContinueTarget";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

