/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpDebugStrategy;
import com.jetbrains.php.debug.common.PhpIdeDebugProcess;
import com.jetbrains.php.debug.common.PhpIdeRemoteDebugProcess;
import com.jetbrains.php.debug.common.PhpLocalDebugStrategy;
import com.jetbrains.php.debug.common.PhpRemoteServerDebugStrategy;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDebugProcessFactory {
    private PhpDebugProcessFactory() {
    }

    public static <C extends PhpDebugConnection> PhpDebugProcess<C> forExternalConnection(@NotNull XDebugSession session, @Nullable String serverName, @NotNull PhpDebugDriver<C> driver) {
        if (session == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(0);
        }
        if (driver == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(1);
        }
        PhpDebugStrategy strategy = serverName == null ? new PhpLocalDebugStrategy(session.getProject()) : new PhpRemoteServerDebugStrategy(session.getProject(), serverName);
        strategy.setPrintErrorOutput(true).setStopSessionOnDisconnect(true);
        return new PhpDebugProcess<C>(session, driver, strategy, null, true);
    }

    public static <C extends PhpDebugConnection> PhpDebugProcess<C> forRemoteDebug(@NotNull XDebugSession session, @NotNull String sessionId, @NotNull PhpDebugConnectionManager<C> manager, @NotNull String serverName, @NotNull PhpDebugDriver<C> driver) {
        if (session == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(2);
        }
        if (sessionId == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(4);
        }
        if (serverName == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(5);
        }
        if (driver == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(6);
        }
        PhpDebugStrategy strategy = new PhpRemoteServerDebugStrategy(session.getProject(), serverName).setPrintErrorOutput(true).setStopSessionOnDisconnect(false);
        return new PhpIdeRemoteDebugProcess<C>(session, sessionId, manager, serverName, driver, strategy, null, true);
    }

    public static <C extends PhpDebugConnection> PhpDebugProcess<C> forPhpHttpRequest(@NotNull XDebugSession session, @NotNull String sessionId, @NotNull PhpDebugConnectionManager<C> connectionsManager, @NotNull String serverName, @Nullable ConsoleView executionConsole, @NotNull PhpDebugDriver<C> driver) {
        if (session == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(7);
        }
        if (sessionId == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(8);
        }
        if (connectionsManager == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(9);
        }
        if (serverName == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(10);
        }
        if (driver == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(11);
        }
        PhpRemoteServerDebugStrategy debugStrategy = new PhpRemoteServerDebugStrategy(session.getProject(), serverName);
        debugStrategy.setPrintErrorOutput(true).setStopSessionOnDisconnect(true);
        return new PhpIdeRemoteDebugProcess<C>(session, sessionId, connectionsManager, serverName, driver, debugStrategy, executionConsole, false);
    }

    public static <C extends PhpDebugConnection> PhpDebugProcess<C> forPhpScript(@NotNull Project project, @NotNull XDebugSession session, @NotNull String sessionId, @NotNull PhpDebugConnectionManager<C> manager, @NotNull PhpDebugDriver<C> driver, @NotNull PhpCommandLinePathProcessor pathProcessor) {
        if (project == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(12);
        }
        if (session == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(13);
        }
        if (sessionId == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(14);
        }
        if (manager == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(15);
        }
        if (driver == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(16);
        }
        if (pathProcessor == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(17);
        }
        return new PhpIdeDebugProcess<C>(session, sessionId, manager, driver, pathProcessor.createDebugStrategy(project), null);
    }

    public static <C extends PhpDebugConnection> PhpDebugProcess<C> forPhpTests(@NotNull XDebugSession session, @NotNull String sessionId, @NotNull PhpDebugConnectionManager<C> manager, @NotNull PhpDebugDriver<C> driver, @NotNull ConsoleView console, @NotNull PhpCommandLinePathProcessor pathProcessor) {
        if (session == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(18);
        }
        if (sessionId == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(19);
        }
        if (manager == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(20);
        }
        if (driver == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(21);
        }
        if (console == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(22);
        }
        if (pathProcessor == null) {
            PhpDebugProcessFactory.$$$reportNull$$$0(23);
        }
        PhpDebugStrategy debugStrategy = pathProcessor.createDebugStrategy(session.getProject());
        debugStrategy.setAllowToForceBreak(false);
        return new PhpIdeDebugProcess<C>(session, sessionId, manager, driver, debugStrategy, console);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 4: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionsManager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathProcessor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/common/PhpDebugProcessFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forExternalConnection";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "forRemoteDebug";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "forPhpHttpRequest";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "forPhpScript";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "forPhpTests";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

