/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.documentation.PhpDocLinkResolver;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocPsiElementImpl;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocRefImpl
extends PhpDocPsiElementImpl
implements PhpDocRef {
    public PhpDocRefImpl(ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiReference[] getReferences() {
        List references = ContainerUtil.newSmartList();
        boolean hasStatic = PhpPsiUtil.getChildOfType((PsiElement)this, PhpDocTokenTypes.DOC_STATIC) != null;
        for (PsiElement element = this.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (!PhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_IDENTIFIER, PhpDocTokenTypes.DOC_VARIABLE)) continue;
            boolean isClass = hasStatic && PhpPsiUtil.isOfType(element.getNextSibling(), PhpDocTokenTypes.DOC_STATIC);
            boolean isMember = hasStatic && PhpPsiUtil.isOfType(element.getPrevSibling(), PhpDocTokenTypes.DOC_STATIC);
            for (PhpDocLinkResolver.Result result : PhpDocLinkResolver.resolve(this.getText(), element)) {
                if (isClass) {
                    PhpClass phpClass = result.getPhpClass();
                    if (phpClass == null) continue;
                    references.add(new PhpDocElementReference(element, (PsiElement)phpClass));
                    continue;
                }
                if (isMember) {
                    PhpClassMember member = result.getMember();
                    if (member == null) continue;
                    references.add(new PhpDocElementReference(element, (PsiElement)member));
                    continue;
                }
                references.add(new PhpDocElementReference(element, result.getElement()));
            }
        }
        PsiReference[] psiReferenceArray = references.isEmpty() ? PsiReference.EMPTY_ARRAY : references.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            PhpDocRefImpl.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocRefImpl", "getReferences"));
    }

    public static class PhpDocElementReference
    implements PsiReference {
        private final PsiElement myElement;
        private final PsiElement myResult;

        private PhpDocElementReference(@NotNull PsiElement element, @NotNull PsiElement result) {
            if (element == null) {
                PhpDocElementReference.$$$reportNull$$$0(0);
            }
            if (result == null) {
                PhpDocElementReference.$$$reportNull$$$0(1);
            }
            this.myElement = element;
            this.myResult = result;
        }

        @NotNull
        public PsiElement getElement() {
            PsiElement psiElement = this.myElement.getParent();
            if (psiElement == null) {
                PhpDocElementReference.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        @NotNull
        public TextRange getRangeInElement() {
            int startOffset = this.myElement.getStartOffsetInParent();
            TextRange textRange = new TextRange(startOffset, startOffset + this.myElement.getTextLength());
            if (textRange == null) {
                PhpDocElementReference.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        @Nullable
        public PsiElement resolve() {
            return this.myResult;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myResult instanceof PhpNamedElement ? ((PhpNamedElement)this.myResult).getFQN() : this.myElement.getParent().getText();
            if (string == null) {
                PhpDocElementReference.$$$reportNull$$$0(4);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            IElementType elementType;
            if (newElementName == null) {
                PhpDocElementReference.$$$reportNull$$$0(5);
            }
            String name = (elementType = this.myElement.getNode().getElementType()) == PhpDocTokenTypes.DOC_VARIABLE ? "$" + newElementName : newElementName;
            PhpDocRef phpDocRef = PhpPsiElementFactory.createPhpDocRef(this.myElement.getProject(), name);
            PsiElement newElement = PhpPsiUtil.getChildOfType((PsiElement)phpDocRef, elementType);
            return newElement != null ? this.myElement.replace(newElement) : this.myElement;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                PhpDocElementReference.$$$reportNull$$$0(6);
            }
            throw new UnsupportedOperationException();
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                PhpDocElementReference.$$$reportNull$$$0(7);
            }
            return this.myResult == element;
        }

        public boolean isSoft() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocRefImpl$PhpDocElementReference";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocRefImpl$PhpDocElementReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

