/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpRemoveParametersQuickFix;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import gnu.trove.THashSet;
import gnu.trove.TIntIntHashMap;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnusedParameterInspection
extends PhpInspection {
    private static final PhpRemoveParametersQuickFix REMOVE_PARAMETER = new PhpRemoveParametersQuickFix();
    private final PhpRemoveAllUnusedParametersQuickFix REMOVE_ALL_UNUSED_PARAMETERS = new PhpRemoveAllUnusedParametersQuickFix();
    private static final String ALL_PARAMETER_ACCESS_FUNCTION = "func_get_args";
    private static final String PARAMETER_ACCESS_FUNCTION = "func_get_arg";
    private static final String PARAMETER_COUNT_ACCESS_FUNCTION = "func_num_args";
    public boolean DONT_REPORT_EMPTY_BODY = true;
    public boolean DONT_REPORT_OVERRIDE = true;
    public boolean DONT_REPORT_ABSTRACT_CLASS = false;
    public boolean DONT_REPORT_ANONYMOUS = false;
    public boolean DONT_REPORT_PARAMETERS_COUNT_ACCESS = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                PhpClass containingClass = method.getContainingClass();
                if (containingClass == null || containingClass.isInterface()) {
                    return;
                }
                if (PhpUnusedParameterInspection.this.isDontReportAbstractClass() && containingClass.isAbstract()) {
                    return;
                }
                CharSequence methodName = method.getNameCS();
                if (StringUtil.isEmpty((CharSequence)methodName)) {
                    return;
                }
                if (method.isAbstract()) {
                    return;
                }
                Parameter[] parameters = method.getParameters();
                if (parameters.length == 0) {
                    return;
                }
                TIntIntHashMap unused = PhpUnusedParameterInspection.this.getUnusedParameters(parameters, (PhpScopeHolder)method);
                if (unused == null || unused.size() == 0) {
                    return;
                }
                if (PhpUnusedParameterInspection.this.isDontReportEmptyBody() && PhpCodeInsightUtil.isEmptyBody((Function)method)) {
                    return;
                }
                if (PhpUnusedParameterInspection.this.isDontReportOverride()) {
                    Ref isOverride = new Ref((Object)false);
                    Processor processor = phpClass -> {
                        Method methodByName = phpClass.findMethodByName(methodName);
                        if (methodByName != null && methodByName.getMethodType(false) != Method.MethodType.CONSTRUCTOR) {
                            isOverride.set((Object)true);
                            return false;
                        }
                        return true;
                    };
                    PhpClassHierarchyUtils.processSuperClasses((PhpClass)containingClass, (boolean)false, (boolean)true, (Processor)processor);
                    if (!((Boolean)isOverride.get()).booleanValue()) {
                        PhpClassHierarchyUtils.processSuperInterfaces((PhpClass)containingClass, (boolean)false, (boolean)true, (Processor)processor);
                    }
                    if (((Boolean)isOverride.get()).booleanValue()) {
                        return;
                    }
                }
                PhpRemoveAllUnusedParametersQuickFix removeAllQuickFix = this.removeAllQuickFix(unused);
                for (int index : unused.keys()) {
                    PhpUnusedParameterInspection.reportProblem(holder, parameters[index], removeAllQuickFix, unused.get(index));
                }
            }

            public void visitPhpFunction(Function function) {
                if (PhpUnusedParameterInspection.this.isDontReportAnonymous() && function.isClosure()) {
                    return;
                }
                Parameter[] parameters = function.getParameters();
                if (parameters.length == 0) {
                    return;
                }
                TIntIntHashMap unused = PhpUnusedParameterInspection.this.getUnusedParameters(parameters, (PhpScopeHolder)function);
                if (unused == null || unused.size() == 0) {
                    return;
                }
                if (PhpUnusedParameterInspection.this.isDontReportEmptyBody() && PhpCodeInsightUtil.isEmptyBody(function)) {
                    return;
                }
                PhpRemoveAllUnusedParametersQuickFix removeAllQuickFix = this.removeAllQuickFix(unused);
                for (int index : unused.keys()) {
                    PhpUnusedParameterInspection.reportProblem(holder, parameters[index], removeAllQuickFix, unused.get(index));
                }
            }

            private PhpRemoveAllUnusedParametersQuickFix removeAllQuickFix(@NotNull TIntIntHashMap unused) {
                if (unused == null) {
                    1.$$$reportNull$$$0(0);
                }
                return unused.keys().length > 1 ? PhpUnusedParameterInspection.this.REMOVE_ALL_UNUSED_PARAMETERS : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unused", "com/jetbrains/php/lang/inspections/PhpUnusedParameterInspection$1", "removeAllQuickFix"));
            }
        };
        if (phpElementVisitor == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static void reportProblem(@NotNull ProblemsHolder holder, @NotNull Parameter parameter, @Nullable LocalQuickFix quickFix, int unusedCase) {
        if (holder == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(2);
        }
        if (parameter == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(3);
        }
        PsiElement namePsi = parameter.getNameIdentifier();
        assert (namePsi != null);
        String description = PhpBundle.message("inspection.unused.parameter.problem", parameter.getName(), PhpUnusedParameterInspection.getDescriptionByNumber(unusedCase));
        if (quickFix == null) {
            holder.registerProblem(namePsi, description, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{REMOVE_PARAMETER});
        } else {
            holder.registerProblem(namePsi, description, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{REMOVE_PARAMETER, quickFix});
        }
    }

    @Nullable
    private TIntIntHashMap getUnusedParameters(@NotNull Parameter[] parameters, @NotNull PhpScopeHolder scopeHolder) {
        THashSet indirectParameterAccess;
        if (parameters == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(4);
        }
        if (scopeHolder == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(5);
        }
        if (this.collectIndirectAccess(scopeHolder, (Set<Integer>)(indirectParameterAccess = new THashSet()))) {
            return null;
        }
        TIntIntHashMap unusedIndexesDescriptions = new TIntIntHashMap();
        int parametersLength = parameters.length;
        block0: for (int i = 0; i < parametersLength; ++i) {
            Parameter parameter;
            String parameterName;
            if (indirectParameterAccess.contains(i) || StringUtil.isEmpty((String)(parameterName = (parameter = parameters[i]).getName()))) continue;
            PhpAccessVariableInstruction[] followingAccesses = PhpControlFlowUtil.getFollowingVariableAccessInstructions((PhpInstruction)scopeHolder.getControlFlow().getEntryPoint(), parameterName, true);
            if (followingAccesses.length == 0) {
                if (parameter.isPassByRef()) {
                    unusedIndexesDescriptions.put(i, 3);
                    continue;
                }
                unusedIndexesDescriptions.put(i, 1);
                continue;
            }
            if (parameter.isPassByRef()) {
                for (PhpAccessVariableInstruction followingAccess : followingAccesses) {
                    if (!followingAccess.getAccess().isWriteRef()) continue block0;
                }
                unusedIndexesDescriptions.put(i, 4);
                continue;
            }
            for (PhpAccessVariableInstruction followingAccess : followingAccesses) {
                PhpAccessInstruction.Access access = followingAccess.getAccess();
                if (!access.isWrite() || access.isRead()) continue block0;
            }
            unusedIndexesDescriptions.put(i, 2);
        }
        return unusedIndexesDescriptions;
    }

    private boolean collectIndirectAccess(@NotNull PhpScopeHolder scopeHolder, final @NotNull Set<Integer> accessedParameters) {
        if (scopeHolder == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(6);
        }
        if (accessedParameters == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(7);
        }
        final Ref hasAccessToAllParameters = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)scopeHolder.getControlFlow().getEntryPoint(), false, new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction instruction) {
                if (instruction instanceof PhpCallInstruction) {
                    Integer index;
                    PsiElement indexElement;
                    ParameterList parameterList;
                    FunctionReference functionReference = ((PhpCallInstruction)instruction).getFunctionReference();
                    CharSequence functionName = functionReference.getNameCS();
                    if (PhpLangUtil.equalsFunctionNames(functionName, PhpUnusedParameterInspection.ALL_PARAMETER_ACCESS_FUNCTION) || PhpUnusedParameterInspection.this.isDontReportParametersCountAccess() && PhpLangUtil.equalsFunctionNames(functionName, PhpUnusedParameterInspection.PARAMETER_COUNT_ACCESS_FUNCTION)) {
                        hasAccessToAllParameters.set((Object)true);
                    } else if (PhpLangUtil.equalsFunctionNames(functionName, PhpUnusedParameterInspection.PARAMETER_ACCESS_FUNCTION) && (parameterList = functionReference.getParameterList()) != null && (indexElement = PhpPsiUtil.getChildOfType((PsiElement)parameterList, PhpElementTypes.NUMBER)) != null && (index = PhpCodeInsightUtil.toInt(indexElement)) != null) {
                        accessedParameters.add(index);
                    }
                }
                return (Boolean)hasAccessToAllParameters.get() == false;
            }
        });
        return (Boolean)hasAccessToAllParameters.get();
    }

    @NotNull
    private static String getDescriptionByNumber(int num) {
        switch (num) {
            case 1: {
                String string = PhpBundle.message("inspection.unused.parameter.problem.case1", new Object[0]);
                if (string == null) {
                    PhpUnusedParameterInspection.$$$reportNull$$$0(8);
                }
                return string;
            }
            case 2: {
                String string = PhpBundle.message("inspection.unused.parameter.problem.case2", new Object[0]);
                if (string == null) {
                    PhpUnusedParameterInspection.$$$reportNull$$$0(9);
                }
                return string;
            }
            case 3: {
                String string = PhpBundle.message("inspection.unused.parameter.problem.case3", new Object[0]);
                if (string == null) {
                    PhpUnusedParameterInspection.$$$reportNull$$$0(10);
                }
                return string;
            }
            case 4: {
                String string = PhpBundle.message("inspection.unused.parameter.problem.case4", new Object[0]);
                if (string == null) {
                    PhpUnusedParameterInspection.$$$reportNull$$$0(11);
                }
                return string;
            }
        }
        if (null == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(12);
        }
        return null;
    }

    public boolean isDontReportEmptyBody() {
        return this.DONT_REPORT_EMPTY_BODY;
    }

    public boolean isDontReportAbstractClass() {
        return this.DONT_REPORT_ABSTRACT_CLASS;
    }

    public boolean isDontReportOverride() {
        return this.DONT_REPORT_OVERRIDE;
    }

    public boolean isDontReportAnonymous() {
        return this.DONT_REPORT_ANONYMOUS;
    }

    public boolean isDontReportParametersCountAccess() {
        return this.DONT_REPORT_PARAMETERS_COUNT_ACCESS;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnusedParameterInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessedParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnusedParameterInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionByNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reportProblem";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedParameters";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectIndirectAccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox myDontReportEmptyBodyCheckBox;
        private JCheckBox myDontReportOverrideCheckBox;
        private JCheckBox myDontReportAbstractCheckBox;
        private JCheckBox myDontReportAnonymousCheckBox;
        private JCheckBox myDontReportParametersCountAccess;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myDontReportEmptyBodyCheckBox.setSelected(PhpUnusedParameterInspection.this.DONT_REPORT_EMPTY_BODY);
            this.myDontReportEmptyBodyCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedParameterInspection.this.DONT_REPORT_EMPTY_BODY = OptionsPanel.this.myDontReportEmptyBodyCheckBox.isSelected();
                }
            });
            this.myDontReportOverrideCheckBox.setSelected(PhpUnusedParameterInspection.this.DONT_REPORT_OVERRIDE);
            this.myDontReportOverrideCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedParameterInspection.this.DONT_REPORT_OVERRIDE = OptionsPanel.this.myDontReportOverrideCheckBox.isSelected();
                }
            });
            this.myDontReportAbstractCheckBox.setSelected(PhpUnusedParameterInspection.this.DONT_REPORT_ABSTRACT_CLASS);
            this.myDontReportAbstractCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedParameterInspection.this.DONT_REPORT_ABSTRACT_CLASS = OptionsPanel.this.myDontReportAbstractCheckBox.isSelected();
                }
            });
            this.myDontReportAnonymousCheckBox.setSelected(PhpUnusedParameterInspection.this.DONT_REPORT_ANONYMOUS);
            this.myDontReportAnonymousCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedParameterInspection.this.DONT_REPORT_ANONYMOUS = OptionsPanel.this.myDontReportAnonymousCheckBox.isSelected();
                }
            });
            this.myDontReportParametersCountAccess.setSelected(PhpUnusedParameterInspection.this.DONT_REPORT_PARAMETERS_COUNT_ACCESS);
            this.myDontReportParametersCountAccess.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedParameterInspection.this.DONT_REPORT_PARAMETERS_COUNT_ACCESS = OptionsPanel.this.myDontReportParametersCountAccess.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myDontReportEmptyBodyCheckBox = jCheckBox5 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.unused.parameter.option.description.empty.body"));
            jPanel.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myDontReportOverrideCheckBox = jCheckBox4 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.unused.parameter.option.description.empty.override"));
            jPanel.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDontReportAbstractCheckBox = jCheckBox3 = new JCheckBox();
            jCheckBox3.setSelected(false);
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.unused.parameter.option.description.empty.abstract"));
            jPanel.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDontReportAnonymousCheckBox = jCheckBox2 = new JCheckBox();
            jCheckBox2.setSelected(false);
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.unused.parameter.option.description.empty.anonymous"));
            jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDontReportParametersCountAccess = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.unused.parameter.option.description.parameter.count"));
            jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private class PhpRemoveAllUnusedParametersQuickFix
    extends PhpRemoveParametersQuickFix {
        private PhpRemoveAllUnusedParametersQuickFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            if ("Remove all unused parameters" == null) {
                PhpRemoveAllUnusedParametersQuickFix.$$$reportNull$$$0(0);
            }
            return "Remove all unused parameters";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Function function;
            if (project == null) {
                PhpRemoveAllUnusedParametersQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpRemoveAllUnusedParametersQuickFix.$$$reportNull$$$0(2);
            }
            if ((function = (Function)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), Function.class)) == null) {
                return;
            }
            Parameter[] parameters = function.getParameters();
            if (parameters.length == 0) {
                return;
            }
            TIntIntHashMap unused = PhpUnusedParameterInspection.this.getUnusedParameters(parameters, (PhpScopeHolder)function);
            if (unused == null || unused.isEmpty()) {
                return;
            }
            this.removeParameters(function, this.getParams(parameters, unused.keys()));
        }

        private Set<Parameter> getParams(Parameter[] parameters, int[] keys) {
            HashSet result = ContainerUtil.newHashSet((int)keys.length);
            for (int key : keys) {
                result.add(parameters[key]);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnusedParameterInspection$PhpRemoveAllUnusedParametersQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnusedParameterInspection$PhpRemoveAllUnusedParametersQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

