/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpExitPointInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnusedLocalVariableInspection
extends PhpInspection {
    private static final String ERROR_BATCH = PhpBundle.message("inspection.unused.local.variable.problem.batch", new Object[0]);
    private static final String VARIABLE_ACCESS_FUNCTION = "get_defined_vars";
    public boolean ENABLE_IN_FILE_SCOPE = false;
    public boolean DONT_REPORT_FOREACH_VALUE = true;
    public boolean DONT_REPORT_CATCH_EXCEPTION = true;
    public boolean DONT_REPORT_INSIDE_LIST = false;
    public boolean DONT_REPORT_ASSIGNMENT_TO_NULL = true;
    public boolean DONT_REPORT_INDIRECT_ACCESS = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PhpUnusedLocalVariableInspection.this.analyzeScope((PhpScopeHolder)function, holder, isOnTheFly);
            }

            public void visitPhpMethod(Method method) {
                PhpUnusedLocalVariableInspection.this.analyzeScope((PhpScopeHolder)method, holder, isOnTheFly);
            }

            public void visitPhpNamespace(PhpNamespace namespace) {
                PhpUnusedLocalVariableInspection.this.analyzeScope((PhpScopeHolder)namespace, holder, isOnTheFly);
            }

            public void visitPhpFile(PhpFile PhpFile2) {
                if (PhpUnusedLocalVariableInspection.this.ENABLE_IN_FILE_SCOPE) {
                    PhpUnusedLocalVariableInspection.this.analyzeScope((PhpScopeHolder)PhpFile2, holder, isOnTheFly);
                } else {
                    super.visitPhpFile(PhpFile2);
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private void analyzeScope(final @NotNull PhpScopeHolder scopeHolder, final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (scopeHolder == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(3);
        }
        PhpControlFlow controlFlow = scopeHolder.getControlFlow();
        final HashSet unusedStatic = new HashSet();
        final Ref haveIndirectAccess = new Ref(null);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)controlFlow.getEntryPoint(), false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (instruction.getAccess().isWrite()) {
                    String caseDescription;
                    boolean unused;
                    CharSequence variableName;
                    PhpPsiElement variable;
                    block24: {
                        if (PhpUnusedLocalVariableInspection.this.isDontReportIndirectAccess() && this.haveIndirectAccess(instruction)) {
                            return true;
                        }
                        variable = instruction.getAnchor();
                        variableName = instruction.getVariableName();
                        PhpAccessVariableInstruction[] followingVariableAccessInstructions = PhpControlFlowUtil.getFollowingVariableAccessInstructions((PhpInstruction)instruction, variableName, true);
                        unused = true;
                        caseDescription = "";
                        if (followingVariableAccessInstructions.length == 0) {
                            caseDescription = PhpBundle.message("inspection.unused.local.variable.problem.case1", new Object[0]);
                        } else {
                            for (PhpAccessVariableInstruction followingVariableAccess : followingVariableAccessInstructions) {
                                if ((followingVariableAccess.getAccess().isWrite() || followingVariableAccess.getAccess().isWriteRef()) && !followingVariableAccess.getAccess().isReadWrite() && !(followingVariableAccess.getAnchor().getParent() instanceof ArrayAccessExpression)) continue;
                                unused = false;
                                break block24;
                            }
                            caseDescription = PhpBundle.message("inspection.unused.local.variable.problem.case2", new Object[0]);
                        }
                    }
                    if (unused && !PhpControlFlowUtil.isReferenced(scopeHolder, instruction) && !PhpLangUtil.isSuperGlobal(variableName)) {
                        AssignmentExpression assignmentExpression;
                        PhpPsiElement value;
                        List variables;
                        PhpAccessVariableInstruction staticAccess = PhpUnusedLocalVariableInspection.getStaticAccess(instruction);
                        if (staticAccess != null) {
                            if (staticAccess == instruction) {
                                unusedStatic.add(instruction);
                            } else if (!unusedStatic.contains(staticAccess)) {
                                return true;
                            }
                        }
                        PsiElement variableParent = variable.getParent();
                        if (PhpUnusedLocalVariableInspection.this.isDontReportUnusedCatchException() && variableParent instanceof Catch) {
                            return true;
                        }
                        if (PhpUnusedLocalVariableInspection.this.isDontReportForeachValue() && variableParent instanceof ForeachStatement && (variables = ((ForeachStatement)variableParent).getVariables()).size() > 1 && variable instanceof Variable && variables.contains(variable)) {
                            return true;
                        }
                        if (PhpUnusedLocalVariableInspection.this.isDontReportInsideList() && variableParent instanceof MultiassignmentExpression) {
                            return true;
                        }
                        if (PhpUnusedLocalVariableInspection.this.isDontReportAssignmentToNull() && variableParent instanceof AssignmentExpression && PhpCodeInsightUtil.isNull((PsiElement)(value = (assignmentExpression = (AssignmentExpression)variableParent).getValue()))) {
                            return true;
                        }
                        if (isOnTheFly) {
                            holder.registerProblem((PsiElement)variable, PhpBundle.message("inspection.unused.local.variable.problem", instruction.getVariableName(), caseDescription), ProblemHighlightType.LIKE_UNUSED_SYMBOL, LocalQuickFix.EMPTY_ARRAY);
                        } else {
                            holder.registerProblem((PsiElement)variable, ERROR_BATCH, ProblemHighlightType.LIKE_UNUSED_SYMBOL, LocalQuickFix.EMPTY_ARRAY);
                        }
                    }
                } else if (instruction.getAccess().isWriteRef()) {
                    String caseDescription;
                    boolean unused;
                    CharSequence variableName;
                    PhpPsiElement variable;
                    block25: {
                        variable = instruction.getAnchor();
                        variableName = instruction.getVariableName();
                        PhpAccessVariableInstruction[] followingVariableAccessInstructions = PhpControlFlowUtil.getFollowingVariableAccessInstructions((PhpInstruction)instruction, variableName, true);
                        unused = true;
                        caseDescription = "";
                        if (followingVariableAccessInstructions.length == 0) {
                            caseDescription = PhpBundle.message("inspection.unused.local.variable.problem.case3", new Object[0]);
                        } else {
                            for (PhpAccessVariableInstruction followingAccess : followingVariableAccessInstructions) {
                                if (followingAccess.getAccess().isWriteRef() && !(followingAccess.getAnchor().getParent() instanceof ArrayAccessExpression)) continue;
                                unused = false;
                                break block25;
                            }
                            caseDescription = PhpBundle.message("inspection.unused.local.variable.problem.case4", new Object[0]);
                        }
                    }
                    if (unused && !PhpLangUtil.isSuperGlobal(variableName)) {
                        if (isOnTheFly) {
                            holder.registerProblem((PsiElement)variable, PhpBundle.message("inspection.unused.local.variable.problem", instruction.getVariableName(), caseDescription), ProblemHighlightType.LIKE_UNUSED_SYMBOL, LocalQuickFix.EMPTY_ARRAY);
                        } else {
                            holder.registerProblem((PsiElement)variable, ERROR_BATCH, ProblemHighlightType.LIKE_UNUSED_SYMBOL, LocalQuickFix.EMPTY_ARRAY);
                        }
                    }
                }
                return true;
            }

            private boolean haveIndirectAccess(PhpAccessVariableInstruction instruction) {
                if (haveIndirectAccess.isNull()) {
                    PhpExitPointInstructionImpl tail = new PhpExitPointInstructionImpl();
                    haveIndirectAccess.set((Object)tail);
                    PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                        public boolean processInstruction(PhpInstruction instruction) {
                            FunctionReference reference;
                            CharSequence functionName;
                            if (instruction instanceof PhpCallInstruction && PhpLangUtil.equalsFunctionNames(functionName = (reference = ((PhpCallInstruction)instruction).getFunctionReference()).getNameCS(), PhpUnusedLocalVariableInspection.VARIABLE_ACCESS_FUNCTION)) {
                                haveIndirectAccess.set((Object)((PhpInstructionImpl)instruction));
                            }
                            return true;
                        }
                    });
                }
                return ((PhpInstructionImpl)haveIndirectAccess.get()).myNumber > ((PhpInstructionImpl)instruction).myNumber;
            }
        });
    }

    @Nullable
    private static PhpAccessVariableInstruction getStaticAccess(@NotNull PhpAccessVariableInstruction accessInstruction) {
        if (accessInstruction == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(4);
        }
        final Ref isStaticFound = new Ref();
        PhpControlFlowUtil.processPreviousVariableAccesses(accessInstruction, true, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpPsiElement anchor = instruction.getAnchor();
                PsiElement parent = anchor.getParent();
                if (parent != null && parent.getParent() instanceof PhpStaticStatement) {
                    isStaticFound.set((Object)instruction);
                    return false;
                }
                return true;
            }
        });
        return (PhpAccessVariableInstruction)isStaticFound.get();
    }

    public boolean isDontReportForeachValue() {
        return this.DONT_REPORT_FOREACH_VALUE;
    }

    public boolean isDontReportUnusedCatchException() {
        return this.DONT_REPORT_CATCH_EXCEPTION;
    }

    public boolean isDontReportInsideList() {
        return this.DONT_REPORT_INSIDE_LIST;
    }

    public boolean isDontReportAssignmentToNull() {
        return this.DONT_REPORT_ASSIGNMENT_TO_NULL;
    }

    public boolean isDontReportIndirectAccess() {
        return this.DONT_REPORT_INDIRECT_ACCESS;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStaticAccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox myEnableInFileScopeCheckBox;
        private JCheckBox myDontReportForeachValueCheckBox;
        private JCheckBox myDontReportUnusedCatchExceptionCheckBox;
        private JCheckBox myDontReportInsideListCheckBox;
        private JCheckBox myDontReportAssignmentToNull;
        private JCheckBox myDontReportIndirectAccess;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myEnableInFileScopeCheckBox.setSelected(PhpUnusedLocalVariableInspection.this.ENABLE_IN_FILE_SCOPE);
            this.myEnableInFileScopeCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhpUnusedLocalVariableInspection.this.ENABLE_IN_FILE_SCOPE = OptionsPanel.this.myEnableInFileScopeCheckBox.isSelected();
                }
            });
            this.myDontReportForeachValueCheckBox.setSelected(PhpUnusedLocalVariableInspection.this.DONT_REPORT_FOREACH_VALUE);
            this.myDontReportForeachValueCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedLocalVariableInspection.this.DONT_REPORT_FOREACH_VALUE = OptionsPanel.this.myDontReportForeachValueCheckBox.isSelected();
                }
            });
            this.myDontReportUnusedCatchExceptionCheckBox.setSelected(PhpUnusedLocalVariableInspection.this.DONT_REPORT_CATCH_EXCEPTION);
            this.myDontReportUnusedCatchExceptionCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedLocalVariableInspection.this.DONT_REPORT_CATCH_EXCEPTION = OptionsPanel.this.myDontReportUnusedCatchExceptionCheckBox.isSelected();
                }
            });
            this.myDontReportInsideListCheckBox.setSelected(PhpUnusedLocalVariableInspection.this.DONT_REPORT_INSIDE_LIST);
            this.myDontReportInsideListCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedLocalVariableInspection.this.DONT_REPORT_INSIDE_LIST = OptionsPanel.this.myDontReportInsideListCheckBox.isSelected();
                }
            });
            this.myDontReportAssignmentToNull.setSelected(PhpUnusedLocalVariableInspection.this.DONT_REPORT_ASSIGNMENT_TO_NULL);
            this.myDontReportAssignmentToNull.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedLocalVariableInspection.this.DONT_REPORT_ASSIGNMENT_TO_NULL = OptionsPanel.this.myDontReportAssignmentToNull.isSelected();
                }
            });
            this.myDontReportIndirectAccess.setSelected(PhpUnusedLocalVariableInspection.this.DONT_REPORT_INDIRECT_ACCESS);
            this.myDontReportIndirectAccess.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedLocalVariableInspection.this.DONT_REPORT_INDIRECT_ACCESS = OptionsPanel.this.myDontReportIndirectAccess.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myDontReportForeachValueCheckBox = jCheckBox6 = new JCheckBox();
            jCheckBox6.setSelected(false);
            this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.unused.local.variable.option.description.foreach"));
            jPanel.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myDontReportUnusedCatchExceptionCheckBox = jCheckBox5 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.unused.local.variable.option.description.catch"));
            jPanel.add((Component)jCheckBox5, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDontReportInsideListCheckBox = jCheckBox4 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.unused.local.variable.option.description.list"));
            jPanel.add((Component)jCheckBox4, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myEnableInFileScopeCheckBox = jCheckBox3 = new JCheckBox();
            jCheckBox3.setSelected(false);
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.unused.local.variable.option.description.file.scope"));
            jPanel.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDontReportAssignmentToNull = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.unused.local.variable.option.description.null"));
            jPanel.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDontReportIndirectAccess = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.unused.local.variable.option.indirect.access"));
            jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

