/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocCommentImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocCoversTag;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpPathInfo;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpPathInfoDescriptor;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpPathInfoSetExternalizer;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitCoversIndex
extends FileBasedIndexExtension<PhpPathInfo, Set<PhpPathInfo>> {
    @NonNls
    public static final ID<PhpPathInfo, Set<PhpPathInfo>> KEY = ID.create((String)"php.unit.covers");

    @NotNull
    public ID<PhpPathInfo, Set<PhpPathInfo>> getName() {
        ID<PhpPathInfo, Set<PhpPathInfo>> iD = KEY;
        if (iD == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<PhpPathInfo, Set<PhpPathInfo>, FileContent> getIndexer() {
        DataIndexer<PhpPathInfo, Set<PhpPathInfo>, FileContent> dataIndexer = new DataIndexer<PhpPathInfo, Set<PhpPathInfo>, FileContent>(){

            @NotNull
            public Map<PhpPathInfo, Set<PhpPathInfo>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashMap map = ContainerUtil.newHashMap();
                PhpFile file = (PhpFile)ObjectUtils.tryCast((Object)inputData.getPsiFile(), PhpFile.class);
                if (file != null) {
                    for (PhpClass testClass : PhpPsiUtil.findAllClasses(file)) {
                        if (!TestFinderHelper.isTest((PsiElement)testClass)) continue;
                        String testClassFQN = testClass.getFQN();
                        for (PhpPathInfo coveredPath : PhpUnitCoversIndex.getCoveredPaths((PhpNamedElement)testClass, null)) {
                            map.computeIfAbsent(coveredPath, xva$0 -> ContainerUtil.newHashSet((Object[])new PhpPathInfo[]{xva$0})).add(PhpPathInfo.byClass(testClassFQN));
                        }
                        String defaultCoveredClassName = PhpUnitUtil.getDefaultCoveredClassName(testClass);
                        PhpClassHierarchyUtils.processMethods((PhpClass)testClass, (PhpClass)testClass, (method, subClass, baseClass) -> {
                            if (!(method instanceof PhpDocMethod)) {
                                for (PhpPathInfo coveredMethodPath : PhpUnitCoversIndex.getCoveredPaths((PhpNamedElement)method, defaultCoveredClassName)) {
                                    map.computeIfAbsent(coveredMethodPath, xva$0 -> ContainerUtil.newHashSet((Object[])new PhpPathInfo[]{xva$0})).add(PhpPathInfo.byMethod(testClassFQN, method.getName()));
                                    map.computeIfAbsent(PhpPathInfo.byClass(coveredMethodPath.getClassFQN()), xva$0 -> ContainerUtil.newHashSet((Object[])new PhpPathInfo[]{xva$0})).add(PhpPathInfo.byClass(testClassFQN));
                                }
                            }
                            return true;
                        }, (boolean)true);
                    }
                }
                HashMap hashMap = map;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUnitCoversIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUnitCoversIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public static Set<PhpPathInfo> getCoveredPaths(@NotNull PhpNamedElement element, @Nullable String defaultCoveredClassFQN) {
        if (element == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(2);
        }
        HashSet result = ContainerUtil.newHashSet();
        PhpDocCommentImpl comment = (PhpDocCommentImpl)element.getDocComment();
        if (comment != null) {
            String namespaceName = element.getNamespaceName();
            for (PhpDocCoversTag tag : comment.getDocTagByClass(PhpDocCoversTag.class)) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)PhpUnitCoversIndex.parseCoveredPath(tag, defaultCoveredClassFQN, namespaceName));
            }
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @Nullable
    private static PhpPathInfo parseCoveredPath(@NotNull PhpDocCoversTag tag, @Nullable String defaultCoveredClassFQN, @NotNull String namespaceName) {
        PsiElement methodIdentifier;
        PsiElement firstChild;
        PhpPsiElement tagValue;
        if (tag == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(4);
        }
        if (namespaceName == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(5);
        }
        if ((tagValue = tag.getFirstPsiChild()) instanceof PhpDocRef) {
            PsiElement firstChild2 = tagValue.getFirstChild();
            PsiElement classIdentifier = PhpPsiUtil.isOfType(firstChild2, PhpElementTypes.NS_REFERENCE) ? PhpUnitCoversIndex.getNextSibling(firstChild2, PhpDocTokenTypes.DOC_IDENTIFIER) : firstChild2;
            String coveredClassFQN = PhpUnitCoversIndex.getCoveredClassFqn(classIdentifier, namespaceName);
            if (coveredClassFQN != null) {
                PsiElement docStatic = PhpUnitCoversIndex.getNextSibling(classIdentifier, PhpDocTokenTypes.DOC_STATIC);
                if (docStatic != null) {
                    String accessValue;
                    PsiElement methodIdentifier2 = PhpUnitCoversIndex.getNextSibling(docStatic, PhpDocTokenTypes.DOC_IDENTIFIER);
                    if (methodIdentifier2 != null) {
                        return PhpPathInfo.byMethod(coveredClassFQN, methodIdentifier2.getText());
                    }
                    PsiElement accessIdentifier = PhpUnitCoversIndex.getNextSibling((PsiElement)tagValue, (IElementType)PhpDocElementTypes.phpDocTagValue);
                    if (accessIdentifier != null && StringUtil.startsWith((CharSequence)(accessValue = PhpUnitCoversIndex.getTextBeforeFirstWhitespace(accessIdentifier)), (CharSequence)"<")) {
                        return PhpUnitCoversIndex.parseCoveredAccess(accessValue, coveredClassFQN);
                    }
                }
                return PhpPathInfo.byClass(coveredClassFQN);
            }
        } else if (defaultCoveredClassFQN != null && PhpPsiUtil.isOfType((PsiElement)tagValue, (IElementType)PhpDocElementTypes.phpDocTagValue) && PhpPsiUtil.isOfType(firstChild = tagValue.getFirstChild(), PhpDocTokenTypes.DOC_STATIC) && (methodIdentifier = PhpUnitCoversIndex.getNextSibling(firstChild, PhpDocTokenTypes.DOC_IDENTIFIER)) != null) {
            return PhpPathInfo.byMethod(defaultCoveredClassFQN, methodIdentifier.getText());
        }
        return null;
    }

    @Nullable
    private static PsiElement getNextSibling(@Nullable PsiElement element, @NotNull IElementType type) {
        if (type == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(6);
        }
        if (element == null) {
            return null;
        }
        PsiElement sibling = element.getNextSibling();
        return PhpPsiUtil.isOfType(sibling, type) ? sibling : null;
    }

    @Nullable
    private static String getCoveredClassFqn(@Nullable PsiElement classIdentifier, @NotNull String baseNamespaceName) {
        if (baseNamespaceName == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(7);
        }
        if (PhpPsiUtil.isOfType(classIdentifier, PhpDocTokenTypes.DOC_IDENTIFIER)) {
            PsiElement namespace = classIdentifier.getPrevSibling();
            if (PhpPsiUtil.isOfType(namespace, PhpElementTypes.NS_REFERENCE)) {
                return PhpLangUtil.concat(PhpLangUtil.toFQN(namespace.getText()), classIdentifier.getText());
            }
            return PhpLangUtil.concat(baseNamespaceName, classIdentifier.getText());
        }
        return null;
    }

    @NotNull
    private static String getTextBeforeFirstWhitespace(@NotNull PsiElement docTagValue) {
        if (docTagValue == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(8);
        }
        StringBuilder result = new StringBuilder();
        for (PsiElement child = docTagValue.getFirstChild(); child != null && !PhpPsiUtil.isOfType(child, TokenType.WHITE_SPACE); child = child.getNextSibling()) {
            result.append(child.getText());
        }
        String string = result.toString();
        if (string == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    private static PhpPathInfo parseCoveredAccess(@NotNull String coveredAccess, @NotNull String coveredClassFQN) {
        if (coveredAccess == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(10);
        }
        if (coveredClassFQN == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(11);
        }
        if (coveredAccess.length() < 3) {
            return null;
        }
        boolean inverseAccess = coveredAccess.charAt(1) == '!';
        String access = coveredAccess.substring(inverseAccess ? 2 : 1, coveredAccess.length() - 1);
        boolean isAccessValid = StringUtil.equals((CharSequence)"public", (CharSequence)access) || StringUtil.equals((CharSequence)"protected", (CharSequence)access) || StringUtil.equals((CharSequence)"private", (CharSequence)access);
        return isAccessValid ? PhpPathInfo.byAccess(coveredClassFQN, access, inverseAccess) : null;
    }

    @NotNull
    public KeyDescriptor<PhpPathInfo> getKeyDescriptor() {
        KeyDescriptor<PhpPathInfo> keyDescriptor = PhpPathInfoDescriptor.INSTANCE;
        if (keyDescriptor == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(12);
        }
        return keyDescriptor;
    }

    @NotNull
    public DataExternalizer<Set<PhpPathInfo>> getValueExternalizer() {
        PhpPathInfoSetExternalizer phpPathInfoSetExternalizer = PhpPathInfoSetExternalizer.INSTANCE;
        if (phpPathInfoSetExternalizer == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(13);
        }
        return phpPathInfoSetExternalizer;
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(14);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUnitCoversIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseNamespaceName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docTagValue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coveredAccess";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coveredClassFQN";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUnitCoversIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveredPaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextBeforeFirstWhitespace";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCoveredPaths";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseCoveredPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNextSibling";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCoveredClassFqn";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTextBeforeFirstWhitespace";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseCoveredAccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

