/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceConstant;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBasePresenter;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceRefactoringHandler;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantDisplay;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantNameSuggestionProvider;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantSettings;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIntroduceConstantPresenter
extends PhpIntroduceBasePresenter<PhpIntroduceConstantDisplay, PhpIntroduceConstantSettings, PhpIntroduceRefactoringHandler<PhpIntroduceConstantSettings>>
implements PhpIntroduceBasePresenter.DisplayHandler<PhpIntroduceConstantDisplay> {
    public PhpIntroduceConstantPresenter(PhpIntroduceConstantDisplay display, PhpIntroduceRefactoringHandler<PhpIntroduceConstantSettings> refactoringHandler, PhpIntroduceContext introduceContext) {
        super(display, refactoringHandler, introduceContext);
        this.handleDeclarations(PhpIntroduceConstantPresenter.collectConstDeclarations(introduceContext));
    }

    public static Set<? extends PhpNamedElement> collectConstDeclarations(PhpIntroduceContext introduceContext) {
        PsiElement scope = introduceContext.getScope();
        if (scope instanceof PhpClass) {
            return FieldImpl.collectClassConstDeclarations((PhpPsiElement)((PhpClass)scope));
        }
        if (scope instanceof PhpFile) {
            final HashSet constants = new HashSet();
            scope.accept((PsiElementVisitor)new PhpElementVisitor(){

                public void visitElement(PsiElement element) {
                    if (element instanceof PhpClass || element instanceof PhpNamespace || element instanceof Function) {
                        return;
                    }
                    if (element instanceof Constant) {
                        constants.add((Constant)element);
                    } else {
                        element.acceptChildren((PsiElementVisitor)this);
                    }
                }
            });
            return constants;
        }
        if (scope instanceof PhpNamespace) {
            final HashSet constants = new HashSet();
            scope.accept((PsiElementVisitor)new PhpElementVisitor(){

                public void visitPhpElement(PhpPsiElement element) {
                    if (element instanceof PhpClass || element instanceof PhpFile || element instanceof Function) {
                        return;
                    }
                    if (element instanceof Constant) {
                        constants.add((Constant)element);
                    } else {
                        element.acceptChildren((PsiElementVisitor)this);
                    }
                }
            });
            return constants;
        }
        assert (false);
        return Collections.emptySet();
    }

    @Override
    public PhpIntroduceConstantSettings getSettings() {
        return (PhpIntroduceConstantSettings)((Object)this.myDisplay);
    }

    @Override
    protected void initDisplay() {
        PsiElement scope = this.myIntroduceContext.getScope();
        boolean allowConstSyntax = scope instanceof PhpFile ? PhpCodeValidationUtil.isAllowedAsConstantValue(this.myIntroduceContext.getLogicalElement()) : false;
        ((PhpIntroduceConstantDisplay)this.myDisplay).setData(this.myIntroduceContext.getOccurrencesCount(), new PhpIntroduceConstantNameSuggestionProvider(this.myIntroduceContext, this.myOccupiedNames).getSuggestedNames(), this, scope, allowConstSyntax);
    }

    @Override
    @NotNull
    public Pair<Boolean, String> validate(PhpIntroduceConstantDisplay display) {
        String name = display.getName();
        if (!PhpLangUtil.isPhpIdentifier(name)) {
            Pair pair = new Pair((Object)false, (Object)PhpBundle.message("refactoring.extract.base.validator.not.valid.identifier", name));
            if (pair == null) {
                PhpIntroduceConstantPresenter.$$$reportNull$$$0(0);
            }
            return pair;
        }
        if (PhpLangUtil.isPhpReservedKeyword(name)) {
            Pair pair = new Pair((Object)false, (Object)PhpBundle.message("refactoring.extract.base.validator.reserved.keyword", name));
            if (pair == null) {
                PhpIntroduceConstantPresenter.$$$reportNull$$$0(1);
            }
            return pair;
        }
        if (this.myOccupiedNames.contains(name)) {
            Pair pair = new Pair((Object)true, (Object)PhpBundle.message("refactoring.extract.constant.conflict.already.exists", name));
            if (pair == null) {
                PhpIntroduceConstantPresenter.$$$reportNull$$$0(2);
            }
            return pair;
        }
        Pair constantInBaseClass = PhpIntroduceConstantPresenter.checkConstantInBaseClasses(display, name);
        Pair pair = constantInBaseClass != null ? constantInBaseClass : EVERYTHING_IS_OK;
        if (pair == null) {
            PhpIntroduceConstantPresenter.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @Nullable
    private static Pair<Boolean, String> checkConstantInBaseClasses(PhpIntroduceConstantDisplay display, String name) {
        PhpClass classz = (PhpClass)ObjectUtils.tryCast((Object)display.getScope(), PhpClass.class);
        if (classz == null) {
            return null;
        }
        Ref baseConstantExists = new Ref((Object)false);
        Ref isBaseInterface = new Ref((Object)false);
        Ref baseConstantHasStricterAccess = new Ref((Object)false);
        Ref baseClassName = new Ref();
        Ref baseAccess = new Ref();
        PhpClassHierarchyUtils.processFields((PhpClass)classz, (PhpClass)classz, (field, subClass, baseClass) -> {
            if (subClass == classz) {
                return true;
            }
            if (field == null || !field.isConstant() || !field.getName().equals(name)) {
                return true;
            }
            PhpModifier.Access access = field.getModifier().getAccess();
            if (access.isPrivate()) {
                return true;
            }
            if (!((Boolean)baseConstantExists.get()).booleanValue()) {
                baseConstantExists.set((Object)true);
                baseClassName.set((Object)subClass.getName());
                if (subClass.isInterface()) {
                    isBaseInterface.set((Object)true);
                    return false;
                }
            }
            if (access.isWeakerThan((PhpModifier.Access)MoreObjects.firstNonNull((Object)display.getAccess(), (Object)PhpModifier.Access.PUBLIC))) {
                baseConstantHasStricterAccess.set((Object)true);
                baseAccess.set((Object)access);
                return false;
            }
            return true;
        }, (boolean)false);
        if (!((Boolean)baseConstantExists.get()).booleanValue()) {
            return null;
        }
        return new Pair((Object)true, (Object)PhpIntroduceConstantPresenter.getMessage(name, (Boolean)baseConstantHasStricterAccess.get(), (Boolean)isBaseInterface.get(), (String)baseClassName.get(), (PhpModifier.Access)baseAccess.get()));
    }

    @NotNull
    private static String getMessage(String constantName, Boolean baseConstantHasStricterAccess, Boolean isBaseInterface, String baseClassName, PhpModifier.Access baseAccess) {
        if (isBaseInterface.booleanValue()) {
            String string = PhpBundle.message("refactoring.extract.constant.conflict.cannot.override.interface.constant", constantName, baseClassName);
            if (string == null) {
                PhpIntroduceConstantPresenter.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (baseConstantHasStricterAccess.booleanValue()) {
            String string = PhpBundle.message("refactoring.extract.constant.conflict.exists.in.subclass.with.weaker.access", constantName, baseAccess.toString(), baseClassName);
            if (string == null) {
                PhpIntroduceConstantPresenter.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = PhpBundle.message("refactoring.extract.constant.conflict.exists.in.subclass", baseClassName, constantName);
        if (string == null) {
            PhpIntroduceConstantPresenter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public void collectConflicts(MultiMap<PsiElement, String> conflicts) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/refactoring/introduce/introduceConstant/PhpIntroduceConstantPresenter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

