/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.rewriter.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.rewriter.FormatHelper;
import org.jrubyparser.rewriter.utils.BooleanStateStack;
import org.jrubyparser.rewriter.utils.CallDepth;
import org.jrubyparser.rewriter.utils.HereDocument;
import org.jrubyparser.rewriter.utils.Indenter;
import org.jrubyparser.rewriter.utils.LocalVariables;

public class ReWriterContext {
    private final String source;
    private final CallDepth callDepth = new CallDepth();
    private final LocalVariables localVariables = new LocalVariables();
    private final BooleanStateStack printQuotesInString = new BooleanStateStack(true, true);
    private HereDocument hereDocument;
    private boolean skipNextNewline = true;
    private PrintWriter output;
    private FormatHelper formatHelper;
    private SourcePosition lastPosition;

    public LocalVariables getLocalVariables() {
        return this.localVariables;
    }

    public ReWriterContext(PrintWriter output, String source, FormatHelper formatHelper) {
        this.output = output;
        this.source = source;
        this.formatHelper = formatHelper;
    }

    public ReWriterContext(StringWriter output, String source, FormatHelper formatHelper) {
        this(new PrintWriter(output), source, formatHelper);
    }

    public CallDepth getCallDepth() {
        return this.callDepth;
    }

    public String getSource() {
        return this.source;
    }

    public Indenter getIndentor() {
        return this.formatHelper.getIndenter();
    }

    public SourcePosition getLastPosition() {
        return this.lastPosition;
    }

    public void setLastPosition(SourcePosition lastPosition) {
        this.lastPosition = lastPosition;
    }

    public BooleanStateStack getPrintQuotesInString() {
        return this.printQuotesInString;
    }

    public boolean hasHereDocument() {
        return this.hereDocument != null;
    }

    public HereDocument fetchHereDocument() {
        HereDocument hd = this.hereDocument;
        this.hereDocument = null;
        return hd;
    }

    public void depositHereDocument(String hereDocument) {
        this.hereDocument = new HereDocument(hereDocument, this);
    }

    public boolean isSkipNextNewline() {
        return this.skipNextNewline;
    }

    public void setSkipNextNewline(boolean skipNextNewline) {
        this.skipNextNewline = skipNextNewline;
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public void setOutput(PrintWriter output) {
        this.output = output;
    }

    public FormatHelper getFormatHelper() {
        return this.formatHelper;
    }
}

