/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.psi.impl;

import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.ws.http.request.environment.HttpRequestEnvironment;
import com.intellij.ws.http.request.environment.HttpRequestEnvironmentIndex;
import com.intellij.ws.http.request.environment.HttpRequestEnvironmentInputFilter;
import com.intellij.ws.http.request.environment.HttpRequestIndex;
import com.intellij.ws.http.request.psi.HttpVariableBase;
import com.intellij.ws.http.request.psi.impl.HttpRequestNamedElementImpl;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpVariableBaseImpl
extends HttpRequestNamedElementImpl
implements HttpVariableBase {
    public HttpVariableBaseImpl(@NotNull ASTNode node) {
        if (node == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @NotNull
    public PsiElement getElement() {
        HttpVariableBaseImpl httpVariableBaseImpl = this;
        if (httpVariableBaseImpl == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(1);
        }
        return httpVariableBaseImpl;
    }

    @NotNull
    public TextRange getRangeInElement() {
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            int startOffset = identifier.getTextRange().getStartOffset() - this.getTextRange().getStartOffset();
            TextRange textRange = new TextRange(startOffset, startOffset + identifier.getTextLength());
            if (textRange == null) {
                HttpVariableBaseImpl.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        TextRange textRange = new TextRange(0, this.getTextLength());
        if (textRange == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length > 0 ? resolveResults[0].getElement() : null;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = HttpVariableBaseImpl.getResolveResults(this.getProject(), this.getContainingFile(), this.getName());
        if (resolveResultArray == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    @NotNull
    public static ResolveResult[] getResolveResults(@NotNull Project project, PsiFile containingFile, String name) {
        if (project == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)name)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                HttpVariableBaseImpl.$$$reportNull$$$0(6);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        GlobalSearchScope scope = HttpRequestIndex.getSearchScope(project, containingFile);
        ArrayList result = ContainerUtil.newArrayList();
        String defaultEnv = HttpRequestEnvironment.getDefaultEnvName(project);
        if (StringUtil.isNotEmpty((String)defaultEnv)) {
            HttpVariableBaseImpl.addVariableDefinitions(project, name, defaultEnv, result, scope);
        }
        for (String env : FileBasedIndex.getInstance().getAllKeys(HttpRequestEnvironmentIndex.KEY, project)) {
            if (StringUtil.equals((CharSequence)env, (CharSequence)defaultEnv)) continue;
            HttpVariableBaseImpl.addVariableDefinitions(project, name, env, result, scope);
        }
        ResolveResult[] resolveResultArray = !result.isEmpty() ? result.toArray(ResolveResult.EMPTY_ARRAY) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    public static void addVariableDefinitions(@NotNull Project project, @NotNull String name, @NotNull String env, @NotNull Collection<? super ResolveResult> result, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(8);
        }
        if (name == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(9);
        }
        if (env == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(10);
        }
        if (result == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(12);
        }
        FileBasedIndex.getInstance().processValues(HttpRequestEnvironmentIndex.KEY, (Object)env, null, (file, value) -> {
            if (name == null) {
                HttpVariableBaseImpl.$$$reportNull$$$0(17);
            }
            if (project == null) {
                HttpVariableBaseImpl.$$$reportNull$$$0(18);
            }
            if (env == null) {
                HttpVariableBaseImpl.$$$reportNull$$$0(19);
            }
            if (result == null) {
                HttpVariableBaseImpl.$$$reportNull$$$0(20);
            }
            if (value.contains(name)) {
                JsonProperty property;
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (!(psiFile instanceof JsonFile)) {
                    return true;
                }
                JsonValue root = ((JsonFile)psiFile).getTopLevelValue();
                JsonObject environment = root instanceof JsonObject ? (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)((JsonObject)root), (String)env, JsonObject.class) : null;
                JsonProperty jsonProperty = property = environment != null ? environment.findProperty(name) : null;
                if (property != null) {
                    result.add((ResolveResult)new PsiElementResolveResult((PsiElement)property));
                }
            }
            return true;
        }, scope);
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(14);
        }
        return this.setName(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException("Method bindToElement is not implemented in " + this.getClass().getName());
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(16);
        }
        if (element instanceof JsonProperty && StringUtil.equals((CharSequence)((JsonProperty)element).getName(), (CharSequence)this.getName()) && element.isValid() && element.isPhysical()) {
            PsiFile file = element.getContainingFile();
            return file != null && HttpRequestEnvironmentInputFilter.isHttpRequestEnvFile(file.getVirtualFile());
        }
        return false;
    }

    public PsiReference getReference() {
        if (this.getNameIdentifier() != null) {
            return this;
        }
        return null;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/psi/impl/HttpVariableBaseImpl";
                break;
            }
            case 5: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/psi/impl/HttpVariableBaseImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResults";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResolveResults";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addVariableDefinitions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addVariableDefinitions$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

