/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.comparator;

import com.jidesoft.comparator.ComparatorContext;
import java.io.File;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphanumFileComparator
implements Comparator<File> {
    private boolean _caseSensitive;
    public static final ComparatorContext CONTEXT = new ComparatorContext("Alphanum");
    public static final ComparatorContext CONTEXT_IGNORE_CASE = new ComparatorContext("Alphanum_Ignorecase");

    public AlphanumFileComparator() {
        this(true);
    }

    public AlphanumFileComparator(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private String getChunk(CharSequence s2, int slength, int marker) {
        StringBuilder chunk = new StringBuilder();
        char c = s2.charAt(marker);
        chunk.append(c);
        ++marker;
        if (this.isDigit(c)) {
            while (marker < slength && this.isDigit(c = s2.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        } else {
            while (marker < slength && !this.isDigit(c = s2.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        }
        return chunk.toString();
    }

    @Override
    public int compare(File f1, File f2) {
        int thisMarker = 0;
        int thatMarker = 0;
        String s1 = f1.getName();
        String s2 = f2.getName();
        int s1Length = s1.length();
        int s2Length = s2.length();
        while (thisMarker < s1Length && thatMarker < s2Length) {
            int result;
            String thisChunk = this.getChunk(s1, s1Length, thisMarker);
            thisMarker += thisChunk.length();
            String thatChunk = this.getChunk(s2, s2Length, thatMarker);
            thatMarker += thatChunk.length();
            if (this.isDigit(thisChunk.charAt(0)) && this.isDigit(thatChunk.charAt(0))) {
                int thisChunkLength = thisChunk.length();
                result = thisChunkLength - thatChunk.length();
                if (result == 0) {
                    for (int i = 0; i < thisChunkLength; ++i) {
                        result = thisChunk.charAt(i) - thatChunk.charAt(i);
                        if (result == 0) continue;
                        return result;
                    }
                }
            } else {
                int n = result = this.isCaseSensitive() ? thisChunk.compareTo(thatChunk) : thisChunk.compareToIgnoreCase(thatChunk);
            }
            if (result == 0) continue;
            return result;
        }
        return s1Length - s2Length;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }
}

