/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.ListUI;

public class BasicListUI
extends ListUI {
    protected static final int modelChanged = 1;
    protected static final int selectionModelChanged = 2;
    protected static final int fontChanged = 4;
    protected static final int fixedCellWidthChanged = 8;
    protected static final int fixedCellHeightChanged = 16;
    protected static final int prototypeCellValueChanged = 32;
    protected static final int cellRendererChanged = 64;
    protected FocusListener focusListener;
    protected ListDataListener listDataListener;
    protected ListSelectionListener listSelectionListener;
    protected MouseInputListener mouseInputListener;
    protected PropertyChangeListener propertyChangeListener;
    private ComponentListener componentListener;
    protected JList list;
    protected int cellHeight;
    protected int cellWidth;
    protected int[] cellHeights;
    protected int updateLayoutStateNeeded = 1;
    protected CellRendererPane rendererPane = new CellRendererPane();
    ListAction action;

    public static ComponentUI createUI(JComponent c) {
        return new BasicListUI();
    }

    protected int getRowHeight(int row) {
        if (row < 0 || row >= this.cellHeights.length) {
            return -1;
        }
        if (this.cellHeight != -1) {
            return this.cellHeight;
        }
        return this.cellHeights[row];
    }

    public Rectangle getCellBounds(JList l, int index1, int index2) {
        this.maybeUpdateLayoutState();
        if (l != this.list || this.cellWidth == -1) {
            return null;
        }
        int minIndex = Math.min(index1, index2);
        int maxIndex = Math.max(index1, index2);
        Point loc = this.indexToLocation(this.list, minIndex);
        Rectangle bounds = new Rectangle(loc.x, loc.y, this.cellWidth, this.getRowHeight(minIndex));
        int i = minIndex + 1;
        while (i <= maxIndex) {
            Point hiLoc = this.indexToLocation(this.list, i);
            Rectangle hibounds = new Rectangle(hiLoc.x, hiLoc.y, this.cellWidth, this.getRowHeight(i));
            bounds = bounds.union(hibounds);
            ++i;
        }
        return bounds;
    }

    protected int convertRowToY(int row) {
        int y = 0;
        int i = 0;
        while (i < row) {
            int h = this.getRowHeight(i);
            if (h == -1) {
                return -1;
            }
            y += h;
            ++i;
        }
        return y;
    }

    protected int convertYToRow(int y0) {
        int row = 0;
        while (row < this.cellHeights.length) {
            int h = this.getRowHeight(row);
            if (y0 < h) {
                return row;
            }
            y0 -= h;
            ++row;
        }
        return -1;
    }

    protected void updateLayoutState() {
        int nrows = this.list.getModel().getSize();
        this.cellHeight = -1;
        this.cellWidth = -1;
        if (this.cellHeights == null || this.cellHeights.length != nrows) {
            this.cellHeights = new int[nrows];
        }
        if (this.list.getFixedCellHeight() == -1 || this.list.getFixedCellWidth() == -1) {
            ListCellRenderer rend = this.list.getCellRenderer();
            int i = 0;
            while (i < nrows) {
                Component flyweight = rend.getListCellRendererComponent(this.list, this.list.getModel().getElementAt(i), 0, false, false);
                Dimension dim = flyweight.getPreferredSize();
                this.cellHeights[i] = dim.height;
                this.cellHeight = (this.cellHeight * i + this.cellHeights[i]) / (i + 1);
                this.cellWidth = Math.max(this.cellWidth, dim.width);
                if (this.list.getLayoutOrientation() == 0) {
                    this.cellWidth = Math.max(this.cellWidth, this.list.getSize().width);
                }
                ++i;
            }
        } else {
            this.cellHeight = this.list.getFixedCellHeight();
            this.cellWidth = this.list.getFixedCellWidth();
        }
    }

    void damageLayout() {
        this.updateLayoutStateNeeded = 1;
    }

    protected void maybeUpdateLayoutState() {
        if (this.updateLayoutStateNeeded != 0) {
            this.updateLayoutState();
            this.updateLayoutStateNeeded = 0;
        }
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.list, "List.background", "List.foreground", "List.font");
        this.list.setSelectionForeground(UIManager.getColor("List.selectionForeground"));
        this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
        this.list.setOpaque(true);
    }

    protected void uninstallDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.list.setForeground(null);
        this.list.setBackground(null);
        this.list.setSelectionForeground(null);
        this.list.setSelectionBackground(null);
    }

    protected void installListeners() {
        if (this.focusListener == null) {
            this.focusListener = this.createFocusListener();
        }
        this.list.addFocusListener(this.focusListener);
        if (this.listDataListener == null) {
            this.listDataListener = this.createListDataListener();
        }
        this.list.getModel().addListDataListener(this.listDataListener);
        if (this.listSelectionListener == null) {
            this.listSelectionListener = this.createListSelectionListener();
        }
        this.list.addListSelectionListener(this.listSelectionListener);
        if (this.mouseInputListener == null) {
            this.mouseInputListener = this.createMouseInputListener();
        }
        this.list.addMouseListener(this.mouseInputListener);
        this.list.addMouseMotionListener(this.mouseInputListener);
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener();
        }
        this.list.addPropertyChangeListener(this.propertyChangeListener);
        this.list.addComponentListener(this.componentListener);
        this.componentListener = new ComponentHandler();
    }

    protected void uninstallListeners() {
        this.list.removeFocusListener(this.focusListener);
        this.list.getModel().removeListDataListener(this.listDataListener);
        this.list.removeListSelectionListener(this.listSelectionListener);
        this.list.removeMouseListener(this.mouseInputListener);
        this.list.removeMouseMotionListener(this.mouseInputListener);
        this.list.removePropertyChangeListener(this.propertyChangeListener);
    }

    protected void installKeyboardActions() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        InputMap focusInputMap = (InputMap)defaults.get("List.focusInputMap");
        InputMapUIResource parentInputMap = new InputMapUIResource();
        ActionMap parentActionMap = new ActionMap();
        this.action = new ListAction();
        KeyStroke[] keys = focusInputMap.allKeys();
        int i = 0;
        while (i < keys.length) {
            KeyStroke stroke = keys[i];
            String actionString = (String)focusInputMap.get(stroke);
            parentInputMap.put(KeyStroke.getKeyStroke(stroke.getKeyCode(), stroke.getModifiers()), actionString);
            parentActionMap.put(actionString, new ActionListenerProxy(this.action, actionString));
            ++i;
        }
        parentInputMap.setParent(this.list.getInputMap().getParent());
        parentActionMap.setParent(this.list.getActionMap().getParent());
        this.list.getInputMap().setParent(parentInputMap);
        this.list.getActionMap().setParent(parentActionMap);
    }

    protected void uninstallKeyboardActions() {
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.list = (JList)c;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.maybeUpdateLayoutState();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.list = null;
    }

    public Dimension getPreferredSize(JComponent c) {
        int size = this.list.getModel().getSize();
        if (size == 0) {
            return new Dimension(0, 0);
        }
        int visibleRows = this.list.getVisibleRowCount();
        int layoutOrientation = this.list.getLayoutOrientation();
        Rectangle bounds = this.getCellBounds(this.list, 0, this.list.getModel().getSize() - 1);
        Dimension retVal = bounds.getSize();
        Container parent = this.list.getParent();
        if (visibleRows == -1 && parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            if (layoutOrientation == 2) {
                int h = viewport.getSize().height;
                int cellsPerCol = h / this.cellHeight;
                int w = size / cellsPerCol * this.cellWidth;
                retVal = new Dimension(w, h);
            } else if (layoutOrientation == 1) {
                int w = viewport.getSize().width;
                int cellsPerRow = Math.max(w / this.cellWidth, 1);
                int h = size / cellsPerRow * this.cellHeight;
                retVal = new Dimension(w, h);
            }
        }
        return retVal;
    }

    private final void paintBackground(Graphics g, JComponent c) {
        Dimension size = this.getPreferredSize(c);
        Color save = g.getColor();
        g.setColor(c.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(save);
    }

    protected void paintCell(Graphics g, int row, Rectangle bounds, ListCellRenderer rend, ListModel data, ListSelectionModel sel, int lead) {
        boolean isSel = this.list.isSelectedIndex(row);
        boolean bl = false;
        if (this.list.getLeadSelectionIndex() == row && this.list.hasFocus()) {
            bl = true;
        }
        boolean hasFocus = bl;
        Component comp = rend.getListCellRendererComponent(this.list, data.getElementAt(row), 0, isSel, hasFocus);
        this.rendererPane.paintComponent(g, comp, this.list, bounds);
    }

    public void paint(Graphics g, JComponent c) {
        int nrows = this.list.getModel().getSize();
        if (nrows == 0) {
            return;
        }
        this.maybeUpdateLayoutState();
        ListCellRenderer render = this.list.getCellRenderer();
        ListModel model = this.list.getModel();
        ListSelectionModel sel = this.list.getSelectionModel();
        int lead = sel.getLeadSelectionIndex();
        Rectangle clip = g.getClipBounds();
        this.paintBackground(g, this.list);
        int row = 0;
        while (row < nrows) {
            Rectangle bounds = this.getCellBounds(this.list, row, row);
            if (bounds.intersects(clip)) {
                this.paintCell(g, row, bounds, render, model, sel, lead);
            }
            ++row;
        }
    }

    public int locationToIndex(JList list2, Point location) {
        int layoutOrientation = list2.getLayoutOrientation();
        int index = -1;
        switch (layoutOrientation) {
            case 0: {
                index = this.convertYToRow(location.y);
                break;
            }
            case 2: {
                int visibleRows = list2.getVisibleRowCount();
                int cellsPerRow = -1;
                int numberOfItems = list2.getModel().getSize();
                Dimension listDim = list2.getSize();
                if (visibleRows <= 0) {
                    try {
                        cellsPerRow = listDim.width / this.cellWidth;
                    }
                    catch (ArithmeticException ex) {
                        cellsPerRow = 1;
                    }
                } else {
                    cellsPerRow = numberOfItems / visibleRows + 1;
                }
                int cellsPerColumn = numberOfItems / cellsPerRow + 1;
                int gridX = Math.min(location.x / this.cellWidth, cellsPerRow - 1);
                int gridY = Math.min(location.y / this.cellHeight, cellsPerColumn);
                index = gridX + gridY * cellsPerRow;
                break;
            }
            case 1: {
                int visibleRows2 = list2.getVisibleRowCount();
                if (visibleRows2 <= 0) {
                    Dimension listDim2 = list2.getSize();
                    visibleRows2 = listDim2.height / this.cellHeight;
                }
                int numberOfItems2 = list2.getModel().getSize();
                int cellsPerRow2 = numberOfItems2 / visibleRows2 + 1;
                Dimension listDim2 = list2.getSize();
                int gridX2 = Math.min(location.x / this.cellWidth, cellsPerRow2 - 1);
                int gridY2 = Math.min(location.y / this.cellHeight, visibleRows2);
                index = gridY2 + gridX2 * visibleRows2;
                break;
            }
        }
        return index;
    }

    public Point indexToLocation(JList list2, int index) {
        int layoutOrientation = list2.getLayoutOrientation();
        Point loc = null;
        switch (layoutOrientation) {
            case 0: {
                loc = new Point(0, this.convertRowToY(index));
                break;
            }
            case 2: {
                int visibleRows = list2.getVisibleRowCount();
                int numberOfCellsPerRow = -1;
                if (visibleRows <= 0) {
                    Dimension listDim = list2.getSize();
                    numberOfCellsPerRow = Math.max(listDim.width / this.cellWidth, 1);
                } else {
                    int numberOfItems = list2.getModel().getSize();
                    numberOfCellsPerRow = numberOfItems / visibleRows + 1;
                }
                int gridX = index % numberOfCellsPerRow;
                int gridY = index / numberOfCellsPerRow;
                int locX = gridX * this.cellWidth;
                int locY = gridY * this.cellHeight;
                loc = new Point(locX, locY);
                break;
            }
            case 1: {
                int visibleRows2 = list2.getVisibleRowCount();
                if (visibleRows2 <= 0) {
                    Dimension listDim2 = list2.getSize();
                    visibleRows2 = listDim2.height / this.cellHeight;
                }
                if (visibleRows2 > 0) {
                    int gridY2 = index % visibleRows2;
                    int gridX2 = index / visibleRows2;
                    int locX2 = gridX2 * this.cellWidth;
                    int locY2 = gridY2 * this.cellHeight;
                    loc = new Point(locX2, locY2);
                    break;
                }
                loc = new Point(0, this.convertRowToY(index));
                break;
            }
        }
        return loc;
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void selectNextIndex() {
        int index = this.list.getSelectionModel().getLeadSelectionIndex();
        if (index < this.list.getModel().getSize() - 1) {
            this.list.setSelectedIndex(++index);
        }
        this.list.ensureIndexIsVisible(index);
    }

    protected void selectPreviousIndex() {
        int index = this.list.getSelectionModel().getLeadSelectionIndex();
        if (index > 0) {
            this.list.setSelectedIndex(--index);
        }
        this.list.ensureIndexIsVisible(index);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ComponentHandler
    extends ComponentAdapter {
        public void componentResized(ComponentEvent ev) {
            BasicListUI.this.damageLayout();
        }

        private ComponentHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ListAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            int lead = BasicListUI.this.list.getLeadSelectionIndex();
            int max = BasicListUI.this.list.getModel().getSize() - 1;
            DefaultListSelectionModel selModel = (DefaultListSelectionModel)BasicListUI.this.list.getSelectionModel();
            String command = e.getActionCommand();
            if (max == -1) {
                return;
            }
            if (command.equals("selectNextRow")) {
                BasicListUI.this.selectNextIndex();
            } else if (command.equals("selectPreviousRow")) {
                BasicListUI.this.selectPreviousIndex();
            } else if (command.equals("clearSelection")) {
                BasicListUI.this.list.clearSelection();
            } else if (command.equals("selectAll")) {
                BasicListUI.this.list.setSelectionInterval(0, max);
                BasicListUI.this.list.addSelectionInterval(lead, lead);
            } else if (command.equals("selectLastRow")) {
                BasicListUI.this.list.setSelectedIndex(BasicListUI.this.list.getModel().getSize() - 1);
            } else if (command.equals("selectLastRowChangeLead")) {
                selModel.moveLeadSelectionIndex(BasicListUI.this.list.getModel().getSize() - 1);
            } else if (command.equals("scrollDownExtendSelection")) {
                int target = lead == BasicListUI.this.list.getLastVisibleIndex() ? Math.min(max, lead + (BasicListUI.this.list.getLastVisibleIndex() - BasicListUI.this.list.getFirstVisibleIndex() + 1)) : BasicListUI.this.list.getLastVisibleIndex();
                selModel.setLeadSelectionIndex(target);
            } else if (command.equals("scrollDownChangeLead")) {
                int target = lead == BasicListUI.this.list.getLastVisibleIndex() ? Math.min(max, lead + (BasicListUI.this.list.getLastVisibleIndex() - BasicListUI.this.list.getFirstVisibleIndex() + 1)) : BasicListUI.this.list.getLastVisibleIndex();
                selModel.moveLeadSelectionIndex(target);
            } else if (command.equals("scrollUpExtendSelection")) {
                int target = lead == BasicListUI.this.list.getFirstVisibleIndex() ? Math.max(0, lead - (BasicListUI.this.list.getLastVisibleIndex() - BasicListUI.this.list.getFirstVisibleIndex() + 1)) : BasicListUI.this.list.getFirstVisibleIndex();
                selModel.setLeadSelectionIndex(target);
            } else if (command.equals("scrollUpChangeLead")) {
                int target = lead == BasicListUI.this.list.getFirstVisibleIndex() ? Math.max(0, lead - (BasicListUI.this.list.getLastVisibleIndex() - BasicListUI.this.list.getFirstVisibleIndex() + 1)) : BasicListUI.this.list.getFirstVisibleIndex();
                selModel.moveLeadSelectionIndex(target);
            } else if (command.equals("selectNextRowExtendSelection")) {
                selModel.setLeadSelectionIndex(Math.min(lead + 1, max));
            } else if (command.equals("selectFirstRow")) {
                BasicListUI.this.list.setSelectedIndex(0);
            } else if (command.equals("selectFirstRowChangeLead")) {
                selModel.moveLeadSelectionIndex(0);
            } else if (command.equals("selectFirstRowExtendSelection")) {
                selModel.setLeadSelectionIndex(0);
            } else if (command.equals("selectPreviousRowExtendSelection")) {
                selModel.setLeadSelectionIndex(Math.max(0, lead - 1));
            } else if (command.equals("scrollUp")) {
                int target = lead == BasicListUI.this.list.getFirstVisibleIndex() ? Math.max(0, lead - (BasicListUI.this.list.getLastVisibleIndex() - BasicListUI.this.list.getFirstVisibleIndex() + 1)) : BasicListUI.this.list.getFirstVisibleIndex();
                BasicListUI.this.list.setSelectedIndex(target);
            } else if (command.equals("selectLastRowExtendSelection")) {
                selModel.setLeadSelectionIndex(BasicListUI.this.list.getModel().getSize() - 1);
            } else if (command.equals("scrollDown")) {
                int target = lead == BasicListUI.this.list.getLastVisibleIndex() ? Math.min(max, lead + (BasicListUI.this.list.getLastVisibleIndex() - BasicListUI.this.list.getFirstVisibleIndex() + 1)) : BasicListUI.this.list.getLastVisibleIndex();
                BasicListUI.this.list.setSelectedIndex(target);
            } else if (command.equals("selectNextRowChangeLead")) {
                if (selModel.getSelectionMode() != 2) {
                    BasicListUI.this.selectNextIndex();
                } else {
                    selModel.moveLeadSelectionIndex(Math.min(max, lead + 1));
                }
            } else if (command.equals("selectPreviousRowChangeLead")) {
                if (selModel.getSelectionMode() != 2) {
                    BasicListUI.this.selectPreviousIndex();
                } else {
                    selModel.moveLeadSelectionIndex(Math.max(0, lead - 1));
                }
            } else if (command.equals("addToSelection")) {
                BasicListUI.this.list.addSelectionInterval(lead, lead);
            } else if (command.equals("extendTo")) {
                selModel.setSelectionInterval(selModel.getAnchorSelectionIndex(), lead);
            } else if (command.equals("toggleAndAnchor")) {
                if (!BasicListUI.this.list.isSelectedIndex(lead)) {
                    BasicListUI.this.list.addSelectionInterval(lead, lead);
                } else {
                    BasicListUI.this.list.removeSelectionInterval(lead, lead);
                }
                selModel.setAnchorSelectionIndex(lead);
            }
            BasicListUI.this.list.ensureIndexIsVisible(BasicListUI.this.list.getLeadSelectionIndex());
        }

        ListAction() {
        }
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public void actionPerformed(ActionEvent e) {
            ActionEvent derivedEvent = new ActionEvent(e.getSource(), e.getID(), this.bindingCommandName, e.getModifiers());
            this.target.actionPerformed(derivedEvent);
        }

        public ActionListenerProxy(ActionListener li, String cmd) {
            this.target = li;
            this.bindingCommandName = cmd;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            this.repaintCellFocus();
        }

        public void focusLost(FocusEvent e) {
            this.repaintCellFocus();
        }

        protected void repaintCellFocus() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ListDataHandler
    implements ListDataListener {
        public void contentsChanged(ListDataEvent e) {
            BasicListUI.this.damageLayout();
        }

        public void intervalAdded(ListDataEvent e) {
            BasicListUI.this.damageLayout();
        }

        public void intervalRemoved(ListDataEvent e) {
            BasicListUI.this.damageLayout();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ListSelectionHandler
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MouseInputHandler
    implements MouseInputListener {
        public void mouseClicked(MouseEvent event) {
            Point click = event.getPoint();
            int index = BasicListUI.this.locationToIndex(BasicListUI.this.list, click);
            if (index == -1) {
                return;
            }
            if (event.isShiftDown()) {
                if (BasicListUI.this.list.getSelectionMode() == 0) {
                    BasicListUI.this.list.setSelectedIndex(index);
                } else if (BasicListUI.this.list.getSelectionMode() == 1) {
                    BasicListUI.this.list.setSelectionInterval(BasicListUI.this.list.getAnchorSelectionIndex(), index);
                } else if (BasicListUI.this.list.isSelectedIndex(BasicListUI.this.list.getAnchorSelectionIndex())) {
                    BasicListUI.this.list.getSelectionModel().setLeadSelectionIndex(index);
                } else {
                    BasicListUI.this.list.addSelectionInterval(BasicListUI.this.list.getAnchorSelectionIndex(), index);
                }
            } else if (event.isControlDown()) {
                if (BasicListUI.this.list.getSelectionMode() == 0) {
                    BasicListUI.this.list.setSelectedIndex(index);
                } else if (BasicListUI.this.list.isSelectedIndex(index)) {
                    BasicListUI.this.list.removeSelectionInterval(index, index);
                } else {
                    BasicListUI.this.list.addSelectionInterval(index, index);
                }
            } else {
                BasicListUI.this.list.setSelectedIndex(index);
            }
            BasicListUI.this.list.ensureIndexIsVisible(BasicListUI.this.list.getLeadSelectionIndex());
        }

        public void mousePressed(MouseEvent event) {
        }

        public void mouseReleased(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mouseDragged(MouseEvent event) {
        }

        public void mouseMoved(MouseEvent event) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == BasicListUI.this.list) {
                if (e.getOldValue() != null && e.getOldValue() instanceof ListModel) {
                    ((ListModel)e.getOldValue()).removeListDataListener(BasicListUI.this.listDataListener);
                }
                if (e.getNewValue() != null && e.getNewValue() instanceof ListModel) {
                    ((ListModel)e.getNewValue()).addListDataListener(BasicListUI.this.listDataListener);
                }
            }
            if (e.getPropertyName().equals("model")) {
                ++BasicListUI.this.updateLayoutStateNeeded;
            } else if (e.getPropertyName().equals("selectionModel")) {
                BasicListUI.this.updateLayoutStateNeeded += 2;
            } else if (e.getPropertyName().equals("font")) {
                BasicListUI.this.updateLayoutStateNeeded += 4;
            } else if (e.getPropertyName().equals("fixedCellWidth")) {
                BasicListUI.this.updateLayoutStateNeeded += 8;
            } else if (e.getPropertyName().equals("fixedCellHeight")) {
                BasicListUI.this.updateLayoutStateNeeded += 16;
            } else if (e.getPropertyName().equals("prototypeCellValue")) {
                BasicListUI.this.updateLayoutStateNeeded += 32;
            } else if (e.getPropertyName().equals("cellRenderer")) {
                BasicListUI.this.updateLayoutStateNeeded += 64;
            }
            BasicListUI.this.damageLayout();
        }
    }
}

