/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public class IndexOf
extends CollatingFunction
implements Callable {
    protected int getCollationArgument() {
        return 2;
    }

    public IntegerValue[] getIntegerBounds() {
        return new IntegerValue[]{Int64Value.PLUS_ONE, MAX_SEQUENCE_LENGTH};
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType type0 = this.argument[0].getItemType(th);
        ItemType type1 = this.argument[1].getItemType(th);
        if (type0 instanceof AtomicType && type1 instanceof AtomicType) {
            this.preAllocateComparer((AtomicType)type0, (AtomicType)type1, visitor.getStaticContext(), false);
        }
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        AtomicComparer comparer = this.getPreAllocatedAtomicComparer();
        if (comparer == null) {
            comparer = this.getAtomicComparer(this.getCollator(context), context);
        }
        SequenceIterator<? extends Item> seq = this.argument[0].iterate(context);
        AtomicValue val = (AtomicValue)this.argument[1].evaluateItem(context);
        return new IndexIterator(seq, val, comparer);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringCollator collator = this.getCollatorFromLastArgument(arguments, 2, context);
        GenericAtomicComparer comparer = new GenericAtomicComparer(collator, context);
        SequenceIterator<? extends Item> seq = arguments[0].iterate();
        AtomicValue val = (AtomicValue)arguments[1].head();
        return SequenceTool.toLazySequence(new IndexIterator(seq, val, comparer));
    }

    public static class IndexIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private AtomicValue value;
        private AtomicComparer comparer;
        private int index = 0;
        private int position = 0;
        private Item current = null;
        private BuiltInAtomicType primitiveTypeRequired;

        public IndexIterator(SequenceIterator base, AtomicValue value, AtomicComparer comparer) {
            this.base = base;
            this.value = value;
            this.comparer = comparer;
            this.primitiveTypeRequired = value.getPrimitiveType();
        }

        public Item next() throws XPathException {
            AtomicValue i;
            while ((i = (AtomicValue)this.base.next()) != null) {
                ++this.index;
                if (!Type.isGuaranteedComparable(this.primitiveTypeRequired, i.getPrimitiveType(), false)) continue;
                try {
                    if (!this.comparer.comparesEqual(i, this.value)) continue;
                    this.current = Int64Value.makeIntegerValue(this.index);
                    ++this.position;
                    return this.current;
                }
                catch (ClassCastException classCastException) {
                }
            }
            this.current = null;
            this.position = -1;
            return null;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public void close() {
            this.base.close();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new IndexIterator(this.base.getAnother(), this.value, this.comparer);
        }

        public int getProperties() {
            return 0;
        }
    }
}

