/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public final class XSLForEachGroup
extends StyleElement {
    private Expression select = null;
    private Expression groupBy = null;
    private Expression groupAdjacent = null;
    private Pattern starting = null;
    private Pattern ending = null;
    private Expression collationName;
    private SourceBinding groupSourceBinding = null;
    private SourceBinding keySourceBinding = null;
    private boolean composite = false;

    public boolean isInstruction() {
        return true;
    }

    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLSort;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        String groupByAtt = null;
        String groupAdjacentAtt = null;
        String startingAtt = null;
        String endingAtt = null;
        String collationAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("group-by")) {
                groupByAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("group-adjacent")) {
                groupAdjacentAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("group-starting-with")) {
                startingAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("group-ending-with")) {
                endingAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("collation")) {
                collationAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("bind-group")) {
                try {
                    StructuredQName groupingVar = this.makeQName(atts.getValue(a));
                    this.groupSourceBinding = new SourceBinding(this);
                    this.groupSourceBinding.setVariableQName(groupingVar);
                    this.groupSourceBinding.setProperty(1024, true);
                }
                catch (NamespaceException e) {
                    this.compileError(e.getMessage());
                }
                continue;
            }
            if (f.equals("bind-grouping-key")) {
                try {
                    StructuredQName keyVar = this.makeQName(atts.getValue(a));
                    this.keySourceBinding = new SourceBinding(this);
                    this.keySourceBinding.setVariableQName(keyVar);
                }
                catch (NamespaceException e) {
                    this.compileError(e.getMessage());
                }
                continue;
            }
            if (f.equals("composite")) {
                String val;
                if (!this.getPreparedStylesheet().getCompilerInfo().getXsltVersion().equals(DecimalValue.THREE)) {
                    this.compileError("The 'composite' attribute requires XSLT 3.0");
                }
                if ((val = Whitespace.trim(atts.getValue(a))).equals("yes")) {
                    this.composite = true;
                    continue;
                }
                if (val.equals("no")) {
                    this.composite = false;
                    continue;
                }
                this.compileError("The value of the 'composite' attribute must be 'yes' or 'no'");
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (selectAtt == null) {
            this.reportAbsence("select");
            this.select = Literal.makeEmptySequence();
        } else {
            this.select = this.makeExpression(selectAtt);
        }
        int c = (groupByAtt == null ? 0 : 1) + (groupAdjacentAtt == null ? 0 : 1) + (startingAtt == null ? 0 : 1) + (endingAtt == null ? 0 : 1);
        if (c != 1) {
            this.compileError("Exactly one of the attributes group-by, group-adjacent, group-starting-with, and group-ending-with must be specified", "XTSE1080");
        }
        if (groupByAtt != null) {
            this.groupBy = this.makeExpression(groupByAtt);
        }
        if (groupAdjacentAtt != null) {
            this.groupAdjacent = this.makeExpression(groupAdjacentAtt);
        }
        if (startingAtt != null) {
            this.starting = this.makePattern(startingAtt);
        }
        if (endingAtt != null) {
            this.ending = this.makePattern(endingAtt);
        }
        if (collationAtt != null) {
            if (this.groupBy == null && this.groupAdjacent == null) {
                this.compileError("A collation may be specified only if group-by or group-adjacent is specified", "XTSE1090");
            } else {
                this.collationName = this.makeAttributeValueTemplate(collationAtt);
                if (this.collationName instanceof StringLiteral) {
                    String collation = ((StringLiteral)this.collationName).getStringValue();
                    try {
                        URI collationURI = new URI(collation);
                        if (!collationURI.isAbsolute()) {
                            URI base = new URI(this.getBaseURI());
                            collationURI = base.resolve(collationURI);
                            this.collationName = new StringLiteral(collationURI.toString());
                        }
                    }
                    catch (URISyntaxException err) {
                        this.compileError("Collation name '" + this.collationName + "' is not a valid URI", "XTDE1110");
                        this.collationName = new StringLiteral("http://www.w3.org/2005/xpath-functions/collation/codepoint");
                    }
                }
            }
        } else {
            String defaultCollation = this.getDefaultCollationName();
            if (defaultCollation != null) {
                this.collationName = new StringLiteral(defaultCollation);
            }
        }
        if (!(this.groupSourceBinding == null && this.keySourceBinding == null || this.getPreparedStylesheet().getCompilerInfo().getXsltVersion().equals(DecimalValue.THREE))) {
            this.compileError("for-each-group binding variables are allowed only with XSLT 3.0");
        }
        if (this.keySourceBinding != null && this.groupBy == null && this.groupAdjacent == null) {
            this.compileError("A grouping-key binding can be specified only with group-by or group-adjacent");
        }
        if (this.keySourceBinding != null && this.groupSourceBinding != null && this.keySourceBinding.getVariableQName().equals(this.groupSourceBinding.getVariableQName())) {
            this.compileError("The group variable and grouping-key variable must have different names");
        }
        if (this.composite && (this.starting != null || this.ending != null)) {
            this.compileError("The value composite='yes' cannot be used with " + (this.starting == null ? "grouping-ending-with" : "group-starting-with"));
        }
    }

    public void validate(Declaration decl) throws XPathException {
        RoleLocator role;
        this.checkSortComesFirst(false);
        this.select = this.typeCheck("select", this.select);
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        if (this.groupBy != null) {
            this.groupBy = this.typeCheck("group-by", this.groupBy);
            try {
                role = new RoleLocator(4, "xsl:for-each-group/group-by", 0);
                this.groupBy = TypeChecker.staticTypeCheck(this.groupBy, SequenceType.ATOMIC_SEQUENCE, false, role, visitor);
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        } else if (this.groupAdjacent != null) {
            this.groupAdjacent = this.typeCheck("group-adjacent", this.groupAdjacent);
            try {
                role = new RoleLocator(4, "xsl:for-each-group/group-adjacent", 0);
                role.setErrorCode("XTTE1100");
                this.groupAdjacent = TypeChecker.staticTypeCheck(this.groupAdjacent, this.composite ? SequenceType.ATOMIC_SEQUENCE : SequenceType.SINGLE_ATOMIC, false, role, visitor);
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        }
        this.starting = this.typeCheck("starting", this.starting);
        this.ending = this.typeCheck("ending", this.ending);
        if (!(this.starting == null && this.ending == null || visitor.getStaticContext().getXPathLanguageLevel().equals(DecimalValue.THREE))) {
            try {
                role = new RoleLocator(4, "xsl:for-each-group/select", 0);
                role.setErrorCode("XTTE1120");
                this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.NODE_SEQUENCE, false, role, visitor);
            }
            catch (XPathException err) {
                String prefix = this.starting != null ? "With group-starting-with attribute: " : "With group-ending-with attribute: ";
                this.compileError(prefix + err.getMessage(), err.getErrorCodeQName());
            }
        }
        if (!this.hasChildNodes()) {
            this.compileWarning("An empty xsl:for-each-group instruction has no effect", "SXWN9009");
        }
    }

    public void postValidate() throws XPathException {
        Object child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            SortKeyDefinition sk;
            if (!(child instanceof XSLSort)) continue;
            if (this.groupSourceBinding != null) {
                sk = ((XSLSort)child).getSortKeyDefinition();
                XSLForEachGroup.checkNoDependency(sk.getLanguage(), this.groupSourceBinding);
                XSLForEachGroup.checkNoDependency(sk.getOrder(), this.groupSourceBinding);
                XSLForEachGroup.checkNoDependency(sk.getCaseOrder(), this.groupSourceBinding);
                XSLForEachGroup.checkNoDependency(sk.getDataTypeExpression(), this.groupSourceBinding);
                XSLForEachGroup.checkNoDependency(sk.getStable(), this.groupSourceBinding);
                XSLForEachGroup.checkNoDependency(sk.getCollationNameExpression(), this.groupSourceBinding);
            }
            if (this.keySourceBinding == null) continue;
            sk = ((XSLSort)child).getSortKeyDefinition();
            XSLForEachGroup.checkNoDependency(sk.getLanguage(), this.keySourceBinding);
            XSLForEachGroup.checkNoDependency(sk.getOrder(), this.keySourceBinding);
            XSLForEachGroup.checkNoDependency(sk.getCaseOrder(), this.keySourceBinding);
            XSLForEachGroup.checkNoDependency(sk.getDataTypeExpression(), this.keySourceBinding);
            XSLForEachGroup.checkNoDependency(sk.getStable(), this.keySourceBinding);
            XSLForEachGroup.checkNoDependency(sk.getCollationNameExpression(), this.keySourceBinding);
        }
    }

    private static void checkNoDependency(Expression exp, SourceBinding binding) throws XPathException {
        block4: {
            if (exp == null) break block4;
            if (exp instanceof VariableReference) {
                for (BindingReference ref : binding.getReferences()) {
                    if (ref != exp) continue;
                    throw new XPathException("Variable bound by xsl:for-each-group must not be referenced in an AVT attribute of a contained xsl:sort element", "XTSE3220");
                }
            } else {
                Iterator<Expression> sub = exp.iterateSubExpressions();
                while (sub.hasNext()) {
                    XSLForEachGroup.checkNoDependency(sub.next(), binding);
                }
            }
        }
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        StringCollator collator = null;
        if (this.collationName instanceof StringLiteral) {
            String uri = ((StringLiteral)this.collationName).getStringValue();
            collator = this.getPrincipalStylesheetModule().findCollation(uri, this.getBaseURI());
            if (collator == null) {
                this.compileError("The collation name '" + this.collationName + "' has not been defined", "XTDE1110");
            }
        }
        byte algorithm = 0;
        Expression key = null;
        if (this.groupBy != null) {
            algorithm = 0;
            key = this.groupBy;
        } else if (this.groupAdjacent != null) {
            algorithm = 1;
            key = this.groupAdjacent;
        } else if (this.starting != null) {
            algorithm = 2;
            key = new PatternSponsor(this.starting);
        } else if (this.ending != null) {
            algorithm = 3;
            key = new PatternSponsor(this.ending);
        }
        Expression action = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
        if (action == null) {
            return Literal.makeEmptySequence();
        }
        try {
            LocalVariableBinding groupBinding = null;
            LocalVariableBinding keyBinding = null;
            if (this.groupSourceBinding != null) {
                groupBinding = new LocalVariableBinding(this.groupSourceBinding.getVariableQName(), SequenceType.ANY_SEQUENCE);
                this.groupSourceBinding.fixupBinding(groupBinding);
            }
            if (this.keySourceBinding != null) {
                keyBinding = new LocalVariableBinding(this.keySourceBinding.getVariableQName(), SequenceType.ANY_SEQUENCE);
                this.keySourceBinding.fixupBinding(keyBinding);
            }
            ForEachGroup instr = new ForEachGroup(this.select, this.makeExpressionVisitor().simplify(action), algorithm, key, collator, this.collationName, ExpressionTool.getBaseURI(this.staticContext, action, true), this.makeSortKeys(decl));
            instr.setGroupBinding(groupBinding);
            instr.setKeyBinding(keyBinding);
            instr.setComposite(this.composite);
            return instr;
        }
        catch (XPathException e) {
            this.compileError(e);
            return null;
        }
    }

    public SourceBinding getGroupSourceBinding() {
        return this.groupSourceBinding;
    }

    public SourceBinding getKeyBinding() {
        return this.keySourceBinding;
    }

    public StructuredQName getGroupBindingName() {
        return this.groupSourceBinding == null ? null : this.groupSourceBinding.getVariableQName();
    }

    public StructuredQName getKeyBindingName() {
        return this.keySourceBinding == null ? null : this.keySourceBinding.getVariableQName();
    }
}

