/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ITabDelegate;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEventCaster;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetListener;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockTabDesktopPane;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.SmallTabButton;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.TabHandle;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.TabHandleEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.TabHandleListener;

public class TabDelegate
implements ITabDelegate {
    private TabWidget _widget;
    private String _title;
    private TabHandle _tabHandle;
    private WidgetEventCaster _eventCaster = new WidgetEventCaster();
    private JPanel _contentPane = new JPanel();
    private int _defaultCloseOperation = 2;
    private Icon _frameIcon;
    private boolean _visible;
    private HashMap<Object, Object> _clientProperties = new HashMap();

    public TabDelegate(TabWidget widget, String title) {
        this._widget = widget;
        this._title = title;
    }

    public void setTabHandle(TabHandle tabHandle) {
        this._tabHandle = tabHandle;
        this._tabHandle.addTabHandleListener(new TabHandleListener(){

            @Override
            public void tabClosing(TabHandleEvent tabHandleEvent) {
                TabDelegate.this.onTabClosing(tabHandleEvent);
            }

            @Override
            public void tabClosed(TabHandleEvent tabHandleEvent) {
                TabDelegate.this.onTabClosed(tabHandleEvent);
            }

            @Override
            public void tabAdded(TabHandleEvent tabHandleEvent) {
                TabDelegate.this.onTabAdded(tabHandleEvent);
            }

            @Override
            public void tabSelected(TabHandleEvent tabHandleEvent) {
                TabDelegate.this._eventCaster.fireWidgetActivated(new WidgetEvent(tabHandleEvent, TabDelegate.this._widget));
            }

            @Override
            public void tabDeselected(TabHandleEvent tabHandleEvent) {
                TabDelegate.this._eventCaster.fireWidgetDeactivated(new WidgetEvent(tabHandleEvent, TabDelegate.this._widget));
            }
        });
    }

    private void onTabAdded(TabHandleEvent tabHandleEvent) {
        this._tabHandle.setTitle(this._title);
        this._tabHandle.setIcon(this._frameIcon);
        this._widget.setVisible(true);
        if (!tabHandleEvent.isWidgetMovedButNotCreated()) {
            this._eventCaster.fireWidgetOpened(new WidgetEvent(tabHandleEvent, this._widget));
        }
    }

    private void onTabClosed(TabHandleEvent tabHandleEvent) {
        if (0 != this._defaultCloseOperation) {
            this._eventCaster.fireWidgetClosed(new WidgetEvent(tabHandleEvent, this._widget));
            this._widget.dispose();
        }
    }

    private void onTabClosing(TabHandleEvent tabHandleEvent) {
        this._eventCaster.fireWidgetClosing(new WidgetEvent(tabHandleEvent, this._widget));
        if (0 != this._defaultCloseOperation) {
            this._eventCaster.fireWidgetDeactivated(new WidgetEvent(tabHandleEvent, this._widget));
            this._widget.setVisible(false);
        }
    }

    @Override
    public void addTabWidgetListener(WidgetListener widgetListener) {
        this._eventCaster.addTabWidgetListener(widgetListener);
    }

    @Override
    public void removeTabWidgetListener(WidgetListener widgetListener) {
        this._eventCaster.removeTabWidgetListener(widgetListener);
    }

    @Override
    public int getDefaultCloseOperation() {
        return this._defaultCloseOperation;
    }

    @Override
    public boolean isVisible() {
        return this._visible;
    }

    @Override
    public void _moveToFront() {
        this._tabHandle.select();
    }

    @Override
    public void setDefaultCloseOperation(int operation) {
        this._defaultCloseOperation = operation;
    }

    @Override
    public Container getContentPane() {
        return this._contentPane;
    }

    @Override
    public void pack() {
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public void makeToolWindow(boolean isToolWindow) {
    }

    @Override
    public void _dispose() {
        this._tabHandle.removeTab(DockTabDesktopPane.TabClosingMode.DISPOSE);
        this._eventCaster.fireWidgetClosed(new WidgetEvent(new TabHandleEvent(this._tabHandle, null), this._widget));
    }

    @Override
    public void _setTitle(String title) {
        this._title = title;
        if (null != this._tabHandle) {
            this._tabHandle.setTitle(title);
        }
    }

    @Override
    public void addSmallTabButton(SmallTabButton smallTabButton) {
        this._tabHandle.addSmallTabButton(smallTabButton);
    }

    @Override
    public void removeSmallTabButton(SmallTabButton smallTabButton) {
        this._tabHandle.removeSmallTabButton(smallTabButton);
    }

    @Override
    public void _updateUI() {
    }

    @Override
    public void _setVisible(boolean aFlag) {
        this._visible = aFlag;
    }

    @Override
    public void _addNotify() {
    }

    @Override
    public void centerWithinDesktop() {
    }

    @Override
    public Container getAwtContainer() {
        return null;
    }

    @Override
    public void setContentPane(JPanel contentPane) {
        this._contentPane = contentPane;
    }

    @Override
    public void showOk(String msg) {
    }

    @Override
    public Dimension getSize() {
        return null;
    }

    @Override
    public void setSize(Dimension size) {
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
    }

    @Override
    public JInternalFrame getInternalFrame() {
        return null;
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this._widget.setBounds(rectangle);
    }

    @Override
    public Rectangle getBounds() {
        return this._widget.getBounds();
    }

    @Override
    public void setSelected(boolean b) throws PropertyVetoException {
    }

    @Override
    public void setLayer(Integer layer) {
    }

    @Override
    public void putClientProperty(Object key, Object prop) {
        this._clientProperties.put(key, prop);
    }

    @Override
    public Object getClientProperty(Object key) {
        return this._clientProperties.get(key);
    }

    @Override
    public void fireWidgetClosing() {
        this._eventCaster.fireWidgetClosing(new WidgetEvent(new TabHandleEvent(this._tabHandle, null), this._widget));
    }

    @Override
    public void fireWidgetClosed() {
        this._eventCaster.fireWidgetClosed(new WidgetEvent(new TabHandleEvent(this._tabHandle, null), this._widget));
    }

    @Override
    public void validate() {
        this._contentPane.validate();
    }

    @Override
    public void setFrameIcon(Icon icon) {
        this._frameIcon = icon;
        if (null != this._tabHandle) {
            this._tabHandle.setIcon(this._frameIcon);
        }
    }

    @Override
    public void toFront() {
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void setMaximum(boolean b) throws PropertyVetoException {
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
    }

    @Override
    public boolean isToolWindow() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public boolean isIcon() {
        return false;
    }
}

