/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.CachingMapDecorator;
import org.springframework.util.ReflectionUtils;

public final class ReflectiveVisitorHelper {
    private static final String VISIT_METHOD = "visit";
    private static final String VISIT_NULL = "visitNull";
    private static final Log logger = LogFactory.getLog((Class)ReflectiveVisitorHelper.class);
    private CachingMapDecorator visitorClassVisitMethods = new CachingMapDecorator(){

        public Object create(Object key) {
            return new ClassVisitMethods((Class)key);
        }
    };
    static /* synthetic */ Class class$java$lang$Object;

    public Object invokeVisit(Object visitor, Object argument) {
        Assert.notNull(visitor, "The visitor to visit is required");
        Method method = this.getMethod(visitor.getClass(), argument);
        if (method == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("No method found by reflection for visitor class [" + visitor.getClass().getName() + "] and argument of type [" + (argument != null ? argument.getClass().getName() : "") + "]"));
            }
            return null;
        }
        try {
            Object[] args = null;
            if (argument != null) {
                args = new Object[]{argument};
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                method.setAccessible(true);
            }
            return method.invoke(visitor, args);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    private Method getMethod(Class visitorClass, Object argument) {
        ClassVisitMethods visitMethods = (ClassVisitMethods)this.visitorClassVisitMethods.get(visitorClass);
        return visitMethods.getVisitMethod(argument != null ? argument.getClass() : null);
    }

    private static class ClassVisitMethods {
        private final Class visitorClass;
        private CachingMapDecorator visitMethodCache = new CachingMapDecorator(){

            public Object create(Object argumentClazz) {
                if (argumentClazz == null) {
                    return ClassVisitMethods.this.findNullVisitorMethod();
                }
                Method method = ClassVisitMethods.this.findVisitMethod((Class)argumentClazz);
                if (method == null) {
                    method = ClassVisitMethods.this.findDefaultVisitMethod();
                }
                return method;
            }
        };

        private ClassVisitMethods(Class visitorClass) {
            this.visitorClass = visitorClass;
        }

        private Method findNullVisitorMethod() {
            for (Class clazz = this.visitorClass; clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    return clazz.getDeclaredMethod(ReflectiveVisitorHelper.VISIT_NULL, null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            return this.findDefaultVisitMethod();
        }

        private Method findDefaultVisitMethod() {
            Class[] args = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ReflectiveVisitorHelper.class$("java.lang.Object")) : class$java$lang$Object};
            for (Class clazz = this.visitorClass; clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    return clazz.getDeclaredMethod(ReflectiveVisitorHelper.VISIT_METHOD, args);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"No default 'visit' method found. Returning <null>.");
            }
            return null;
        }

        private Method getVisitMethod(Class argumentClass) {
            return (Method)this.visitMethodCache.get(argumentClass);
        }

        private Method findVisitMethod(Class rootArgumentType) {
            if (rootArgumentType == (class$java$lang$Object == null ? (class$java$lang$Object = ReflectiveVisitorHelper.class$("java.lang.Object")) : class$java$lang$Object)) {
                return null;
            }
            LinkedList classQueue = new LinkedList();
            classQueue.addFirst(rootArgumentType);
            while (!classQueue.isEmpty()) {
                Class argumentType = (Class)classQueue.removeLast();
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Looking for method visit(" + argumentType + ")"));
                    }
                    return this.findVisitMethod(this.visitorClass, argumentType);
                }
                catch (NoSuchMethodException e) {
                    if (!argumentType.isInterface() && argumentType.getSuperclass() != (class$java$lang$Object == null ? ReflectiveVisitorHelper.class$("java.lang.Object") : class$java$lang$Object)) {
                        classQueue.addFirst(argumentType.getSuperclass());
                    }
                    Class<?>[] interfaces = argumentType.getInterfaces();
                    for (int i = 0; i < interfaces.length; ++i) {
                        classQueue.addFirst(interfaces[i]);
                    }
                }
            }
            return this.findDefaultVisitMethod();
        }

        private Method findVisitMethod(Class visitorClass, Class argumentType) throws NoSuchMethodException {
            try {
                return visitorClass.getDeclaredMethod(ReflectiveVisitorHelper.VISIT_METHOD, argumentType);
            }
            catch (NoSuchMethodException ex) {
                if (visitorClass.getSuperclass() != (class$java$lang$Object == null ? (class$java$lang$Object = ReflectiveVisitorHelper.class$("java.lang.Object")) : class$java$lang$Object)) {
                    return this.findVisitMethod(visitorClass.getSuperclass(), argumentType);
                }
                throw ex;
            }
        }
    }
}

