/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.querybuilder;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.SortedColumn;

public abstract class SortedColumnsTableModel<T extends SortedColumn>
extends DefaultTableModel {
    private ArrayList<T> _sortedCols = new ArrayList();

    public void updateOrderCols(ArrayList<T> newSortedCols) {
        boolean found;
        ArrayList<SortedColumn> toRemove = new ArrayList<SortedColumn>();
        ArrayList<SortedColumn> toAdd = new ArrayList<SortedColumn>();
        for (SortedColumn newSortedCol : newSortedCols) {
            found = false;
            for (SortedColumn sortedCol : this._sortedCols) {
                if (!sortedCol.equals(newSortedCol)) continue;
                this.updateCol(sortedCol, newSortedCol);
                found = true;
                break;
            }
            if (found) continue;
            toAdd.add(newSortedCol);
        }
        for (SortedColumn sortedCol : this._sortedCols) {
            found = false;
            for (SortedColumn newOrderCol : newSortedCols) {
                if (!sortedCol.equals(newOrderCol)) continue;
                this.updateCol(sortedCol, newOrderCol);
                found = true;
                break;
            }
            if (found) continue;
            toRemove.add(sortedCol);
        }
        this._sortedCols.removeAll(toRemove);
        this._sortedCols.addAll(toAdd);
        this.fireTableDataChanged();
    }

    protected abstract void updateCol(T var1, T var2);

    public int[] moveUp(int[] selRows) {
        for (int i : selRows) {
            if (0 != i) continue;
            return selRows;
        }
        int[] newSelRows = new int[selRows.length];
        for (int i = 0; i < selRows.length; ++i) {
            SortedColumn col = (SortedColumn)this._sortedCols.remove(selRows[i]);
            newSelRows[i] = selRows[i] - 1;
            this._sortedCols.add(newSelRows[i], col);
        }
        return newSelRows;
    }

    public int[] moveDown(int[] selRows) {
        for (int i : selRows) {
            if (this._sortedCols.size() - 1 != i) continue;
            return selRows;
        }
        int[] newSelIx = new int[selRows.length];
        for (int i = selRows.length - 1; i >= 0; --i) {
            SortedColumn col = (SortedColumn)this._sortedCols.remove(selRows[i]);
            newSelIx[i] = selRows[i] + 1;
            this._sortedCols.add(newSelIx[i], col);
        }
        return newSelIx;
    }

    public T[] getSortedCols(Class<? extends T> c) {
        return this._sortedCols.toArray((SortedColumn[])Array.newInstance(c, 0));
    }

    protected void addCols(List<T> orderCols) {
        this._sortedCols.addAll(orderCols);
    }

    protected T getSortedCol(int ix) {
        return (T)((SortedColumn)this._sortedCols.get(ix));
    }

    @Override
    public int getRowCount() {
        if (null == this._sortedCols) {
            return 0;
        }
        return this._sortedCols.size();
    }

    public abstract TableColumnModel getColumnModel();
}

