/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker;

import java.util.Collection;
import org.apache.activemq.apollo.broker.BindAddress;
import org.apache.activemq.apollo.broker.BindableDeliveryProducer;
import org.apache.activemq.apollo.broker.ConnectAddress;
import org.apache.activemq.apollo.broker.DeliveryConsumer;
import org.apache.activemq.apollo.broker.DestinationAddress;
import org.apache.activemq.apollo.broker.DomainDestination;
import org.apache.activemq.apollo.broker.LocalRouter;
import org.apache.activemq.apollo.broker.LocalRouter$;
import org.apache.activemq.apollo.broker.LocalRouter$Domain$;
import org.apache.activemq.apollo.broker.RouterListener;
import org.apache.activemq.apollo.broker.security.SecuredResource;
import org.apache.activemq.apollo.broker.security.SecurityContext;
import org.apache.activemq.apollo.util.LoggingTracker;
import org.apache.activemq.apollo.util.Result;
import org.apache.activemq.apollo.util.Success;
import org.apache.activemq.apollo.util.path.Path;
import org.apache.activemq.apollo.util.path.PathMap;
import org.apache.activemq.apollo.util.path.PathParser$;
import org.fusesource.hawtdispatch.Task;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;

public abstract class LocalRouter$Domain$class {
    public static Iterable destinations(LocalRouter.Domain $this) {
        return JavaConversions$.MODULE$.collectionAsScalaIterable((Collection)$this.destination_by_path().get($this.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().org$apache$activemq$apollo$broker$LocalRouter$$ALL()));
    }

    public static Iterable get_destination_matches(LocalRouter.Domain $this, Path path) {
        return JavaConversions$.MODULE$.collectionAsScalaIterable((Collection)$this.destination_by_path().get(path));
    }

    public static void apply_update(LocalRouter.Domain $this, LoggingTracker traker$1) {
        $this.destinations().foreach((Function1)new Serializable($this, traker$1){
            public static final long serialVersionUID;
            private final LoggingTracker traker$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(D dest) {
                dest.update((Task)this.traker$1.task((Object)new StringBuilder().append((Object)"update ").append(dest).toString()));
            }
            {
                this.traker$1 = domain;
            }
        });
    }

    public static boolean auto_create_on_connect(LocalRouter.Domain $this) {
        return $this.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().auto_create_destinations();
    }

    public static boolean auto_create_on_bind(LocalRouter.Domain $this) {
        return $this.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().auto_create_destinations();
    }

    public static Result get_or_create_destination(LocalRouter.Domain $this, DestinationAddress address$1, SecurityContext security$1) {
        return (Result)Option$.MODULE$.apply($this.destination_by_path().chooseValue(address$1.path())).map((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Success<D> apply(D d) {
                return new Success(d);
            }
        }).getOrElse((Function0)new Serializable($this, address$1, security$1){
            public static final long serialVersionUID;
            private final LocalRouter.Domain $outer;
            private final DestinationAddress address$1;
            private final SecurityContext security$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Result<D, String> apply() {
                return this.$outer.create_destination(this.address$1, this.security$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.address$1 = domain;
                this.security$1 = var3_3;
            }
        });
    }

    public static Option can_destroy_destination(LocalRouter.Domain $this, DestinationAddress address$3, SecurityContext security$5) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            Object object = new Object();
            Option exceptionResult4 = null;
            try {
                if (security$5 == null) {
                    return None$.MODULE$;
                }
                $this.get_destination_matches(address$3.path()).foreach((Function1)new Serializable($this, address$3, security$5, object){
                    public static final long serialVersionUID;
                    private final LocalRouter.Domain $outer;
                    private final DestinationAddress address$3;
                    public final SecurityContext security$5;
                    public final Object nonLocalReturnKey1$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(D dest$3) {
                        if (this.$outer.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().is_temp(this.address$3)) {
                            Tuple2 owner$1 = (Tuple2)this.$outer.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().temp_owner(this.address$3).get();
                            this.security$5.session_id().foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID;
                                private final LocalRouter$Domain$.anonfun.can_destroy_destination.1 $outer;
                                private final DomainDestination dest$3;
                                private final Tuple2 owner$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final void apply(String connection) {
                                    Tuple2 tuple2 = new Tuple2((Object)this.$outer.org$apache$activemq$apollo$broker$LocalRouter$Domain$$anonfun$$$outer().org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().virtual_host().broker().id(), (Object)connection);
                                    Tuple2 tuple22 = this.owner$1;
                                    if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                                        return;
                                    }
                                    throw new NonLocalReturnControl(this.$outer.nonLocalReturnKey1$1, (Object)new Some((Object)Predef$.MODULE$.augmentString("Not authorized to destroy the temp %s '%s'. Principals=%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dest$3.resource_kind().id(), this.dest$3.id(), this.$outer.security$5.principal_dump()}))));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.dest$3 = domainDestination;
                                    this.owner$1 = tuple2;
                                }
                            });
                        }
                        if (Predef$.MODULE$.Boolean2boolean(this.$outer.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().authorizer().can(this.security$5, "destroy", (SecuredResource)dest$3))) {
                            return;
                        }
                        throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)Predef$.MODULE$.augmentString("Not authorized to destroy the %s '%s'. Principals=%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dest$3.resource_kind().id(), dest$3.id(), this.security$5.principal_dump()}))));
                    }

                    public LocalRouter.Domain org$apache$activemq$apollo$broker$LocalRouter$Domain$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.address$3 = domain;
                        this.security$5 = var3_3;
                        this.nonLocalReturnKey1$1 = var4_4;
                    }
                });
                exceptionResult4 = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                exceptionResult4 = (Option)nonLocalReturnControl2.value();
            }
            return exceptionResult4;
        }
        throw nonLocalReturnControl2;
    }

    public static Option can_bind_all(LocalRouter.Domain $this, BindAddress bind_address, DeliveryConsumer consumer$5, SecurityContext security$6) {
        NonLocalReturnControl nonLocalReturnControl2;
        block11: {
            Object object = new Object();
            Option exceptionResult5 = null;
            try {
                if (security$6 == null) {
                    return None$.MODULE$;
                }
                if ($this.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().is_temp(bind_address)) {
                    Option<Tuple2<String, String>> option = $this.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().temp_owner(bind_address);
                    if (option instanceof Some) {
                        Tuple2 tuple2;
                        Some some = (Some)option;
                        Tuple2 owner$2 = tuple2 = (Tuple2)some.x();
                        security$6.session_id().foreach((Function1)new Serializable($this, security$6, owner$2, object){
                            public static final long serialVersionUID;
                            private final LocalRouter.Domain $outer;
                            private final SecurityContext security$6;
                            private final Tuple2 owner$2;
                            private final Object nonLocalReturnKey2$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply(String connection) {
                                Tuple2 tuple2 = new Tuple2((Object)this.$outer.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().virtual_host().broker().id(), (Object)connection);
                                Tuple2 tuple22 = this.owner$2;
                                if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                                    return;
                                }
                                throw new NonLocalReturnControl(this.nonLocalReturnKey2$1, (Object)new Some((Object)Predef$.MODULE$.augmentString("Not authorized to receive from the temporary destination. Principals=%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.security$6.principal_dump()}))));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.security$6 = domain;
                                this.owner$2 = var3_3;
                                this.nonLocalReturnKey2$1 = var4_4;
                            }
                        });
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option<Tuple2<String, String>> option2 = option;
                        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                            return new Some((Object)"Invalid temp destination name. Owner id missing");
                        }
                        throw new MatchError(option);
                    }
                }
                boolean wildcard = PathParser$.MODULE$.containsWildCards(bind_address.path());
                Iterable matches = $this.get_destination_matches(bind_address.path());
                if (!wildcard) {
                    if (matches.isEmpty() && $this.auto_create_on_bind()) {
                        Result rc = $this.create_destination(bind_address, security$6);
                        if (rc.failed()) {
                            return new Some(rc.failure());
                        }
                        matches = $this.get_destination_matches(bind_address.path());
                    }
                    if (matches.isEmpty()) {
                        return new Some((Object)"The destination does not exist.");
                    }
                    matches.foreach((Function1)new Serializable($this, consumer$5, security$6, object){
                        public static final long serialVersionUID;
                        private final LocalRouter.Domain $outer;
                        private final DeliveryConsumer consumer$5;
                        private final SecurityContext security$6;
                        private final Object nonLocalReturnKey2$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(D dest) {
                            String action = this.$outer.bind_action(this.consumer$5);
                            if (Predef$.MODULE$.Boolean2boolean(this.$outer.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().authorizer().can(this.security$6, action, (SecuredResource)dest))) {
                                return;
                            }
                            throw new NonLocalReturnControl(this.nonLocalReturnKey2$1, (Object)new Some((Object)Predef$.MODULE$.augmentString("Not authorized to %s from the %s '%s'. Principals=%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, dest.resource_kind().id(), dest.id(), this.security$6.principal_dump()}))));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.consumer$5 = domain;
                            this.security$6 = var3_3;
                            this.nonLocalReturnKey2$1 = var4_4;
                        }
                    });
                }
                exceptionResult5 = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block11;
                exceptionResult5 = (Option)nonLocalReturnControl2.value();
            }
            return exceptionResult5;
        }
        throw nonLocalReturnControl2;
    }

    public static void bind(LocalRouter.Domain $this, BindAddress bind_address$1, DeliveryConsumer consumer$2, SecurityContext security$2) {
        LocalRouter.ConsumerContext context = (LocalRouter.ConsumerContext)$this.consumers().getOrElseUpdate((Object)consumer$2, (Function0)new Serializable($this, consumer$2){
            public static final long serialVersionUID;
            private final DeliveryConsumer consumer$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final LocalRouter.ConsumerContext<D> apply() {
                return new LocalRouter.ConsumerContext<D>(this.consumer$2);
            }
            {
                this.consumer$2 = domain;
            }
        });
        context.security_$eq(security$2);
        if (context.bind_addresses().add((Object)bind_address$1)) {
            $this.consumers_by_path().put(bind_address$1.path(), (Object)new Tuple2((Object)context, (Object)bind_address$1));
            consumer$2.retain();
            Set matches = $this.get_destination_matches(bind_address$1.path()).toSet();
            matches = (Set)matches.$minus$minus(context.matched_destinations());
            context.matched_destinations().$plus$plus$eq((TraversableOnce)matches);
            matches.foreach((Function1)new Serializable($this, bind_address$1, consumer$2, security$2){
                public static final long serialVersionUID;
                private final LocalRouter.Domain $outer;
                private final BindAddress bind_address$1;
                public final DeliveryConsumer consumer$2;
                public final SecurityContext security$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(D dest$4) {
                    if (Predef$.MODULE$.Boolean2boolean(this.$outer.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().authorizer().can(this.security$2, this.$outer.bind_action(this.consumer$2), (SecuredResource)dest$4))) {
                        dest$4.bind(this.bind_address$1, this.consumer$2);
                        this.$outer.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().router_listeners().foreach((Function1)new Serializable(this, dest$4){
                            public static final long serialVersionUID;
                            private final LocalRouter$Domain$.anonfun.bind.1 $outer;
                            private final DomainDestination dest$4;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply(RouterListener l) {
                                l.on_bind(this.dest$4, this.$outer.consumer$2, this.$outer.security$2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.dest$4 = var2_2;
                            }
                        });
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.bind_address$1 = domain;
                    this.consumer$2 = var3_3;
                    this.security$2 = var4_4;
                }
            });
        }
    }

    public static Object unbind(LocalRouter.Domain $this, BindAddress bind_address, DeliveryConsumer consumer$1, boolean persistent$1, SecurityContext security) {
        Option option;
        block7: {
            Object object;
            block6: {
                block5: {
                    option = $this.consumers().get((Object)consumer$1);
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block5;
                    object = BoxedUnit.UNIT;
                    break block6;
                }
                if (!(option instanceof Some)) break block7;
                Some some = (Some)option;
                LocalRouter.ConsumerContext consumerContext = (LocalRouter.ConsumerContext)some.x();
                LocalRouter.ConsumerContext context$1 = consumerContext;
                if (context$1.bind_addresses().remove((Object)bind_address)) {
                    Set matches = context$1.matched_destinations().toSet();
                    context$1.matched_destinations().clear();
                    context$1.bind_addresses().foreach((Function1)new Serializable($this, context$1){
                        public static final long serialVersionUID;
                        private final LocalRouter.Domain $outer;
                        private final LocalRouter.ConsumerContext context$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final HashSet<D> apply(BindAddress address) {
                            return (HashSet)this.context$1.matched_destinations().$plus$plus$eq(this.$outer.get_destination_matches(address.path()));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.context$1 = domain;
                        }
                    });
                    matches = (Set)matches.$minus$minus(context$1.matched_destinations());
                    matches.foreach((Function1)new Serializable($this, consumer$1, persistent$1){
                        public static final long serialVersionUID;
                        private final LocalRouter.Domain $outer;
                        public final DeliveryConsumer consumer$1;
                        public final boolean persistent$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(D dest$1) {
                            dest$1.unbind(this.consumer$1, this.persistent$1);
                            this.$outer.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().router_listeners().foreach((Function1)new Serializable(this, dest$1){
                                public static final long serialVersionUID;
                                private final LocalRouter$Domain$.anonfun.unbind.2 $outer;
                                private final DomainDestination dest$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final void apply(RouterListener l) {
                                    l.on_unbind(this.dest$1, this.$outer.consumer$1, this.$outer.persistent$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.dest$1 = var2_2;
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.consumer$1 = domain;
                            this.persistent$1 = n;
                        }
                    });
                    consumer$1.release();
                    $this.consumers_by_path().remove(bind_address.path(), (Object)new Tuple2((Object)context$1, (Object)bind_address));
                    object = context$1.bind_addresses().isEmpty() ? $this.consumers().remove((Object)consumer$1) : BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        }
        throw new MatchError((Object)option);
    }

    public static Option can_connect_all(LocalRouter.Domain $this, DestinationAddress address, BindableDeliveryProducer producer, SecurityContext security$7) {
        NonLocalReturnControl nonLocalReturnControl2;
        block8: {
            Object object = new Object();
            Option exceptionResult6 = null;
            try {
                None$ none$;
                boolean wildcard = PathParser$.MODULE$.containsWildCards(address.path());
                Iterable matches = $this.get_destination_matches(address.path());
                if (wildcard) {
                    none$ = None$.MODULE$;
                } else {
                    if (matches.isEmpty() && $this.auto_create_on_connect()) {
                        Result rc = $this.create_destination(address, security$7);
                        if (rc.failed()) {
                            return new Some(rc.failure());
                        }
                        matches = $this.get_destination_matches(address.path());
                    }
                    if (matches.isEmpty()) {
                        return new Some((Object)"The destination does not exist.");
                    }
                    if (LocalRouter$.MODULE$.$enable_assertions()) {
                        Predef$.MODULE$.assert(matches.size() == 1, (Function0)new Serializable($this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return "matches.size.$eq$eq(1)";
                            }
                        });
                    }
                    matches.foreach((Function1)new Serializable($this, security$7, object){
                        public static final long serialVersionUID;
                        private final LocalRouter.Domain $outer;
                        private final SecurityContext security$7;
                        private final Object nonLocalReturnKey3$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(D dest) {
                            if (Predef$.MODULE$.Boolean2boolean(this.$outer.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().authorizer().can(this.security$7, "send", (SecuredResource)dest))) {
                                return;
                            }
                            throw new NonLocalReturnControl(this.nonLocalReturnKey3$1, (Object)new Some((Object)Predef$.MODULE$.augmentString("Not authorized to send to the %s '%s'. Principals=%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dest.resource_kind().id(), dest.id(), this.security$7.principal_dump()}))));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.security$7 = domain;
                            this.nonLocalReturnKey3$1 = var3_3;
                        }
                    });
                    none$ = None$.MODULE$;
                }
                exceptionResult6 = none$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block8;
                exceptionResult6 = (Option)nonLocalReturnControl2.value();
            }
            return exceptionResult6;
        }
        throw nonLocalReturnControl2;
    }

    public static void connect(LocalRouter.Domain $this, ConnectAddress connect_address$1, BindableDeliveryProducer producer$1, SecurityContext security$8) {
        $this.get_destination_matches(connect_address$1.path()).foreach((Function1)new Serializable($this, connect_address$1, producer$1, security$8){
            public static final long serialVersionUID;
            private final LocalRouter.Domain $outer;
            private final ConnectAddress connect_address$1;
            public final BindableDeliveryProducer producer$1;
            public final SecurityContext security$8;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(D dest$5) {
                if (Predef$.MODULE$.Boolean2boolean(this.$outer.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().authorizer().can(this.security$8, "send", (SecuredResource)dest$5))) {
                    dest$5.connect(this.connect_address$1, this.producer$1);
                    this.$outer.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().router_listeners().foreach((Function1)new Serializable(this, dest$5){
                        public static final long serialVersionUID;
                        private final LocalRouter$Domain$.anonfun.connect.1 $outer;
                        private final DomainDestination dest$5;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(RouterListener l) {
                            l.on_connect(this.dest$5, this.$outer.producer$1, this.$outer.security$8);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.dest$5 = var2_2;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.connect_address$1 = domain;
                this.producer$1 = var3_3;
                this.security$8 = var4_4;
            }
        });
        $this.producers_by_path().put(connect_address$1.path(), (Object)new LocalRouter.ProducerContext(connect_address$1, producer$1, security$8));
    }

    public static void disconnect(LocalRouter.Domain $this, ConnectAddress connect_address, BindableDeliveryProducer producer$2) {
        $this.producers_by_path().remove(connect_address.path(), (Object)new LocalRouter.ProducerContext(connect_address, producer$2, null));
        $this.get_destination_matches(connect_address.path()).foreach((Function1)new Serializable($this, producer$2){
            public static final long serialVersionUID;
            private final LocalRouter.Domain $outer;
            public final BindableDeliveryProducer producer$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(D dest$6) {
                dest$6.disconnect(this.producer$2);
                this.$outer.org$apache$activemq$apollo$broker$LocalRouter$Domain$$$outer().router_listeners().foreach((Function1)new Serializable(this, dest$6){
                    public static final long serialVersionUID;
                    private final LocalRouter$Domain$.anonfun.disconnect.1 $outer;
                    private final DomainDestination dest$6;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(RouterListener l) {
                        l.on_disconnect(this.dest$6, this.$outer.producer$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.dest$6 = var2_2;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.producer$2 = domain;
            }
        });
    }

    public static void $init$(LocalRouter.Domain $this) {
        $this.destination_by_id_$eq((LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.destination_by_path_$eq(new PathMap());
        $this.org$apache$activemq$apollo$broker$LocalRouter$Domain$_setter_$consumers_$eq((HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.org$apache$activemq$apollo$broker$LocalRouter$Domain$_setter_$consumers_by_path_$eq(new PathMap());
        $this.org$apache$activemq$apollo$broker$LocalRouter$Domain$_setter_$producers_by_path_$eq(new PathMap());
        $this.add_destination_$eq(new LocalRouter$Domain$.anonfun.1($this));
        $this.remove_destination_$eq(new LocalRouter$Domain$.anonfun.2($this));
    }
}

