/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import java.util.ArrayList;
import java.util.List;
import vcf.GTRec;

public class Window<E extends GTRec> {
    private final List<E> recList;
    private final int overlapEnd;
    private final int overlapStart;
    private final boolean lastWindowOnChrom;
    private final boolean lastWindow;

    public Window(List<E> list, int n, int n2, boolean bl, boolean bl2) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException(list.toString());
        }
        if (bl && n2 != list.size()) {
            throw new IllegalArgumentException(String.valueOf(n2));
        }
        this.recList = new ArrayList<E>(list);
        this.overlapEnd = n;
        this.overlapStart = n2;
        this.lastWindowOnChrom = bl;
        this.lastWindow = bl2;
    }

    public int nMarkers() {
        return this.recList.size();
    }

    public List<E> recList() {
        return new ArrayList<E>(this.recList);
    }

    public E rec(int n) {
        return (E)((GTRec)this.recList.get(n));
    }

    public void addRecords(List<E> list, int n, int n2) {
        list.addAll(this.recList.subList(n, n2));
    }

    public int prevOverlap() {
        return this.overlapEnd;
    }

    public int nextOverlap() {
        return this.overlapStart;
    }

    public int chromIndex() {
        return ((GTRec)this.recList.get(0)).marker().chromIndex();
    }

    public boolean lastWindowOnChrom() {
        return this.lastWindowOnChrom;
    }

    public boolean lastWindow() {
        return this.lastWindow;
    }
}

