(* The run-time library for lexers generated by camllex *)

#open "io";;
#open "obj";;

(*** Lexer buffers *)

type lexbuf =
  { refill_buff : lexbuf -> unit;
    lex_buffer : string;
    mutable lex_abs_pos : int;
    mutable lex_start_pos : int;
    mutable lex_curr_pos : int;
    mutable lex_last_pos : int;
    mutable lex_last_action : lexbuf -> obj }
;;
        (* The type of lexer buffers. A lexer buffer is the argument passed
           to the scanning functions defined by the generated scanners.
           The lexer buffer holds the current state of the scanner, plus
           a function to refill the buffer from the input. *)

value create_lexer_channel : in_channel -> lexbuf
        (* Create a lexer buffer on the given input channel.
           [create_lexer_channel inchan] returns a lexer buffer which reads
           from the input channel [inchan], at the current reading position. *)
  and create_lexer_string : string -> lexbuf
        (* Create a lexer buffer which reads from
           the given string. Reading starts from the first character in
           the string. An end-of-input condition is generated when the
           end of the string is reached. *)
  and create_lexer : (string -> int -> int) -> lexbuf
        (* Create a lexer buffer with the given function as its reading method.
           When the scanner needs more characters, it will call the given
           function, giving it a character string [s] and a character
           count [n]. The function should put [n] characters or less in [s],
           starting at character number 0, and return the number of characters
           provided. A return value of 0 means end of input. *)
;;

(*** Functions for lexer semantic actions *)

        (* The following functions can be called from the semantic actions
           of lexer definitions (the ML code enclosed in braces that
           computes the value returned by lexing functions). They give
           access to the character string matched by the regular expression
           associated with the semantic action. These functions must be
           applied to the argument [lexbuf], which, in the code generated by
           camllex, is bound to the lexer buffer passed to the parsing
           function. *)

value get_lexeme : lexbuf -> string
        (* [get_lexeme lexbuf] returns the string matched by
           the regular expression. *)
  and get_lexeme_char : lexbuf -> int -> char
        (* [get_lexeme_char lexbuf i] returns character number [i] in
           the matched string. *)
  and get_lexeme_start : lexbuf -> int
        (* [get_lexeme_start lexbuf] returns the position in the input stream
           of the first character of the matched string. The first character
           of the stream has position 0. *)
  and get_lexeme_end : lexbuf -> int
        (* [get_lexeme_end lexbuf] returns the position in the input stream
           of the character following the last character of the matched
           string. The first character of the stream has position 0. *)
;;

(*--*)

(* The following definitions are used by the generated scanners only.
   They are not intended to be used by user programs. *)

value start_lexing : lexbuf -> unit
  and get_next_char : lexbuf -> char = 1 "get_next_char"
  and backtrack : lexbuf -> 'a
;;
