/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.WrapperKeyManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class KeyStoreKeyManager
extends WrapperKeyManager
implements Serializable {
    private static final long serialVersionUID = -5202641256733094253L;
    private final String keyStoreFile;
    private final String keyStoreFormat;

    public KeyStoreKeyManager(File keyStoreFile, char[] keyStorePIN) throws KeyStoreException {
        this(keyStoreFile.getAbsolutePath(), keyStorePIN, null, null);
    }

    public KeyStoreKeyManager(String keyStoreFile, char[] keyStorePIN) throws KeyStoreException {
        this(keyStoreFile, keyStorePIN, null, null);
    }

    public KeyStoreKeyManager(File keyStoreFile, char[] keyStorePIN, String keyStoreFormat, String certificateAlias) throws KeyStoreException {
        this(keyStoreFile.getAbsolutePath(), keyStorePIN, keyStoreFormat, certificateAlias);
    }

    public KeyStoreKeyManager(String keyStoreFile, char[] keyStorePIN, String keyStoreFormat, String certificateAlias) throws KeyStoreException {
        super(KeyStoreKeyManager.getKeyManagers(keyStoreFile, keyStorePIN, keyStoreFormat), certificateAlias);
        this.keyStoreFile = keyStoreFile;
        this.keyStoreFormat = keyStoreFormat == null ? KeyStore.getDefaultType() : keyStoreFormat;
    }

    private static KeyManager[] getKeyManagers(String keyStoreFile, char[] keyStorePIN, String keyStoreFormat) throws KeyStoreException {
        File f;
        Validator.ensureNotNull(keyStoreFile);
        String type = keyStoreFormat;
        if (type == null) {
            type = KeyStore.getDefaultType();
        }
        if (!(f = new File(keyStoreFile)).exists()) {
            throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_NO_SUCH_FILE.get(keyStoreFile));
        }
        KeyStore ks = KeyStore.getInstance(type);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(f);
            ks.load(inputStream, keyStorePIN);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_CANNOT_LOAD.get(keyStoreFile, type, String.valueOf(e)), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        try {
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(ks, keyStorePIN);
            return factory.getKeyManagers();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_KEYSTORE_CANNOT_GET_KEY_MANAGERS.get(keyStoreFile, keyStoreFormat, StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public String getKeyStoreFormat() {
        return this.keyStoreFormat;
    }
}

