/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.time.Clock;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.security.authc.saml.SamlMessageBuilder;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.elasticsearch.xpack.security.authc.saml.SpConfiguration;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;

class SamlAuthnRequestBuilder
extends SamlMessageBuilder {
    private final String spBinding;
    private final String idpBinding;
    private Boolean forceAuthn;
    private NameIDPolicySettings nameIdSettings;

    SamlAuthnRequestBuilder(SpConfiguration spConfig, String spBinding, EntityDescriptor idpDescriptor, String idBinding, Clock clock) {
        super(idpDescriptor, spConfig, clock);
        this.spBinding = spBinding;
        this.idpBinding = idBinding;
        this.nameIdSettings = new NameIDPolicySettings("urn:oasis:names:tc:SAML:2.0:nameid-format:transient", false, null);
    }

    SamlAuthnRequestBuilder forceAuthn(Boolean forceAuthn) {
        this.forceAuthn = forceAuthn;
        return this;
    }

    SamlAuthnRequestBuilder nameIDPolicy(NameIDPolicySettings settings) {
        this.nameIdSettings = settings;
        return this;
    }

    AuthnRequest build() {
        String destination = this.getIdpLocation();
        AuthnRequest request = SamlUtils.buildObject(AuthnRequest.class, AuthnRequest.DEFAULT_ELEMENT_NAME);
        request.setID(this.buildId());
        request.setIssueInstant(this.now());
        request.setDestination(destination);
        request.setProtocolBinding(this.spBinding);
        request.setAssertionConsumerServiceURL(this.serviceProvider.getAscUrl());
        request.setIssuer(this.buildIssuer());
        if (this.nameIdSettings != null) {
            request.setNameIDPolicy(this.buildNameIDPolicy());
        }
        if (!this.serviceProvider.getReqAuthnCtxClassRef().isEmpty()) {
            request.setRequestedAuthnContext(this.buildRequestedAuthnContext());
        }
        request.setForceAuthn(this.forceAuthn);
        return request;
    }

    private RequestedAuthnContext buildRequestedAuthnContext() {
        RequestedAuthnContext requestedAuthnContext = SamlUtils.buildObject(RequestedAuthnContext.class, RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
        for (String authnCtxClass : this.serviceProvider.getReqAuthnCtxClassRef()) {
            AuthnContextClassRef authnContextClassRef = SamlUtils.buildObject(AuthnContextClassRef.class, AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
            authnContextClassRef.setAuthnContextClassRef(authnCtxClass);
            requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassRef);
        }
        requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
        return requestedAuthnContext;
    }

    private NameIDPolicy buildNameIDPolicy() {
        NameIDPolicy nameIDPolicy = SamlUtils.buildObject(NameIDPolicy.class, NameIDPolicy.DEFAULT_ELEMENT_NAME);
        nameIDPolicy.setFormat(this.nameIdSettings.format);
        nameIDPolicy.setAllowCreate(Boolean.valueOf(this.nameIdSettings.allowCreate));
        nameIDPolicy.setSPNameQualifier(Strings.isNullOrEmpty((String)this.nameIdSettings.spNameQualifier) ? null : this.nameIdSettings.spNameQualifier);
        return nameIDPolicy;
    }

    private String getIdpLocation() {
        String location = this.getIdentityProviderEndpoint(this.idpBinding, IDPSSODescriptor::getSingleSignOnServices);
        if (location == null) {
            throw new ElasticsearchException("Cannot find [{}]/[{}] in descriptor [{}]", new Object[]{IDPSSODescriptor.DEFAULT_ELEMENT_NAME, this.idpBinding, this.identityProvider.getID()});
        }
        return location;
    }

    static class NameIDPolicySettings {
        private final String format;
        private final boolean allowCreate;
        private final String spNameQualifier;

        NameIDPolicySettings(String format, boolean allowCreate, String spNameQualifier) {
            this.format = format;
            this.allowCreate = allowCreate;
            this.spNameQualifier = spNameQualifier;
        }
    }
}

