/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.action.update.UpdateAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.utils.VoidChainTaskExecutor;

public class TransportFinalizeJobExecutionAction
extends TransportMasterNodeAction<FinalizeJobExecutionAction.Request, AcknowledgedResponse> {
    private final Client client;

    @Inject
    public TransportFinalizeJobExecutionAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(settings, "cluster:internal/xpack/ml/job/finalize_job_execution", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, FinalizeJobExecutionAction.Request::new);
        this.client = client;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    protected void masterOperation(FinalizeJobExecutionAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)state);
        Set<String> jobsInClusterState = Arrays.stream(request.getJobIds()).filter(id -> mlMetadata.getJobs().containsKey(id)).collect(Collectors.toSet());
        if (jobsInClusterState.isEmpty()) {
            this.finalizeIndexJobs(Arrays.asList(request.getJobIds()), listener);
        } else {
            ActionListener finalizeClusterStateJobsListener = ActionListener.wrap(ack -> {
                HashSet<String> jobsInIndex = new HashSet<String>(Arrays.asList(request.getJobIds()));
                jobsInIndex.removeAll(jobsInClusterState);
                if (jobsInIndex.isEmpty()) {
                    listener.onResponse(ack);
                } else {
                    this.finalizeIndexJobs(jobsInIndex, listener);
                }
            }, arg_0 -> listener.onFailure(arg_0));
            this.finalizeClusterStateJobs(jobsInClusterState, (ActionListener<AcknowledgedResponse>)finalizeClusterStateJobsListener);
        }
    }

    private void finalizeIndexJobs(Collection<String> jobIds, ActionListener<AcknowledgedResponse> listener) {
        String jobIdString = String.join((CharSequence)",", jobIds);
        this.logger.debug("finalizing jobs [{}]", (Object)jobIdString);
        VoidChainTaskExecutor voidChainTaskExecutor = new VoidChainTaskExecutor(this.threadPool.executor("ml_utility"), true);
        Map<String, Date> update = Collections.singletonMap(Job.FINISHED_TIME.getPreferredName(), new Date());
        for (String jobId : jobIds) {
            UpdateRequest updateRequest = new UpdateRequest(AnomalyDetectorsIndex.configIndexName(), "doc", Job.documentId((String)jobId));
            updateRequest.retryOnConflict(3);
            updateRequest.doc(update);
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            voidChainTaskExecutor.add(chainedListener -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)UpdateAction.INSTANCE, (ActionRequest)updateRequest, (ActionListener)ActionListener.wrap(updateResponse -> chainedListener.onResponse(null), arg_0 -> ((ActionListener)chainedListener).onFailure(arg_0))));
        }
        voidChainTaskExecutor.execute(ActionListener.wrap(aVoids -> {
            this.logger.debug("finalized job [{}]", (Object)jobIdString);
            listener.onResponse((Object)new AcknowledgedResponse(true));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void finalizeClusterStateJobs(final Collection<String> jobIds, final ActionListener<AcknowledgedResponse> listener) {
        final String jobIdString = String.join((CharSequence)",", jobIds);
        String source = "finalize_job_execution [" + jobIdString + "]";
        this.logger.debug("finalizing jobs [{}]", (Object)jobIdString);
        this.clusterService.submitStateUpdateTask(source, (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)currentState);
                MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)currentState);
                MlMetadata.Builder mlMetadataBuilder = new MlMetadata.Builder(mlMetadata);
                Date finishedTime = new Date();
                for (String jobId : jobIds) {
                    Job.Builder jobBuilder = new Job.Builder((Job)mlMetadata.getJobs().get(jobId));
                    jobBuilder.setFinishedTime(finishedTime);
                    mlMetadataBuilder.putJob(jobBuilder.build(), true);
                }
                ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
                return builder.metaData(new MetaData.Builder(currentState.metaData()).putCustom("ml", (MetaData.Custom)mlMetadataBuilder.build())).build();
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                TransportFinalizeJobExecutionAction.this.logger.debug("finalized job [{}]", (Object)jobIdString);
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }
        });
    }

    protected ClusterBlockException checkBlock(FinalizeJobExecutionAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

