/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.Collection;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.artifacts.repositories.AuthenticationSupporter;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.authentication.Authentication;
import org.gradle.jvm.toolchain.JavaToolchainResolver;
import org.gradle.jvm.toolchain.internal.JavaToolchainRepositoryInternal;

public abstract class DefaultJavaToolchainRepository
implements JavaToolchainRepositoryInternal {
    private final String name;
    private final AuthenticationContainer authenticationContainer;
    private final AuthenticationSupporter authenticationSupporter;
    private final ProviderFactory providerFactory;

    @Inject
    public DefaultJavaToolchainRepository(String name, AuthenticationContainer authenticationContainer, AuthenticationSupporter authenticationSupporter, ProviderFactory providerFactory) {
        this.name = name;
        this.authenticationContainer = authenticationContainer;
        this.authenticationSupporter = authenticationSupporter;
        this.providerFactory = providerFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public abstract Property<Class<? extends JavaToolchainResolver>> getResolverClass();

    @Override
    public Collection<Authentication> getConfiguredAuthentication() {
        return this.authenticationSupporter.getConfiguredAuthentication();
    }

    public PasswordCredentials getCredentials() {
        return this.authenticationSupporter.getCredentials();
    }

    public <T extends Credentials> T getCredentials(Class<T> credentialsType) {
        return (T)this.authenticationSupporter.getCredentials(credentialsType);
    }

    public void credentials(Action<? super PasswordCredentials> action) {
        this.authenticationSupporter.credentials(action);
    }

    public <T extends Credentials> void credentials(Class<T> credentialsType, Action<? super T> action) {
        this.authenticationSupporter.credentials(credentialsType, action);
    }

    public void credentials(Class<? extends Credentials> credentialsType) {
        this.authenticationSupporter.credentials(credentialsType, this.providerFactory.provider(() -> this.name));
    }

    public void authentication(Action<? super AuthenticationContainer> action) {
        this.authenticationSupporter.authentication(action);
    }

    public AuthenticationContainer getAuthentication() {
        return this.authenticationContainer;
    }
}

