/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractResponse;

public class ExpireDelegationTokenResponse
extends AbstractResponse {
    private static final String EXPIRY_TIMESTAMP_KEY_NAME = "expiry_timestamp";
    private final Errors error;
    private final long expiryTimestamp;
    private final int throttleTimeMs;
    private static final Schema TOKEN_EXPIRE_RESPONSE_V0 = new Schema(CommonFields.ERROR_CODE, new Field("expiry_timestamp", Type.INT64, "timestamp (in msec) at which this token expires.."), CommonFields.THROTTLE_TIME_MS);

    public ExpireDelegationTokenResponse(int throttleTimeMs, Errors error, long expiryTimestamp) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.expiryTimestamp = expiryTimestamp;
    }

    public ExpireDelegationTokenResponse(int throttleTimeMs, Errors error) {
        this(throttleTimeMs, error, -1L);
    }

    public ExpireDelegationTokenResponse(Struct struct) {
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
        this.expiryTimestamp = struct.getLong(EXPIRY_TIMESTAMP_KEY_NAME);
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
    }

    public static ExpireDelegationTokenResponse parse(ByteBuffer buffer, short version) {
        return new ExpireDelegationTokenResponse(ApiKeys.EXPIRE_DELEGATION_TOKEN.responseSchema(version).read(buffer));
    }

    public static Schema[] schemaVersions() {
        return new Schema[]{TOKEN_EXPIRE_RESPONSE_V0};
    }

    public Errors error() {
        return this.error;
    }

    public long expiryTimestamp() {
        return this.expiryTimestamp;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.EXPIRE_DELEGATION_TOKEN.responseSchema(version));
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        struct.set(EXPIRY_TIMESTAMP_KEY_NAME, (Object)this.expiryTimestamp);
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        return struct;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }
}

