/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensolaris.opengrok.analysis.Definitions;
import org.opensolaris.opengrok.analysis.FileAnalyzer;
import org.opensolaris.opengrok.configuration.Project;
import org.opensolaris.opengrok.history.Annotation;

public class FileAnalyzerFactory {
    private final ThreadLocal<FileAnalyzer> cachedAnalyzer = new ThreadLocal();
    private final List<String> names;
    private final List<String> prefixes;
    private final List<String> suffixes;
    private final List<String> magics;
    private final List<Matcher> matchers;
    private final String contentType;
    private final FileAnalyzer.Genre genre;

    FileAnalyzerFactory() {
        this(null, null, null, null, null, null, null);
    }

    protected FileAnalyzerFactory(String[] names, String[] prefixes, String[] suffixes, String[] magics, Matcher matcher, String contentType, FileAnalyzer.Genre genre) {
        this.names = FileAnalyzerFactory.asList(names);
        this.prefixes = FileAnalyzerFactory.asList(prefixes);
        this.suffixes = FileAnalyzerFactory.asList(suffixes);
        this.magics = FileAnalyzerFactory.asList(magics);
        this.matchers = matcher == null ? Collections.emptyList() : Collections.singletonList(matcher);
        this.contentType = contentType;
        this.genre = genre == null ? FileAnalyzer.Genre.DATA : genre;
    }

    private static <T> List<T> asList(T[] a) {
        if (a == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(a));
    }

    final List<String> getFileNames() {
        return this.names;
    }

    final List<String> getPrefixes() {
        return this.prefixes;
    }

    final List<String> getSuffixes() {
        return this.suffixes;
    }

    final List<String> getMagicStrings() {
        return this.magics;
    }

    final List<Matcher> getMatchers() {
        return this.matchers;
    }

    final String getContentType() {
        return this.contentType;
    }

    public final FileAnalyzer.Genre getGenre() {
        return this.genre;
    }

    public final FileAnalyzer getAnalyzer() {
        FileAnalyzer fa = this.cachedAnalyzer.get();
        if (fa == null) {
            fa = this.newAnalyzer();
            this.cachedAnalyzer.set(fa);
        }
        return fa;
    }

    protected FileAnalyzer newAnalyzer() {
        return new FileAnalyzer(this);
    }

    public void writeXref(Reader in, Writer out, Definitions defs, Annotation annotation, Project project) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected static interface Matcher {
        public FileAnalyzerFactory isMagic(byte[] var1, InputStream var2) throws IOException;
    }
}

