/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import"bootstrap";import"@typo3/install/renderable/clearable.js";import{AbstractInteractableModule}from"@typo3/install/module/abstract-interactable-module.js";import Notification from"@typo3/backend/notification.js";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import Router from"@typo3/install/router.js";import DebounceEvent from"@typo3/core/event/debounce-event.js";import"@typo3/backend/element/icon-element.js";import RegularEvent from"@typo3/core/event/regular-event.js";import{Collapse}from"bootstrap";var Identifiers;!function(e){e.fulltextSearch=".t3js-upgradeDocs-fulltext-search",e.changeLogsForVersionContainer=".t3js-version-changes",e.changeLogsForVersion=".t3js-changelog-list",e.selectPureField=".t3js-upgradeDocs-select-pure",e.upgradeDoc=".t3js-upgrade-doc"}(Identifiers||(Identifiers={}));class UpgradeDocs extends AbstractInteractableModule{initialize(e){super.initialize(e),this.loadModuleFrameAgnostic("select-pure").then((()=>{this.getContent()})),new RegularEvent("click",((e,t)=>{this.markRead(t)})).delegateTo(e,".t3js-upgradeDocs-markRead"),new RegularEvent("click",((e,t)=>{this.unmarkRead(t)})).delegateTo(e,".t3js-upgradeDocs-unmarkRead")}getContent(){const e=this.getModalBody();new AjaxRequest(Router.getUrl("upgradeDocsGetContent")).get({cache:"no-cache"}).then((async t=>{const o=await t.resolve();!0===o.success&&"undefined"!==o.html&&o.html.length>0&&(e.innerHTML=o.html,this.initializeFullTextSearch(),this.initializeSelectPure(),this.loadChangelogs())}),(t=>{Router.handleAjaxError(t,e)}))}loadChangelogs(){const e=[],t=this.getModalBody();this.currentModal.querySelectorAll(Identifiers.changeLogsForVersionContainer).forEach((o=>{const a=new AjaxRequest(Router.getUrl("upgradeDocsGetChangelogForVersion")).withQueryArguments({install:{version:o.dataset.version}}).get({cache:"no-cache"}).then((async e=>{const t=await e.resolve();if(!0===t.success){const e=o,a=e.querySelector(Identifiers.changeLogsForVersion);a.innerHTML=t.html,this.moveNotRelevantDocuments(a),e.querySelector(".t3js-panel-loading").remove()}else Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(e=>{Router.handleAjaxError(e,t)}));e.push(a)})),Promise.all(e).then((()=>{this.fulltextSearchField.disabled=!1,this.appendItemsToSelectPure()}))}initializeFullTextSearch(){this.fulltextSearchField=this.findInModal(Identifiers.fulltextSearch);const e=this.fulltextSearchField;e.clearable({onClear:()=>{this.combinedFilterSearch()}}),e.focus(),new DebounceEvent("keyup",(()=>{this.combinedFilterSearch()})).bindTo(e)}initializeSelectPure(){this.selectPureField=this.getModalBody().querySelector(Identifiers.selectPureField),this.selectPureField.addEventListener("change",(()=>{this.combinedFilterSearch(),this.selectPureField.close()}))}appendItemsToSelectPure(){let e="";this.currentModal.querySelectorAll(Identifiers.upgradeDoc).forEach((t=>{e+=t.dataset.itemTags+","}));const t=[...new Set(e.slice(0,-1).split(",")).values()].reduce(((e,t)=>{const o=t.toLowerCase();return e.every((e=>e.toLowerCase()!==o))&&e.push(t),e}),[]).sort(((e,t)=>e.toLowerCase().localeCompare(t.toLowerCase())));this.selectPureField.enable();for(const e of t){const t=this.selectPureField.ownerDocument.createElement("option-pure");t.textContent=e,t.setAttribute("value",e),this.selectPureField.appendChild(t)}}combinedFilterSearch(){const e=this.getModalBody(),t=e.querySelectorAll(Identifiers.upgradeDoc);if(this.selectPureField.values.length<1&&this.fulltextSearchField.value.length<1){return void this.currentModal.querySelectorAll(".panel-version .panel-collapse.show").forEach((e=>{new RegularEvent("hidden.bs.collapse",(()=>{0===this.currentModal.querySelectorAll(".panel-version .panel-collapse.collapsing").length&&t.forEach((e=>{e.classList.remove("hidden","searchhit","filterhit")}))}),{once:!0}).bindTo(e),Collapse.getOrCreateInstance(e).hide()}))}if(t.forEach((e=>{e.classList.remove("searchhit","filterhit")})),this.selectPureField.values.length>0){t.forEach((e=>{e.classList.add("hidden"),e.classList.remove("filterhit")}));const o=this.selectPureField.values.map((e=>'[data-item-tags*="'+e+'"]')).join("");e.querySelectorAll(o).forEach((e=>{e.classList.remove("hidden"),e.classList.add("searchhit","filterhit")}))}else t.forEach((e=>{e.classList.add("filterhit"),e.classList.remove("hidden")}));const o=this.fulltextSearchField.value;e.querySelectorAll(".filterhit").forEach((e=>{e.textContent.toLowerCase().trim().includes(o.toLowerCase())?(e.classList.remove("hidden"),e.classList.add("searchhit")):(e.classList.remove("searchhit"),e.classList.add("hidden"))})),e.querySelectorAll(".searchhit").forEach((e=>{const t=e.closest(".panel-collapse");window.setTimeout((()=>{Collapse.getOrCreateInstance(t).show()}),20)})),e.querySelectorAll(".panel-version").forEach((e=>{if(e.querySelectorAll(".searchhit, .filterhit").length<1){const t=e.querySelector(":scope > .panel-collapse");Collapse.getOrCreateInstance(t).hide()}}))}moveNotRelevantDocuments(e){this.findInModal(".panel-body-read").append(e.querySelector('[data-item-state="read"]')??""),this.findInModal(".panel-body-not-affected").append(e.querySelector('[data-item-state="notAffected"]')??"")}markRead(e){const t=this.getModalBody(),o=this.getModuleContent().dataset.upgradeDocsMarkReadToken,a=e.closest("button");a.classList.toggle("t3js-upgradeDocs-unmarkRead"),a.classList.toggle("t3js-upgradeDocs-markRead"),a.querySelectorAll("typo3-backend-icon,.t3js-icon").forEach((e=>{e.outerHTML='<typo3-backend-icon identifier="actions-ban" size="small"></typo3-backend-icon>'})),this.findInModal(".panel-body-read").append(a.closest(".panel")),new AjaxRequest(Router.getUrl()).post({install:{ignoreFile:a.dataset.filepath,token:o,action:"upgradeDocsMarkRead"}}).catch((e=>{Router.handleAjaxError(e,t)}))}unmarkRead(e){const t=this.getModalBody(),o=this.getModuleContent().dataset.upgradeDocsUnmarkReadToken,a=e.closest("button"),s=a.closest(".panel").dataset.itemVersion;a.classList.toggle("t3js-upgradeDocs-markRead"),a.classList.toggle("t3js-upgradeDocs-unmarkRead"),a.querySelectorAll("typo3-backend-icon,.t3js-icon").forEach((e=>{e.outerHTML='<typo3-backend-icon identifier="actions-check" size="small"></typo3-backend-icon>'})),this.findInModal('*[data-group-version="'+s+'"] .panel-body').append(a.closest(".panel")),new AjaxRequest(Router.getUrl()).post({install:{ignoreFile:a.dataset.filepath,token:o,action:"upgradeDocsUnmarkRead"}}).catch((e=>{Router.handleAjaxError(e,t)}))}}export default new UpgradeDocs;