/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import b.h.la;
import com.google.gson.Gson;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopAutocorrectFix;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopExternalAnnotator;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopOffenses;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.RContainerBase;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;

class RubocopResponse {
    private static final RubocopResponse b;
    private static final int c = 1024;
    private static final Logger a;
    @Nullable
    public Metadata metadata;
    @Nullable
    public List<File> files;
    @Nullable
    public Summary summary;
    @Nullable
    public String myErrorMessage;
    private static final long d;

    RubocopResponse() {
    }

    public boolean isSuccess() {
        return this.getErrorMessage() == null;
    }

    @Nullable
    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    @Nullable
    public List<File> getFiles() {
        return this.files;
    }

    @NotNull
    private static RubocopResponse a(@NotNull String string) {
        if (string == null) {
            RubocopResponse.a(0);
        }
        RubocopResponse rubocopResponse = new RubocopResponse();
        rubocopResponse.myErrorMessage = string;
        RubocopResponse rubocopResponse2 = rubocopResponse;
        if (rubocopResponse2 == null) {
            RubocopResponse.a(1);
        }
        return rubocopResponse2;
    }

    @NotNull
    public static RubocopResponse computeWithArguments(@NotNull RubyGemExecutionContext context, @Nullable ProcessListener processListener) {
        RubocopResponse rubocopResponse;
        ProcessOutput processOutput;
        Object object;
        Object object2;
        long l2 = d ^ 0x3F346FB83C7FL;
        if (context == null) {
            RubocopResponse.a(2);
        }
        try {
            object2 = ProgressManager.getInstance().getProgressIndicator();
            if (object2 instanceof ProgressWrapper) {
                if (!object2.isRunning()) {
                    object2.start();
                }
                object = new ExecutionModes.SameThreadMode(true);
            } else {
                object = new ExecutionModes.SameThreadMode(false);
            }
            if (processListener != null) {
                object.addProcessListener(processListener);
            }
            RunnerUtil.validateSDK(context.getRubySdk());
            processOutput = ((RubyGemExecutionContext)context.withGemScriptName("rubocop").withExecutionMode((ExecutionMode)object)).executeScript();
        }
        catch (ExecutionException executionException) {
            a.warn("Rubocop execution error: ", (Throwable)executionException);
            RubocopResponse rubocopResponse2 = RubocopResponse.a(RBundle.message((String)"inspection.rubocop.error.starting", (Object[])new Object[]{executionException.getMessage()}));
            if (rubocopResponse2 == null) {
                RubocopResponse.a(3);
            }
            return rubocopResponse2;
        }
        if (processOutput == null) {
            a.debug("Empty response");
            RubocopResponse rubocopResponse3 = b;
            if (rubocopResponse3 == null) {
                RubocopResponse.a(4);
            }
            return rubocopResponse3;
        }
        object2 = processOutput.getStderr();
        object = processOutput.getStdout();
        int n2 = processOutput.getExitCode();
        if (n2 != 1 && n2 != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Rubocop returned exit code: ").append(n2).append("\n");
            if (StringUtil.isNotEmpty((String)object)) {
                stringBuilder.append("stdout:\n").append(StringUtil.trimLog((String)object, (int)1024)).append("\n");
            }
            if (StringUtil.isNotEmpty((String)object2)) {
                stringBuilder.append("stderr:\n").append(StringUtil.trimLog((String)object2, (int)1024)).append("\n");
            }
            RubocopResponse rubocopResponse4 = RubocopResponse.a(context.getProject(), RBundle.message((String)"inspection.rubocop.error.code", (Object[])new Object[]{n2}), stringBuilder.toString());
            if (rubocopResponse4 == null) {
                RubocopResponse.a(5);
            }
            return rubocopResponse4;
        }
        if (StringUtil.isEmpty((String)object)) {
            if (StringUtil.isNotEmpty((String)object2)) {
                RubocopResponse rubocopResponse5 = RubocopResponse.a(context.getProject(), RBundle.message((String)"inspection.rubocop.error.starting.no.details"), StringUtil.trimLog((String)object2, (int)1024));
                if (rubocopResponse5 == null) {
                    RubocopResponse.a(6);
                }
                return rubocopResponse5;
            }
            a.debug("Empty output");
            RubocopResponse rubocopResponse6 = b;
            if (rubocopResponse6 == null) {
                RubocopResponse.a(7);
            }
            return rubocopResponse6;
        }
        try {
            rubocopResponse = (RubocopResponse)new Gson().fromJson((String)object, RubocopResponse.class);
        }
        catch (Exception exception) {
            RubocopResponse rubocopResponse7 = RubocopResponse.a(context.getProject(), RBundle.message((String)"inspection.rubocop.error.parsing"), StringUtil.trimLog((String)object, (int)1024));
            if (rubocopResponse7 == null) {
                RubocopResponse.a(9);
            }
            return rubocopResponse7;
        }
        if (rubocopResponse == null) {
            RubocopResponse.a(8);
        }
        return rubocopResponse;
    }

    private static RubocopResponse a(@Nullable Project project, @NotNull String string, @NotNull String string2) {
        long l2 = d ^ 0x4C79A6A9FA51L;
        if (string == null) {
            RubocopResponse.a(10);
        }
        if (string2 == null) {
            RubocopResponse.a(11);
        }
        a.warn(string + "\n" + string2);
        if (project == null) {
            return RubocopResponse.a(string);
        }
        Notifications.Bus.notify((Notification)new Notification(RBundle.message((String)"inspection.rubocop.error.starting.no.details"), string, "", NotificationType.ERROR).addAction(RubocopResponse.b(project, string, string2)).addAction(RubocopExternalAnnotator.createDisableRubocopAction(project)), (Project)project);
        return b;
    }

    @NotNull
    private static AnAction b(final @NotNull Project project, final @NotNull String string, final @NotNull String string2) {
        long l2 = d ^ 0x510ECD0D9DA3L;
        if (project == null) {
            RubocopResponse.a(12);
        }
        if (string == null) {
            RubocopResponse.a(13);
        }
        if (string2 == null) {
            RubocopResponse.a(14);
        }
        AnAction anAction = new AnAction(RBundle.message((String)"inspection.rubocop.details")){
            private static final long a = la.a(3520883640297778096L, 6998994227147318165L, MethodHandles.lookup().lookupClass()).a(160356761140282L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    1.a(0);
                }
                ExecutionHelper.showExceptions((Project)project, Collections.singletonList(new Exception(string2)), Collections.emptyList(), (String)string, null);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x6819FB0CC4F0L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse$1", "actionPerformed"));
            }
        };
        if (anAction == null) {
            RubocopResponse.a(15);
        }
        return anAction;
    }

    static {
        d = la.a(3258971297904389743L, -3514168700727237241L, MethodHandles.lookup().lookupClass()).a(210313557554434L);
        b = new RubocopResponse();
        a = Logger.getInstance(RubocopResponse.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x3D0B62262AD6L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorResponse";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeWithArguments";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDetailsAction";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createErrorResponse";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeWithArguments";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showErrorAndGetResult";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDetailsAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Location {
        public int line;
        public int column;
        public int length;
        private static final long a = la.a(-8834076809539286698L, -8845003862404957855L, MethodHandles.lookup().lookupClass()).a(117714205384572L);

        Location() {
        }

        @Nullable
        public TextRange getRangeInDocument(@NotNull Document document) {
            if (document == null) {
                Location.a(0);
            }
            if (this.line == 0 || document.getLineCount() < this.line || this.length == 0 || this.column == 0) {
                return null;
            }
            int n2 = document.getLineStartOffset(this.line - 1);
            return TextRange.from((int)(n2 + this.column - 1), (int)this.length);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x47AE92469F1L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse$Location", "getRangeInDocument"));
        }
    }

    static class Offense {
        private static final Map<String, HighlightSeverity> a;
        private static final Set<String> b;
        @Nullable
        public String severity;
        @Nullable
        public String message;
        @Nullable
        public String cop_name;
        @Nullable
        public Boolean corrected;
        @Nullable
        public Location location;
        private static final long c;

        Offense() {
        }

        @Nullable
        public String getDepartmentName() {
            int n2;
            int n3 = n2 = this.cop_name == null ? -1 : this.cop_name.indexOf(47);
            if (n2 == -1) {
                return null;
            }
            return this.cop_name.substring(0, n2);
        }

        @Nullable
        public String getCopName() {
            int n2;
            int n3 = n2 = this.cop_name == null ? -1 : this.cop_name.indexOf(47);
            if (n2 == -1) {
                return null;
            }
            return this.cop_name.substring(n2 + 1);
        }

        @Nullable
        public String getCopFullName() {
            return this.cop_name;
        }

        public void annotateOffense(@NotNull PsiFile psiFile, @NotNull AnnotationHolder holder, @NotNull RubyGemExecutionContext executionContext) {
            long l2 = c ^ 0x4252E39D2F27L;
            if (psiFile == null) {
                Offense.a(0);
            }
            if (holder == null) {
                Offense.a(1);
            }
            if (executionContext == null) {
                Offense.a(2);
            }
            if (this.location == null || StringUtil.isEmpty((String)this.message)) {
                return;
            }
            Project project = psiFile.getProject();
            if (project.isDisposed()) {
                return;
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
            if (document == null) {
                return;
            }
            TextRange textRange = this.location.getRangeInDocument(document);
            if (textRange == null || textRange.isEmpty()) {
                return;
            }
            Annotation annotation = holder.createAnnotation(this.getAnnotationSeverity(), this.a(psiFile, textRange), "RuboCop: " + this.message + " [" + this.cop_name + "]");
            this.a(psiFile, executionContext).forEach(rubocopAutocorrectFix -> annotation.registerFix((IntentionAction)rubocopAutocorrectFix));
        }

        @NotNull
        private List<RubocopAutocorrectFix> a(@NotNull PsiFile psiFile, @NotNull RubyGemExecutionContext rubyGemExecutionContext) {
            String string;
            if (psiFile == null) {
                Offense.a(3);
            }
            if (rubyGemExecutionContext == null) {
                Offense.a(4);
            }
            if (!RubocopOffenses.CORRECTABLE_OFFENSES.contains(string = this.getCopFullName())) {
                List<RubocopAutocorrectFix> list2 = Collections.emptyList();
                if (list2 == null) {
                    Offense.a(5);
                }
                return list2;
            }
            ArrayList<RubocopAutocorrectFix> arrayList = new ArrayList<RubocopAutocorrectFix>();
            arrayList.add(RubocopAutocorrectFix.getQuickFix(psiFile, rubyGemExecutionContext, this.getDepartmentName()));
            arrayList.add(RubocopAutocorrectFix.getQuickFix(psiFile, rubyGemExecutionContext, string));
            arrayList.add(RubocopAutocorrectFix.getQuickFix(psiFile, rubyGemExecutionContext, ""));
            ArrayList<RubocopAutocorrectFix> arrayList2 = arrayList;
            if (arrayList2 == null) {
                Offense.a(6);
            }
            return arrayList2;
        }

        @NotNull
        public HighlightSeverity getAnnotationSeverity() {
            HighlightSeverity highlightSeverity = a.get(this.severity);
            HighlightSeverity highlightSeverity2 = highlightSeverity == null ? HighlightSeverity.ERROR : highlightSeverity;
            if (highlightSeverity2 == null) {
                Offense.a(7);
            }
            return highlightSeverity2;
        }

        private TextRange a(@NotNull PsiFile psiFile, @NotNull TextRange textRange) {
            if (psiFile == null) {
                Offense.a(8);
            }
            if (textRange == null) {
                Offense.a(9);
            }
            if (!b.contains(this.cop_name)) {
                return textRange;
            }
            int n2 = textRange.getStartOffset();
            PsiElement psiElement = psiFile.getViewProvider().findElementAt(n2, (Language)RubyLanguage.INSTANCE);
            if (psiElement == null) {
                return textRange;
            }
            PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiNamedElement.class);
            if (psiElement2 == null || psiElement2.getTextRange().getStartOffset() != n2) {
                return psiElement.getTextRange();
            }
            RPsiElement rPsiElement = null;
            if (psiElement2 instanceof RContainerBase) {
                rPsiElement = ((RContainerBase)psiElement2).getNameElement();
            }
            return rPsiElement == null ? psiElement.getTextRange() : rPsiElement.getTextRange();
        }

        static {
            c = la.a(2145693020951576062L, 8090886498282613214L, MethodHandles.lookup().lookupClass()).a(25940582215032L);
            long l2 = c ^ 0x3DE25E8FC28AL;
            a = new THashMap();
            b = new THashSet(Arrays.asList("Metrics/MethodLength", "Metrics/ModuleLength", "Metrics/ClassLength", "Metrics/BlockLength", "Metrics/AbcSize", "Metrics/CyclomaticComplexity", "Metrics/PerceivedComplexity"));
            a.put("refactor", HighlightSeverity.WEAK_WARNING);
            a.put("convention", HighlightSeverity.WEAK_WARNING);
            a.put("warning", HighlightSeverity.WARNING);
            a.put("error", HighlightSeverity.ERROR);
            a.put("fatal", HighlightSeverity.ERROR);
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x3CCBFB5A59E0L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executionContext";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gemExecutionContext";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse$Offense";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse$Offense";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuickFixes";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotationSeverity";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "annotateOffense";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getQuickFixes";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustRangeInDocument";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class File {
        @Nullable
        public String path;
        @Nullable
        public List<Offense> offenses;
        private static final long a = la.a(8503574193056682575L, 2598328642503855735L, MethodHandles.lookup().lookupClass()).a(180311843439825L);

        File() {
        }

        public void annotateOffenses(@NotNull PsiFile psiFile, @NotNull AnnotationHolder holder, @NotNull RubyGemExecutionContext executionContext) {
            if (psiFile == null) {
                File.a(0);
            }
            if (holder == null) {
                File.a(1);
            }
            if (executionContext == null) {
                File.a(2);
            }
            if (this.offenses == null || this.offenses.isEmpty()) {
                return;
            }
            for (Offense offense : this.offenses) {
                offense.annotateOffense(psiFile, holder, executionContext);
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x6B001279CD85L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executionContext";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse$File";
            objectArray[2] = "annotateOffenses";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Summary {
        public int offense_count;
        public int target_file_count;
        public int inspected_file_count;

        Summary() {
        }
    }

    static class Metadata {
        @Nullable
        public String rubocop_version;
        @Nullable
        public String ruby_engine;
        @Nullable
        public String ruby_version;
        @Nullable
        public String ruby_patchlevel;
        @Nullable
        public String ruby_platform;

        Metadata() {
        }
    }
}

