/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.util.tracer;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Timed;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Time;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.idea.perforce.util.tracer.AverageByKindTimeStatistics;
import org.jetbrains.idea.perforce.util.tracer.StatisticsPresentation;

class AverageByKindTimePresentation<Kind extends Enum>
implements StatisticsPresentation<AverageByKindTimeStatistics<Kind>> {
    private static final NumberFormat ourNumberFormat = new DecimalFormat("0.00");

    AverageByKindTimePresentation() {
    }

    @Override
    public void putSelf(StringBuilder sb, AverageByKindTimeStatistics<Kind> statistics) {
        AverageByKindTimeStatistics.Average average = (AverageByKindTimeStatistics.Average)statistics.getAverage();
        sb.append("Average execution time by call types\nAverage:\n");
        Map averageMap = average.getMap();
        ArrayList kinds = new ArrayList(averageMap.keySet());
        Collections.sort(kinds);
        for (Enum kind : kinds) {
            Pair<BigDecimal, Long> pair = averageMap.get(kind);
            sb.append(kind).append(": ").append(ourNumberFormat.format(((BigDecimal)pair.getFirst()).divide(new BigDecimal((Long)pair.getSecond()), RoundingMode.HALF_DOWN))).append(" ms\n");
        }
        List list = statistics.receiveRecentComplete();
        sb.append("\nRecent calls times:\n");
        for (Timed dataTimed : list) {
            sb.append("Statistics at ").append(new Time(dataTimed.getTime()));
            Map map = ((AverageByKindTimeStatistics.Data)dataTimed.getT()).getMap();
            for (Enum kind : kinds) {
                Pair<Long, Integer> pair = map.get(kind);
                if (pair == null) continue;
                sb.append(kind).append(": ").append(ourNumberFormat.format((Long)pair.getFirst() / (long)((Integer)pair.getSecond()).intValue())).append(" ms\n");
            }
        }
    }
}

