/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.reference.SoftReference;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorNotificationsImpl
extends EditorNotifications {
    private static final Key<WeakReference<ProgressIndicator>> CURRENT_UPDATES = Key.create((String)"CURRENT_UPDATES");
    private static final ExecutorService ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"EditorNotificationsImpl Pool");
    private final MergingUpdateQueue myUpdateMerger;
    @NotNull
    private final Project myProject;

    public EditorNotificationsImpl(@NotNull Project project) {
        if (project == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(0);
        }
        this.myUpdateMerger = new MergingUpdateQueue("EditorNotifications update merger", 100, true, null, (Disposable)project);
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                EditorNotificationsImpl.this.updateNotifications(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/EditorNotificationsImpl$1";
                objectArray[2] = "fileOpened";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }

            public void exitDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }
        });
    }

    public void updateNotifications(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(1);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            ProgressIndicator indicator;
            if (file2 == null) {
                EditorNotificationsImpl.$$$reportNull$$$0(6);
            }
            if ((indicator = EditorNotificationsImpl.getCurrentProgress(file2)) != null) {
                indicator.cancel();
            }
            file2.putUserData(CURRENT_UPDATES, null);
            if (this.myProject.isDisposed() || !file2.isValid()) {
                return;
            }
            indicator = new ProgressIndicatorBase();
            ReadTask task = this.createTask(indicator, file2);
            if (task == null) {
                return;
            }
            file2.putUserData(CURRENT_UPDATES, new WeakReference<ProgressIndicator>(indicator));
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ReadTask.Continuation continuation = task.performInReadAction(indicator);
                if (continuation != null) {
                    continuation.getAction().run();
                }
            } else {
                ProgressIndicatorUtils.scheduleWithWriteActionPriority(indicator, ourExecutor, task);
            }
        });
    }

    @Nullable
    private ReadTask createTask(final @NotNull ProgressIndicator indicator, final @NotNull VirtualFile file2) {
        List editors;
        if (indicator == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(3);
        }
        if ((editors = ContainerUtil.filter((Object[])FileEditorManager.getInstance((Project)this.myProject).getAllEditors(file2), editor -> !(editor instanceof TextEditor) || AsyncEditorLoader.isEditorLoaded(((TextEditor)editor).getEditor()))).isEmpty()) {
            return null;
        }
        return new ReadTask(){

            private boolean isOutdated() {
                if (EditorNotificationsImpl.this.myProject.isDisposed() || !file2.isValid() || indicator != EditorNotificationsImpl.getCurrentProgress(file2)) {
                    return true;
                }
                for (FileEditor editor : editors) {
                    if (editor.isValid()) continue;
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator2) throws ProcessCanceledException {
                if (indicator2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (this.isOutdated()) {
                    return null;
                }
                List providers = DumbService.getInstance((Project)EditorNotificationsImpl.this.myProject).filterByDumbAwareness((Collection)EditorNotifications.EXTENSION_POINT_NAME.getExtensionList((AreaInstance)EditorNotificationsImpl.this.myProject));
                SmartList updates = new SmartList();
                for (FileEditor editor : editors) {
                    for (EditorNotifications.Provider provider : providers) {
                        JComponent component = provider.createNotificationPanel(file2, editor);
                        updates.add(() -> EditorNotificationsImpl.this.updateNotification(editor, (Key<? extends JComponent>)provider.getKey(), component));
                    }
                }
                return new ReadTask.Continuation(() -> this.lambda$performInReadAction$1(file2, (List)updates), ModalityState.any());
            }

            @Override
            public void onCanceled(@NotNull ProgressIndicator ignored) {
                if (ignored == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (EditorNotificationsImpl.getCurrentProgress(file2) == indicator) {
                    EditorNotificationsImpl.this.updateNotifications(file2);
                }
            }

            private /* synthetic */ void lambda$performInReadAction$1(@NotNull VirtualFile file22, List updates) {
                if (file22 == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (!this.isOutdated()) {
                    file22.putUserData(CURRENT_UPDATES, null);
                    for (Runnable update : updates) {
                        update.run();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ignored";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/EditorNotificationsImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performInReadAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onCanceled";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$performInReadAction$1";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static ProgressIndicator getCurrentProgress(VirtualFile file2) {
        return (ProgressIndicator)SoftReference.dereference((Reference)((Reference)file2.getUserData(CURRENT_UPDATES)));
    }

    private void updateNotification(@NotNull FileEditor editor, @NotNull Key<? extends JComponent> key, @Nullable JComponent component) {
        JComponent old;
        if (editor == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(4);
        }
        if (key == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(5);
        }
        if ((old = (JComponent)editor.getUserData(key)) != null) {
            FileEditorManager.getInstance((Project)this.myProject).removeTopComponent(editor, old);
        }
        if (component != null) {
            FileEditorManager.getInstance((Project)this.myProject).addTopComponent(editor, component);
            Key<? extends JComponent> _key = key;
            editor.putUserData(_key, (Object)component);
        } else {
            editor.putUserData(key, null);
        }
    }

    public void updateAllNotifications() {
        this.myUpdateMerger.queue(new Update("update"){

            public void run() {
                for (VirtualFile file2 : FileEditorManager.getInstance((Project)EditorNotificationsImpl.this.myProject).getOpenFiles()) {
                    EditorNotificationsImpl.this.updateNotifications(file2);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/EditorNotificationsImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNotifications";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createTask";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNotification";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateNotifications$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RefactoringListenerProvider
    implements RefactoringElementListenerProvider {
        @Nullable
        public RefactoringElementListener getListener(final @NotNull PsiElement element) {
            if (element == null) {
                RefactoringListenerProvider.$$$reportNull$$$0(0);
            }
            if (element instanceof PsiFile) {
                return new RefactoringElementAdapter(){

                    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        VirtualFile vFile;
                        if (newElement == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (newElement instanceof PsiFile && (vFile = newElement.getContainingFile().getVirtualFile()) != null) {
                            EditorNotifications.getInstance((Project)element.getProject()).updateNotifications(vFile);
                        }
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        if (newElement == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (oldQualifiedName == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        this.elementRenamedOrMoved(newElement);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newElement";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "oldQualifiedName";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/ui/EditorNotificationsImpl$RefactoringListenerProvider$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "elementRenamedOrMoved";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "undoElementMovedOrRenamed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ui/EditorNotificationsImpl$RefactoringListenerProvider", "getListener"));
        }
    }
}

