/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.NumberDomain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2Domains
extends DomainRegistry {
    private static final short MAX_DB2_GRAPHIC = 127;
    private static final short MAX_VARGRAPHIC = 16336;
    private static final short MAX_DECIMAL_PRECISION = 31;
    private static final double MIN_DOUBLE = -7.2E75;
    private static final double MAX_DOUBLE = 7.2E75;
    private static final int DB2_MAX_TS_PRECISION = 12;
    private static final int MAX_VARCHAR_LENGTH = 32672;
    private static final int DBCLOB = 0x3FFFFFFF;

    public Db2Domains() {
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new TextDomain("vargraphic", ConversionPoint.TEXT_GRAPHIC, 16336L, TextDomain.Length.mandatory(16336L)));
        this.add(new TextDomain("graphic", ConversionPoint.TEXT_GRAPHIC, 127L, -1L, true));
        this.add(new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, 31, 31, true));
        this.add(new Number2Domain("numeric", ConversionPoint.BIG_DECIMAL, 31, 31, true));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -7.2E75, 7.2E75));
        this.add(new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -7.2E75, 7.2E75));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -7.2E75, 7.2E75));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 0, -1, false));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 12, -1, true));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 32672L, TextDomain.Length.mandatory(32672L)));
        this.add(new TextDomain("clob", ConversionPoint.CLOB, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("dbclob", ConversionPoint.CLOB, 0x3FFFFFFFL, -1L, true));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 127L, 1L, true));
        this.add(new TextDomain("character", ConversionPoint.CHAR, 127L, 1L, true));
        this.add(new TextDomain("xml", ConversionPoint.XML, Integer.MAX_VALUE));
        this.add(new DecfloatDomain(34));
    }

    private static class DecfloatDomain
    extends NumberDomain {
        private static final int DEFAULT_DIGITS = 16;
        private static final int MAX_DIGITS = 34;
        private static final DomainRegistry.Limits LIMITS = new DomainRegistry.Limits(new DomainRegistry.Limit(16, 384, 384), new DomainRegistry.Limit(34, 6143, 6143));
        private final int myDigits;

        protected DecfloatDomain(int digits) {
            super("decfloat", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE);
            this.myDigits = digits;
        }

        @Override
        @NotNull
        public Cardinality cardinality() {
            Cardinality.ScalableCardinality scalableCardinality = new Cardinality.ScalableCardinality(this.myDigits);
            if (scalableCardinality == null) {
                DecfloatDomain.$$$reportNull$$$0(0);
            }
            return scalableCardinality;
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull Domain domain) {
            if (domain == null) {
                DecfloatDomain.$$$reportNull$$$0(1);
            }
            DecfloatDomain decfloatDomain = domain instanceof Number2Domain ? new DecfloatDomain(LIMITS.minParameterValue(((Number2Domain)domain).getMaxPrecision()).intValue()) : (domain instanceof NumberDomain ? new DecfloatDomain(34) : this);
            if (decfloatDomain == null) {
                DecfloatDomain.$$$reportNull$$$0(2);
            }
            return decfloatDomain;
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull SizeProvider provider) {
            if (provider == null) {
                DecfloatDomain.$$$reportNull$$$0(3);
            }
            DecfloatDomain decfloatDomain = new DecfloatDomain(LIMITS.minParameterValue(provider.getSize()).intValue());
            if (decfloatDomain == null) {
                DecfloatDomain.$$$reportNull$$$0(4);
            }
            return decfloatDomain;
        }

        @Override
        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                DecfloatDomain.$$$reportNull$$$0(5);
            }
            Compatibility compatibility = domain instanceof DecfloatDomain ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : (domain instanceof Number2Domain || domain instanceof NumberDomain ? Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.uncompatible());
            if (compatibility == null) {
                DecfloatDomain.$$$reportNull$$$0(6);
            }
            return compatibility;
        }

        @Override
        @Nullable
        public Object trim(@NotNull Object o) {
            if (o == null) {
                DecfloatDomain.$$$reportNull$$$0(7);
            }
            return o;
        }

        @Override
        @NotNull
        public String name() {
            String string = super.name() + (this.myDigits == 16 ? "" : String.format("(%s)", this.myDigits));
            if (string == null) {
                DecfloatDomain.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/db2/Db2Domains$DecfloatDomain";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cardinality";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/db2/Db2Domains$DecfloatDomain";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "narrow";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompatibility";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "narrow";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompatibility";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "trim";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

