/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.cucumber.CucumberUtil;
import org.jetbrains.plugins.ruby.cucumber.run.BaseCucumberRunConfiguration;
import org.jetbrains.plugins.ruby.cucumber.run.BaseCucumberRunConfigurationUtil;
import org.jetbrains.plugins.ruby.cucumber.run.CucumberRunCommandLineState;
import org.jetbrains.plugins.ruby.cucumber.run.CucumberRunConfigurationEditor;
import org.jetbrains.plugins.ruby.cucumber.run.CucumberRunConfigurationExternalizer;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractTestRunConfigurationWithTestPath;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.testing.PreloadedTestRunConfiguration;

public class CucumberRunConfiguration
extends AbstractTestRunConfigurationWithTestPath<CucumberRunConfiguration>
implements BaseCucumberRunConfiguration,
PreloadedTestRunConfiguration {
    @NonNls
    public static final String DEFAULT_TESTS_SEARCH_MASK = "**/*." + GherkinFileType.INSTANCE.getDefaultExtension();
    private String myRunnerArgs = "";
    private String myNamesFilter = "";
    private String myTagsFilter = "";
    private boolean myVerboseEnabled = false;
    private boolean myBacktraceEnabled = false;
    @NotNull
    private PreLoadUtil.PreLoadServer myPreloadServer = PreLoadUtil.PreLoadServer.None;
    private boolean myUseCustomCucumberRunner = false;
    private String myCustomCucumberRunnerPath = "";

    public CucumberRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
        this.registerLog("RUBY_CUCUMBER");
    }

    protected String getSerializationId() {
        return "CUCUMBER_RUN_CONFIG_SETTINGS_ID";
    }

    protected void validateConfiguration(boolean isExecution) throws Exception {
        RunConfigurationUtil.inspectSDK((AbstractRubyRunConfiguration)this, (boolean)isExecution);
        RunConfigurationUtil.inspectWorkingDirectory((boolean)false, (AbstractRubyRunConfigurationParams)this, (boolean)isExecution);
        BaseCucumberRunConfigurationUtil.inspectFeatureFileOrFolderPath(this, isExecution);
        BaseCucumberRunConfigurationUtil.inspectTagsFilter(this, isExecution);
        this.inspectConfiguredCucumberSupport(isExecution);
        if (this.shouldUseCustomCucumberRunner()) {
            this.inspectCustomRunnerScript(isExecution);
        } else {
            this.inspectCucumberExecutable(isExecution);
        }
        this.inspectCucumberVersion(isExecution);
    }

    private void inspectCustomRunnerScript(boolean isExecution) throws Exception {
        VirtualFile script;
        String scriptPath = this.getCustomCucumberRunnerPath().trim();
        if (StringUtil.isEmpty((String)scriptPath)) {
            RunConfigurationUtil.throwExecutionOrRuntimeException((String)RBundle.message((String)"cucumber.run.configuration.test.custom.runner.not.exists"), (boolean)isExecution);
        }
        if ((script = LocalFileSystem.getInstance().findFileByPath(scriptPath)) == null || !script.exists()) {
            RunConfigurationUtil.throwExecutionOrRuntimeException((String)RBundle.message((String)"cucumber.run.configuration.test.custom.runner.not.exists"), (boolean)isExecution);
        }
        if (script.isDirectory()) {
            RunConfigurationUtil.throwExecutionOrRuntimeException((String)RBundle.message((String)"cucumber.run.configuration.test.script.is.dir", (Object[])new Object[]{scriptPath}), (boolean)isExecution);
        }
    }

    private void inspectCucumberVersion(boolean isExecution) throws Exception {
        Sdk sdk = this.getSdk();
        if (sdk == null) {
            return;
        }
        if (!CucumberRunCommandLineState.isGUIRunnerEnabled(this)) {
            return;
        }
        if (this.shouldUseAlternativeSdk()) {
            if (!this.shouldUseCustomCucumberRunner()) {
                GemInfo installedCucumberGem = CucumberUtil.findLatestCucumberGemIn(this.getModule(), sdk);
                if (installedCucumberGem != null) {
                    if (!CucumberUtil.checkIfVersionIsSupported(installedCucumberGem.getVersion())) {
                        String msg = RBundle.message((String)"cucumber.run.configuration.cucumber.gem.version.isnt.supported", (Object[])new Object[]{installedCucumberGem, CucumberUtil.getMinimalSupportedVersion(), sdk.getName()});
                        RunConfigurationUtil.throwExecutionOrRuntimeException((String)msg, (boolean)isExecution);
                    }
                } else {
                    String msg = RBundle.message((String)"cucumber.run.configuration.test.no.gem.in.sdk", (Object[])new Object[]{sdk.getName()});
                    RunConfigurationUtil.throwExecutionOrRuntimeException((String)msg, (boolean)isExecution);
                }
            }
        } else {
            String attachedCucumberGemVersion;
            GemInfo attachedCucumberGem;
            Module module = this.getModule();
            if (module != null && (attachedCucumberGem = CucumberUtil.getAttachedCucumberGem(module)) != null && !CucumberUtil.checkIfVersionIsSupported(attachedCucumberGemVersion = attachedCucumberGem.getVersion())) {
                String msg = RBundle.message((String)"cucumber.run.configuration.cucumber.gem.version.isnt.supported", (Object[])new Object[]{attachedCucumberGemVersion, CucumberUtil.getMinimalSupportedVersion(), sdk.getName()});
                RunConfigurationUtil.throwExecutionOrRuntimeException((String)msg, (boolean)isExecution);
            }
        }
    }

    private void inspectConfiguredCucumberSupport(boolean isExecution) throws Exception {
        Module module = this.getModule();
        if (module == null) {
            return;
        }
        Sdk sdk = this.getSdk();
        assert (sdk != null);
        if (RailsFacetUtil.hasRailsSupport((Module)module) && RailsUtil.isRails3OrNewerApplication((Module)module)) {
            if (!CucumberUtil.isCucumberRailsSupportProbablyEnabled(module, sdk)) {
                String msg = RBundle.message((String)"cucumber.run.configuration.cucumber.rails.support.isnt.attached");
                RunConfigurationUtil.throwExecutionOrRuntimeException((String)msg, (boolean)isExecution);
            }
            return;
        }
    }

    private void inspectCucumberExecutable(boolean isExecution) throws Exception {
        if (!this.shouldUseCustomCucumberRunner()) {
            Sdk sdkForModule;
            String cucumberExecutablePath;
            Module module = this.getModule();
            if (module != null && RailsFacetUtil.hasRailsSupport((Module)module)) {
                if (!CucumberUtil.isCucumberScriptSupportInstalledInRailsProject(module)) {
                    String msg = RBundle.message((String)"cucumber.run.configuration.test.no.rails.cucumber.scrip.error.run.generator", (Object[])new Object[]{CucumberRunConfiguration.getRailsCucumberInitializerGeneratorName(module)});
                    RunConfigurationUtil.throwExecutionOrRuntimeException((String)msg, (boolean)isExecution);
                } else {
                    return;
                }
            }
            if ((cucumberExecutablePath = CucumberUtil.determinePreferredCucumberExecutablePath(module, this.getAlternativeSdk())) != null) {
                return;
            }
            Sdk alternativeSdk = this.getAlternativeSdk();
            if (alternativeSdk != null) {
                String msg = RBundle.message((String)"cucumber.run.configuration.test.no.gem.in.sdk", (Object[])new Object[]{alternativeSdk.getName()});
                RunConfigurationUtil.throwExecutionOrRuntimeException((String)msg, (boolean)isExecution);
            }
            if (module != null && (sdkForModule = RModuleUtil.getInstance().findRubySdkForModule(module)) != null) {
                String msg = RBundle.message((String)"cucumber.run.configuration.test.no.gem.in.sdk", (Object[])new Object[]{sdkForModule.getName()});
                RunConfigurationUtil.throwExecutionOrRuntimeException((String)msg, (boolean)isExecution);
            }
            RunConfigurationUtil.throwExecutionOrRuntimeException((String)RBundle.message((String)"jdk.no.specified"), (boolean)isExecution);
        }
    }

    @NotNull
    protected SettingsEditor<CucumberRunConfiguration> createConfigurationEditor() {
        CucumberRunConfigurationEditor cucumberRunConfigurationEditor = new CucumberRunConfigurationEditor(this.getProject(), this);
        if (cucumberRunConfigurationEditor == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(0);
        }
        return cucumberRunConfigurationEditor;
    }

    protected RunProfileState createCommandLineState(@NotNull ExecutionEnvironment env) throws ExecutionException {
        if (env == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(1);
        }
        return new CucumberRunCommandLineState(this, env);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(2);
        }
        super.readExternal(element);
        CucumberRunConfigurationExternalizer.getInstance().readExternal(this, element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        CucumberRunConfigurationExternalizer.getInstance().writeExternal(this, element);
    }

    @Override
    public String getTagsFilters() {
        return this.myTagsFilter;
    }

    @Override
    public void setTagsFilter(String tagsFilter) {
        this.myTagsFilter = StringUtil.notNullize((String)tagsFilter);
    }

    @Override
    public String getFeatureElementNameFilter() {
        return this.myNamesFilter;
    }

    @Override
    public void setFeatureElementNameFilter(String nameFilter) {
        this.myNamesFilter = StringUtil.notNullize((String)nameFilter);
    }

    @Override
    public String getRunnerOptions() {
        return this.myRunnerArgs;
    }

    @Override
    public void setRunnerOptions(String specArgs) {
        this.myRunnerArgs = StringUtil.notNullize((String)specArgs);
    }

    @Override
    public boolean isBacktraceEnabled() {
        return this.myBacktraceEnabled;
    }

    @Override
    public void setBacktraceEnabled(boolean enabled) {
        this.myBacktraceEnabled = enabled;
    }

    @Override
    public boolean isVerboseEnabled() {
        return this.myVerboseEnabled;
    }

    @Override
    public void setVerboseEnabled(boolean isEnabled) {
        this.myVerboseEnabled = isEnabled;
    }

    protected String getLogTitle() {
        return RBundle.message((String)"cucumber.run.configuration.log.tab.name");
    }

    @NotNull
    protected String getDefaultLogFileName() {
        if ("cucumber.log" == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(4);
        }
        return "cucumber.log";
    }

    @Override
    public String getCustomCucumberRunnerPath() {
        return StringUtil.notNullize((String)this.myCustomCucumberRunnerPath).trim();
    }

    @Override
    public void setCustomCucumberRunnerPath(String specsRunnerPath) {
        this.myCustomCucumberRunnerPath = CucumberRunConfiguration.asSysIndependentPath((String)specsRunnerPath);
    }

    @Override
    public void setShouldUseCustomCucumberRunner(boolean useCustomRunner) {
        this.myUseCustomCucumberRunner = useCustomRunner;
    }

    @Override
    public boolean shouldUseCustomCucumberRunner() {
        return this.myUseCustomCucumberRunner;
    }

    @Override
    @NotNull
    public PreLoadUtil.PreLoadServer getPreloadServer() {
        PreLoadUtil.PreLoadServer preLoadServer = this.myPreloadServer;
        if (preLoadServer == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(5);
        }
        return preLoadServer;
    }

    @Override
    public void setPreloadServer(@NotNull PreLoadUtil.PreLoadServer server) {
        if (server == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(6);
        }
        this.myPreloadServer = server;
    }

    public boolean isBundlerContextAllowed() {
        return CucumberRunConfiguration.isBundlerContextAllowed((PreLoadUtil.PreLoadServer)this.getPreloadServer(), (Module)this.getModule());
    }

    private static String getRailsCucumberInitializerGeneratorName(Module module) {
        return RailsUtil.isRails3OrNewerApplication((Module)module) ? "cucumber:install" : "cucumber";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/cucumber/run/CucumberRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurationEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/run/CucumberRunConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLogFileName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreloadServer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLineState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPreloadServer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

