/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim.parser;

import com.intellij.indentation.IndentationParser;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.slim.SlimUtil;
import org.jetbrains.plugins.slim.psi.SlimElementTypes;
import org.jetbrains.plugins.slim.psi.SlimTokenTypes;

public final class SlimParser
extends IndentationParser {
    public SlimParser(@Nullable List<? extends IElementType> containerTypes) {
        super(SlimElementTypes.SLIM_DOCUMENT, SlimElementTypes.SLIM_TAG, SlimTokenTypes.EOL, SlimTokenTypes.INDENT, containerTypes);
    }

    @Nullable
    private static IElementType getTemplateEngineLanguage() {
        return SlimUtil.getOuterLanguageTokenType();
    }

    protected void closeBlock(@NotNull PsiBuilder builder, @NotNull PsiBuilder.Marker marker, @Nullable IElementType startTokenType) {
        if (builder == null) {
            SlimParser.$$$reportNull$$$0(0);
        }
        if (marker == null) {
            SlimParser.$$$reportNull$$$0(1);
        }
        if (startTokenType == SlimTokenTypes.DOCTYPE_KWD) {
            marker.drop();
            return;
        }
        if (startTokenType == SlimTokenTypes.FILTER) {
            marker.done(SlimElementTypes.SLIM_FILTER);
            return;
        }
        builder.mark().done(SlimElementTypes.XML_END_TAG_START);
        builder.mark().done(SlimElementTypes.XML_TAG_END);
        super.closeBlock(builder, marker, startTokenType);
    }

    protected void advanceLexer(@NotNull PsiBuilder builder) {
        IElementType tokenType;
        if (builder == null) {
            SlimParser.$$$reportNull$$$0(2);
        }
        if ((tokenType = builder.getTokenType()) == SlimTokenTypes.ATTR_NAME) {
            SlimParser.parseAttr(builder);
        } else if (SlimTokenTypes.DOCTYPE_KWD == tokenType) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            IElementType type = builder.getTokenType();
            if (type != SlimTokenTypes.DOCTYPE) {
                builder.error("Doctype specification expected");
            }
            builder.advanceLexer();
            mark.done(SlimElementTypes.SLIM_DOCTYPE);
        } else if (tokenType == SlimTokenTypes.CLASS_START || tokenType == SlimTokenTypes.ID_START) {
            PsiBuilder.Marker argument = builder.mark();
            builder.advanceLexer();
            builder.mark().done(SlimElementTypes.SLIM_CLASS_OR_ID);
            PsiBuilder.Marker value = builder.mark();
            IElementType type = builder.getTokenType();
            if (type == SlimTokenTypes.ID || type == SlimTokenTypes.CLASS) {
                builder.advanceLexer();
            } else {
                builder.error("Expected " + ("#".equals(builder.getTokenText()) ? "id " : "class") + " name");
            }
            value.done(SlimElementTypes.SLIM_ARGUMENT_VALUE);
            argument.done(SlimElementTypes.SLIM_ARGUMENT);
        } else if (tokenType == SlimTokenTypes.ATTRIBUTE_SHORTCUT) {
            PsiBuilder.Marker attributeMarker = builder.mark();
            PsiBuilder.Marker attributeNameMarker = builder.mark();
            builder.advanceLexer();
            builder.advanceLexer();
            attributeNameMarker.done(SlimElementTypes.SLIM_ATTR_NAME);
            if (SlimTokenTypes.EQUALS == builder.getTokenType()) {
                builder.advanceLexer();
                SlimParser.parseValue(builder);
            }
            attributeMarker.done(SlimElementTypes.SLIM_ARGUMENT);
        } else {
            super.advanceLexer(builder);
        }
    }

    protected boolean isCustomTagDelimiter(IElementType type) {
        return type == SlimTokenTypes.COLON;
    }

    private static void parseAttr(PsiBuilder builder) {
        PsiBuilder.Marker attrMark = builder.mark();
        PsiBuilder.Marker attrNameMark = builder.mark();
        builder.advanceLexer();
        attrNameMark.done(SlimElementTypes.SLIM_ATTR_NAME);
        IElementType type = builder.getTokenType();
        if (SlimTokenTypes.EQUALS == type) {
            builder.advanceLexer();
            SlimParser.parseValue(builder);
        }
        attrMark.done(SlimElementTypes.SLIM_ARGUMENT);
    }

    private static void parseValue(PsiBuilder builder) {
        IElementType type = builder.getTokenType();
        if (XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER.equals(type)) {
            SlimParser.parseString(builder);
        } else if (type == SlimParser.getTemplateEngineLanguage()) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            mark.done(SlimElementTypes.SLIM_ARGUMENT_VALUE);
        } else if (type == SlimTokenTypes.OPEN_BRACE) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            if (builder.getTokenType() == SlimParser.getTemplateEngineLanguage()) {
                builder.advanceLexer();
            }
            if (builder.getTokenType() == SlimTokenTypes.CLOSE_BRACE) {
                builder.advanceLexer();
            } else {
                builder.error("Unclosed wrapped attribute value");
            }
            mark.done(SlimElementTypes.SLIM_ARGUMENT_VALUE);
        } else {
            builder.error("Expected argument value");
        }
    }

    private static void parseString(@NotNull PsiBuilder builder) {
        if (builder == null) {
            SlimParser.$$$reportNull$$$0(3);
        }
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        IElementType type = builder.getTokenType();
        while (type != null && (type == SlimTokenTypes.STRING_LITERAL || type == SlimParser.getTemplateEngineLanguage() || type == SlimTokenTypes.INTERPOLATION_START || type == SlimTokenTypes.INTERPOLATION_END || type == SlimTokenTypes.UNESCAPED_INTERPOLATION_START || type == SlimTokenTypes.UNESCAPED_INTERPOLATION_END)) {
            builder.advanceLexer();
            type = builder.getTokenType();
        }
        if (type == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
            builder.advanceLexer();
            mark.done(SlimElementTypes.SLIM_ARGUMENT_VALUE);
        } else {
            builder.error("Unclosed string literal");
            mark.done(SlimElementTypes.SLIM_ARGUMENT_VALUE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/slim/parser/SlimParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "closeBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "advanceLexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

