/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryReturnJSInspection
extends JavaScriptInspection
implements CleanupLocalInspectionTool {
    private final UnnecessaryReturnFix fix = new UnnecessaryReturnFix();

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("unnecessary.return.statement.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryReturnJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            UnnecessaryReturnJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("unnecessary.return.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryReturnVisitor();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/control/UnnecessaryReturnJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class UnnecessaryReturnVisitor
    extends BaseInspectionVisitor {
        public void visitJSReturnStatement(@NotNull JSReturnStatement statement) {
            if (statement == null) {
                UnnecessaryReturnVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSReturnStatement(statement);
            if (DialectDetector.isTypeScript((PsiElement)statement)) {
                return;
            }
            JSExpression returnValue = statement.getExpression();
            if (returnValue != null) {
                return;
            }
            JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)statement, JSFunction.class);
            if (function == null) {
                return;
            }
            PsiElement body = function.getLastChild();
            if (body == null) {
                return;
            }
            if (!(body instanceof JSBlockStatement)) {
                return;
            }
            if (ControlFlowUtils.statementCompletesWithStatement((JSStatement)body, (JSStatement)statement)) {
                this.registerStatementError((JSStatement)statement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/UnnecessaryReturnJSInspection$UnnecessaryReturnVisitor", "visitJSReturnStatement"));
        }
    }

    private static class UnnecessaryReturnFix
    extends InspectionJSFix {
        private UnnecessaryReturnFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("remove.unnecessary.return.fix", new Object[0]);
            if (string == null) {
                UnnecessaryReturnFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement returnKeywordElement = descriptor2.getPsiElement();
            PsiElement returnStatement = returnKeywordElement.getParent();
            assert (returnStatement != null);
            UnnecessaryReturnFix.deleteElement(returnStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryReturnJSInspection$UnnecessaryReturnFix", "getFamilyName"));
        }
    }
}

