/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CastToList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class CastableToList
extends UnaryExpression {
    private ListType targetType;
    private boolean allowEmpty;
    private NamespaceResolver nsResolver = null;

    public CastableToList(Expression source, ListType targetType, boolean allowEmpty) {
        super(source);
        this.targetType = targetType;
        this.allowEmpty = allowEmpty;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public ListType getTargetType() {
        return this.targetType;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.nsResolver;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.targetType.isNamespaceSensitive()) {
            StaticContext env = visitor.getStaticContext();
            this.nsResolver = env.getNamespaceResolver();
        }
        this.operand = visitor.simplify(this.operand);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        boolean maybeUntyped;
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        SequenceType atomicType = SequenceType.makeSequenceType(BuiltInAtomicType.STRING, this.allowEmpty ? 24576 : 16384);
        RoleLocator role = new RoleLocator(2, "castable as", 0);
        this.operand = TypeChecker.staticTypeCheck(this.operand, atomicType, false, role, visitor);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        boolean maybeString = th.relationship(this.operand.getItemType(th), BuiltInAtomicType.STRING) != 4;
        boolean bl = maybeUntyped = th.relationship(this.operand.getItemType(th), BuiltInAtomicType.UNTYPED_ATOMIC) != 4;
        if (!maybeString && !maybeUntyped) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        if (this.operand instanceof Literal) {
            GroundedValue literalOperand = ((Literal)this.operand).getValue();
            if (literalOperand instanceof AtomicValue) {
                return Literal.makeLiteral(BooleanValue.get(this.effectiveBooleanValue(visitor.getStaticContext().makeEarlyEvaluationContext())));
            }
            if (literalOperand instanceof EmptySequence) {
                return Literal.makeLiteral(BooleanValue.get(this.allowEmpty));
            }
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression e2 = super.optimize(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        if (!Cardinality.allowsZero(this.operand.getCardinality())) {
            this.allowEmpty = false;
            this.resetLocalStaticProperties();
        }
        return this;
    }

    public int computeCardinality() {
        return 16384;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy() {
        CastableToList c = new CastableToList(this.getBaseExpression().copy(), this.targetType, this.allowEmpty);
        c.nsResolver = this.nsResolver;
        return c;
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        AtomicValue value = (AtomicValue)this.operand.evaluateItem(context);
        if (value == null) {
            return this.allowEmpty;
        }
        try {
            CastToList.cast(value.getStringValue(), this.targetType, this.nsResolver, context.getConfiguration().getConversionRules());
            return true;
        }
        catch (XPathException err) {
            return false;
        }
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.targetType == ((CastableToList)other).targetType && this.allowEmpty == ((CastableToList)other).allowEmpty && this.nsResolver == ((CastableToList)other).nsResolver;
    }

    public int hashCode() {
        return super.hashCode() ^ this.targetType.hashCode();
    }

    public String toString() {
        return this.operand.toString() + " castable as " + this.targetType.getEQName();
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("castableToList");
        out.emitAttribute("as", this.targetType.toString());
        this.operand.explain(out);
        out.endElement();
    }
}

