/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.plaf.ColorUIResource;

public class McWinUtils {
    private McWinUtils() {
    }

    public static void fillComponent(Graphics g, Component c, Color[] colors) {
        int w = c.getWidth();
        int h = c.getHeight();
        JTattooUtilities.fillHorGradient(g, colors, 0, 0, w, h);
        if (AbstractLookAndFeel.getTheme().isBackgroundPatternOn()) {
            Point p = JTattooUtilities.getRelLocation(c);
            ColorUIResource lc = AbstractLookAndFeel.getTheme().getBackgroundColorDark();
            Color lineColor = ColorHelper.brighter(ColorHelper.median(lc, colors[colors.length - 1]), 50.0);
            for (int y = 2 - p.y % 3; y < h; y += 3) {
                g.setColor(lineColor);
                g.drawLine(0, y, w, y);
                lineColor = ColorHelper.darker(lineColor, 1.5);
            }
        }
    }

    public static void fillComponent(Graphics g, Component c) {
        if (AbstractLookAndFeel.getTheme().isBackgroundPatternOn()) {
            int w = c.getWidth();
            int h = c.getHeight();
            Point p = JTattooUtilities.getRelLocation(c);
            g.setColor(AbstractLookAndFeel.getTheme().getBackgroundColorLight());
            g.fillRect(0, 0, w, h);
            g.setColor(AbstractLookAndFeel.getTheme().getBackgroundColorDark());
            for (int y = 2 - p.y % 3; y < h; y += 3) {
                g.drawLine(0, y, w, y);
            }
        } else {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }
}

